/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata.compare;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.XMLToMapTransformer;
import oracle.dbtools.crest.model.metadata.compare.MetaMapSelection;
import oracle.dbtools.crest.model.metadata.compare.MetaPropertiesComparator;
import oracle.dbtools.crest.swingui.TopView;

public class MapCompareBuilder
extends MetaMapSelection
implements MDXMLConstants {
    private Map leftMap = new HashMap();
    private Map rightMap = new HashMap();
    private ClassDescription leftCD;
    private ClassDescription rightCD;
    private MetaMapSelection leftRoot;
    private MetaMapSelection rightRoot;
    private Design design;
    private static String COMPLEX_PRPERTIES = "Complex Properties";
    private static String TO_DELETE = "TO DELETE";
    private static String NEW = "NEW";
    private StorageDesign storageDesign;

    public MapCompareBuilder(Design design, StorageDesign storageDesign, InputStream leftStream, String leftRevision, InputStream rightStream, String rightRevision) throws UnsupportedEncodingException {
        super("");
        this.design = design;
        this.storageDesign = storageDesign;
        boolean compressed = design.isCompressedDesign();
        XMLToMapTransformer.transformToMap(this.leftMap, leftStream, compressed);
        XMLToMapTransformer.transformToMap(this.rightMap, rightStream, compressed);
        this.build(leftRevision, rightRevision);
        this.leftRoot.resetModifiedStatus();
        this.rightRoot.resetModifiedStatus();
    }

    public MetaMapSelection getLeftRoot() {
        return this.leftRoot;
    }

    public MetaMapSelection getRightRoot() {
        return this.rightRoot;
    }

    private void build(String leftRevision, String rightRevision) {
        this.leftCD = this.getClassDecription(this.leftMap);
        this.rightCD = this.getClassDecription(this.rightMap);
        if (this.leftCD != null && this.rightCD != null && this.leftCD == this.rightCD) {
            ClassDescription cd = this.leftCD;
            MetaPropertiesComparator cp = new MetaPropertiesComparator(this.leftMap, this.rightMap, cd, this.design, this.storageDesign);
            this.leftRoot = new MetaMapSelection(this.leftMap);
            this.leftRoot.setPropertiesComparator(cp);
            this.rightRoot = new MetaMapSelection(this.rightMap);
            this.rightRoot.setPropertiesComparator(cp);
            this.leftRoot.setCorrespondentNode(this.rightRoot);
            this.rightRoot.setCorrespondentNode(this.leftRoot);
            this.leftRoot.setName(this.leftRoot.getName() + " (" + leftRevision + ")");
            this.rightRoot.setName(this.rightRoot.getName() + " (" + rightRevision + ")");
            this.addStructure(this.leftRoot, this.rightRoot, cd, this.leftMap, this.rightMap);
        }
    }

    private void addStructure(MetaMapSelection lsel, MetaMapSelection rsel, ClassDescription cd, Map lmap, Map rmap) {
        this.processComplexPeoperties(lsel, rsel, cd, lmap, rmap);
        for (ClassDescription.CollectionDescription cold : cd.getOrderedCollectionsList("compare/v")) {
            List left = null;
            boolean hasLeft = true;
            if (lmap == null) {
                hasLeft = false;
            }
            if (lmap != null) {
                left = (List)lmap.get(cold.xmlName);
            }
            if (left == null) {
                left = Collections.EMPTY_LIST;
                hasLeft = false;
            }
            ArrayList right = null;
            if (rmap != null) {
                right = (ArrayList)rmap.get(cold.xmlName);
            }
            if (right == null) {
                if (hasLeft && rmap != null) {
                    right = new ArrayList();
                    rmap.put(cold.xmlName, right);
                } else {
                    right = Collections.EMPTY_LIST;
                }
            }
            if (left.size() <= 0 && right.size() <= 0) continue;
            MetaMapSelection lms = new MetaMapSelection(cold.xmlName);
            MetaMapSelection rms = new MetaMapSelection(cold.xmlName);
            lms.setCorrespondentNode(rms);
            rms.setCorrespondentNode(lms);
            lms.setEmptyComparator();
            rms.setEmptyComparator();
            lms.setCollectionDescription(cold);
            rms.setCollectionDescription(cold);
            lms.setListFromMap(left);
            rms.setListFromMap(right);
            lsel.addChild(lms);
            rsel.addChild(rms);
            this.processCollection(lms, rms, left, right, cold);
        }
    }

    private Map createMap(Map otherMap, ClassDescription cd) {
        Map<String, String> map = null;
        String className = null;
        if (otherMap != null) {
            try {
                Class<?> obj = Class.forName(otherMap.getClass().getName());
                if (obj instanceof Map) {
                    map = (Map)((Object)obj);
                }
                className = (String)map.get("class");
            }
            catch (ClassNotFoundException e) {
                map = new TreeMap();
            }
        } else {
            map = new TreeMap<String, String>();
        }
        if (className != null) {
            map.put("class", className);
        } else if (cd != null) {
            map.put("class", cd.getClassName());
        }
        return map;
    }

    private void processComplexPeoperties(MetaMapSelection lsel, MetaMapSelection rsel, ClassDescription cd, Map lmap, Map rmap) {
        if (cd != null) {
            Object obj;
            ArrayList<ClassDescription.PropertyDescription> list = new ArrayList<ClassDescription.PropertyDescription>();
            for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                if (pd.isReferred() && !pd.isPropertyMap && !pd.isMap || pd.isSimpleClass() || pd.isStringClass() || pd.isRectangle) continue;
                obj = lmap.get(pd.xmlName);
                if (obj == null) {
                    obj = rmap.get(pd.xmlName);
                }
                if (obj == null) continue;
                list.add(pd);
            }
            boolean hasPropertyMap = false;
            if (cd.isPropertyMap) {
                obj = lmap.get("propertyMap");
                if (obj == null) {
                    obj = rmap.get("propertyMap");
                }
                if (obj != null) {
                    hasPropertyMap = true;
                }
            }
            if (list.size() > 0 || hasPropertyMap) {
                MetaMapSelection lcs = new MetaMapSelection(COMPLEX_PRPERTIES);
                MetaMapSelection rcs = new MetaMapSelection(COMPLEX_PRPERTIES);
                lcs.setComplexPropertiesList(true);
                rcs.setComplexPropertiesList(true);
                lcs.setMap(lmap);
                rcs.setMap(rmap);
                lcs.setCorrespondentNode(rcs);
                rcs.setCorrespondentNode(lcs);
                lcs.setEmptyComparator();
                rcs.setEmptyComparator();
                lsel.addChild(lcs);
                rsel.addChild(rcs);
                for (ClassDescription.PropertyDescription pd : list) {
                    this.processComplexProp(lcs, rcs, lmap, rmap, pd.xmlName);
                }
                if (hasPropertyMap) {
                    this.processComplexProp(lcs, rcs, lmap, rmap, "propertyMap");
                }
            }
        }
    }

    private void processComplexProp(MetaMapSelection lsel, MetaMapSelection rsel, Map leftmap, Map rightmap, String propName) {
        MetaMapSelection rms;
        Map lmap = (Map)leftmap.get(propName);
        Map rmap = (Map)rightmap.get(propName);
        MetaMapSelection lms = null;
        MetaPropertiesComparator cp = null;
        ClassDescription cd = null;
        if (lmap == null) {
            lms = new MetaMapSelection(TO_DELETE);
            lms.setStatus(3);
        } else {
            cd = this.getClassDecription(lmap);
            lms = new MetaMapSelection(lmap);
            if ("NONAME".equals(lms.getName())) {
                String name = this.getObjectName(lmap);
                if (name != null) {
                    lms.setName(name);
                } else {
                    lms.setName(propName);
                }
            }
        }
        if (rmap != null) {
            if (cd == null) {
                cd = this.getClassDecription(lmap);
            }
            if ("NONAME".equals((rms = new MetaMapSelection(rmap)).getName())) {
                String name = this.getObjectName(rmap);
                if (name != null) {
                    rms.setName(name);
                } else {
                    rms.setName(propName);
                }
            }
        } else {
            rms = new MetaMapSelection(NEW);
            lms.setStatus(2);
            rms.setStatus(2);
        }
        cp = cd == null ? new MetaPropertiesComparator(lmap, rmap, true, this.design, this.storageDesign) : new MetaPropertiesComparator(lmap, rmap, cd, this.design, this.storageDesign);
        Class oclass = lms.getObjectClass();
        if (oclass == null) {
            oclass = this.getClassByObject(lmap);
            if (oclass == null) {
                oclass = this.getClassByObject(rmap);
            }
            if (oclass != null) {
                lms.setChildClass(oclass);
                rms.setChildClass(oclass);
            }
        }
        if (oclass != null && TopView.class.isAssignableFrom(oclass)) {
            lms.setObjectClass(oclass);
            rms.setObjectClass(oclass);
        }
        if (lms.getStatus() == 3) {
            rms.setStatus(3);
        }
        lms.setCorrespondentNode(rms);
        rms.setCorrespondentNode(lms);
        lms.setPropertiesComparator(cp);
        rms.setPropertiesComparator(cp);
        lms.setComplexPropertyXMLName(propName);
        rms.setComplexPropertyXMLName(propName);
        lsel.addChild(lms);
        rsel.addChild(rms);
        if (cd != null) {
            this.addStructure(lms, rms, cd, lmap, rmap);
        }
    }

    private void processCollection(MetaMapSelection lsel, MetaMapSelection rsel, List left, List right, ClassDescription.CollectionDescription cold) {
        boolean hasID = this.hasID(left, cold) || this.hasID(right, cold);
        ArrayList temp = new ArrayList();
        if (left != null) {
            if (cold.itemIsRef) {
                this.addExistingRefsToLeft(lsel, rsel, left, right, cold, hasID, temp);
                this.addDeletedRefsToRight(lsel, rsel, left, right, cold, hasID, temp);
            } else {
                this.addExistingToLeft(lsel, rsel, left, right, cold, hasID, temp);
                this.addDeletedToRight(lsel, rsel, left, right, cold, hasID, temp);
            }
        }
    }

    private void addExistingToLeft(MetaMapSelection lsel, MetaMapSelection rsel, List left, List right, ClassDescription.CollectionDescription cold, boolean hasID, List temp) {
        for (int i = 0; i < left.size(); ++i) {
            String name;
            MetaMapSelection rms;
            Class roclass;
            Class oclass;
            int rpos = -1;
            int lpos = -1;
            Map map = (Map)left.get(i);
            String id = MapCompareBuilder.getID(map);
            Map rmap = null;
            if (hasID) {
                lpos = i;
                rmap = this.getByID(right, id);
                if (rmap != null) {
                    rpos = right.indexOf(rmap);
                }
            } else {
                rmap = this.getByPosition(right, i);
            }
            if (rmap != null) {
                temp.add(rmap);
            }
            ClassDescription cd = this.getClassDecription(map);
            MetaPropertiesComparator cp = null;
            cp = cold.isMapItem ? new MetaPropertiesComparator(map, rmap, true, this.design, this.storageDesign) : new MetaPropertiesComparator(map, rmap, cd, this.design, this.storageDesign);
            MetaMapSelection lms = new MetaMapSelection(map);
            lms.setItemPosition(lpos);
            lms.setItemPositionImportant(this.isItemPositionImportant(cold));
            if ("NONAME".equals(lms.getName())) {
                String name2 = this.getObjectName(map);
                if (name2 != null) {
                    lms.setName(name2);
                } else {
                    name2 = this.getChangedObjectName(MapCompareBuilder.getID(map));
                    if (name2 != null) {
                        lms.setName(name2);
                    } else {
                        lms.setName(cold.itemXmlName);
                    }
                }
            }
            if ((oclass = lms.getObjectClass()) == null || RelationalObjectProxy.class.isAssignableFrom(oclass)) {
                roclass = this.getClassByObject(map);
                if (roclass != null) {
                    oclass = roclass;
                    lms.setObjectClass(roclass);
                } else if (lsel.getObjectClass() != null) {
                    oclass = lsel.getObjectClass();
                    lms.setObjectClass(oclass);
                }
            }
            if (oclass != null) {
                lms.setChildClass(oclass);
                if (TopView.class.isAssignableFrom(oclass)) {
                    roclass = this.getClassByObject(map);
                    if (roclass != null) {
                        oclass = roclass;
                        lms.setObjectClass(roclass);
                    } else if (lsel.getObjectClass() != null) {
                        oclass = lsel.getObjectClass();
                        lms.setObjectClass(oclass);
                    }
                    lms.setObjectClass(oclass);
                }
            }
            if (rmap != null) {
                rms = new MetaMapSelection(rmap);
                rms.setItemPosition(rpos);
                rms.setItemPositionImportant(this.isItemPositionImportant(cold));
                if ("NONAME".equals(rms.getName())) {
                    name = this.getObjectName(rmap);
                    if (name != null) {
                        rms.setName(name);
                    } else {
                        rms.setName(cold.itemXmlName);
                    }
                }
            } else {
                name = null;
                if (map != null) {
                    name = (String)map.get("name");
                }
                if (name == null) {
                    name = NEW;
                }
                rms = new MetaMapSelection(name);
                lms.setStatus(2);
                rms.setStatus(2);
                if (lpos > -1) {
                    rms.setItemPosition(lpos);
                    rms.setItemPositionImportant(this.isItemPositionImportant(cold));
                }
            }
            if (oclass == null) {
                oclass = this.getClassByObject(rmap);
            }
            if (oclass != null) {
                rms.setObjectClass(oclass);
                rms.setChildClass(oclass);
                lms.setChildClass(oclass);
                if (TopView.class.isAssignableFrom(oclass)) {
                    rms.setObjectClass(oclass);
                    lms.setObjectClass(oclass);
                }
            }
            lms.setCorrespondentNode(rms);
            rms.setCorrespondentNode(lms);
            lms.setPropertiesComparator(cp);
            rms.setPropertiesComparator(cp);
            lsel.addChild(lms);
            rsel.addChild(rms);
            if (lsel.getObjectClass() == null) {
                lsel.setChildClass(lms.getObjectClass());
                rsel.setChildClass(rms.getObjectClass());
            }
            if (cd == null || rmap == null) continue;
            this.addStructure(lms, rms, cd, map, rmap);
        }
    }

    private void addDeletedToRight(MetaMapSelection lsel, MetaMapSelection rsel, List left, List right, ClassDescription.CollectionDescription cold, boolean hasID, List temp) {
        for (int i = 0; i < right.size(); ++i) {
            Map rmap = (Map)right.get(i);
            if (temp.contains(rmap)) continue;
            Map map = Collections.EMPTY_MAP;
            ClassDescription cd = this.getClassDecription(rmap);
            MetaPropertiesComparator cp = null;
            cp = cold.isMapItem ? new MetaPropertiesComparator(map, rmap, true, this.design, this.storageDesign) : new MetaPropertiesComparator(map, rmap, cd, this.design, this.storageDesign);
            MetaMapSelection lms = new MetaMapSelection(TO_DELETE);
            MetaMapSelection rms = null;
            if (rmap != null && "NONAME".equals((rms = new MetaMapSelection(rmap)).getName())) {
                String name = this.getObjectName(rmap);
                if (name != null) {
                    rms.setName(name);
                } else {
                    rms.setName(cold.itemXmlName);
                }
            }
            lms.setStatus(3);
            lms.setCorrespondentNode(rms);
            lms.setPropertiesComparator(cp);
            lms.setSelected(false);
            lsel.addChild(lms);
            rsel.addChild(rms);
            if (rms == null) continue;
            rms.setStatus(3);
            lms.setChildClass(rms.getObjectClass());
            rms.setCorrespondentNode(lms);
            rms.setPropertiesComparator(cp);
            if (rms.getObjectClass() != null) continue;
            rms.setChildClass(lsel.getObjectClass());
            lms.setChildClass(lsel.getObjectClass());
        }
    }

    private void addExistingRefsToLeft(MetaMapSelection lsel, MetaMapSelection rsel, List left, List right, ClassDescription.CollectionDescription cold, boolean hasID, List temp) {
        for (int i = 0; i < left.size(); ++i) {
            MetaMapSelection rms;
            String lid = (String)left.get(i);
            temp.add(lid);
            String lname = this.getObjectName(lid);
            if (lname == null) {
                lname = cold.itemXmlName;
            }
            int rpos = this.getRefPosByID(right, lid);
            Class oclass = this.getClassByObject(lid);
            MetaMapSelection lms = new MetaMapSelection(lname);
            lms.setChildClass(oclass);
            lms.setReferenceID(lid);
            if (rpos > -1) {
                rms = new MetaMapSelection(lname);
            } else {
                rms = new MetaMapSelection(NEW);
                lms.setStatus(2);
                rms.setStatus(2);
            }
            rms.setChildClass(oclass);
            lms.setCorrespondentNode(rms);
            rms.setCorrespondentNode(lms);
            lms.setPropertiesComparator(EMPTY_COMPARATOR);
            rms.setPropertiesComparator(EMPTY_COMPARATOR);
            lsel.addChild(lms);
            rsel.addChild(rms);
            if (lsel.getObjectClass() != null) continue;
            lsel.setChildClass(lms.getObjectClass());
            rsel.setChildClass(rms.getObjectClass());
        }
    }

    private void addDeletedRefsToRight(MetaMapSelection lsel, MetaMapSelection rsel, List left, List right, ClassDescription.CollectionDescription cold, boolean hasID, List temp) {
        for (int i = 0; i < right.size(); ++i) {
            String rid = (String)right.get(i);
            if (temp.contains(rid)) continue;
            String lname = this.getObjectName(rid);
            if (lname == null) {
                lname = cold.itemXmlName;
            }
            MetaPropertiesComparator cp = EMPTY_COMPARATOR;
            Class oclass = this.getClassByObject(rid);
            MetaMapSelection lms = new MetaMapSelection(TO_DELETE);
            MetaMapSelection rms = new MetaMapSelection(lname);
            lms.setStatus(3);
            rms.setStatus(3);
            rms.setChildClass(oclass);
            lms.setChildClass(oclass);
            lms.setCorrespondentNode(rms);
            rms.setCorrespondentNode(lms);
            lms.setPropertiesComparator(cp);
            rms.setPropertiesComparator(cp);
            lms.setReferenceID(rid);
            rms.setReferenceID(rid);
            lsel.addChild(lms);
            rsel.addChild(rms);
            if (rms.getObjectClass() != null) continue;
            rms.setChildClass(lsel.getObjectClass());
            lms.setChildClass(lsel.getObjectClass());
        }
    }

    private boolean hasID(List list, ClassDescription.CollectionDescription cold) {
        if (list != null && list.size() > 0) {
            Map map;
            String id;
            if (cold.itemIsRef) {
                return true;
            }
            Object obj = list.get(0);
            if (obj instanceof Map && (id = MapCompareBuilder.getID(map = (Map)obj)) != null && !"NO_ID".equals(id)) {
                return true;
            }
        }
        return false;
    }

    private Map getByID(List list, String id) {
        for (Map map : list) {
            String mid = MapCompareBuilder.getID(map);
            if (mid == null || !mid.equals(id)) continue;
            return map;
        }
        return null;
    }

    private int getRefPosByID(List list, String id) {
        for (int i = 0; i < list.size(); ++i) {
            String lid = (String)list.get(i);
            if (lid == null || !lid.equals(id)) continue;
            return i;
        }
        return -1;
    }

    private Map getByPosition(List list, int pos) {
        if (pos < list.size()) {
            return (Map)list.get(pos);
        }
        return null;
    }

    private String getObjectName(Map metaMap) {
        DesignObject obj;
        if (metaMap == null) {
            return null;
        }
        String id = MetaMapSelection.getID(metaMap);
        if (this.design != null && (obj = this.design.getDesignObject(id)) != null) {
            return ((ModelObject)obj).getName();
        }
        return (String)metaMap.get("foType");
    }

    private Class getClassByObject(Map metaMap) {
        ModelIDObject obj;
        String id = MetaMapSelection.getID(metaMap);
        if (this.design != null && (obj = this.design.getDesignObject(id)) != null) {
            Index ind;
            if (obj instanceof Index && (ind = (Index)obj).isFK()) {
                return FKIndexAssociation.class;
            }
            return obj.getClass();
        }
        if (this.storageDesign != null && (obj = this.storageDesign.getStorageObject(id)) != null) {
            return obj.getClass();
        }
        return null;
    }

    private String getObjectName(String id) {
        ModelIDObject obj;
        if (this.design != null && (obj = this.design.getDesignObject(id)) != null) {
            return obj.getName();
        }
        if (this.storageDesign != null && (obj = this.storageDesign.getStorageObject(id)) != null) {
            return obj.getName();
        }
        return null;
    }

    private Class getClassByObject(String id) {
        DesignObject obj;
        if (this.design != null && (obj = this.design.getDesignObject(id)) != null) {
            return obj.getClass();
        }
        return null;
    }

    public void mergeToRightMap() {
        this.copyProperties(this.leftRoot);
        this.mergeStructure(this.leftRoot);
    }

    public Map getRightMap() {
        return this.rightMap;
    }

    public Map getLefttMap() {
        return this.leftMap;
    }

    private void copyProperties(MetaMapSelection node) {
        if (node.getStatus() != 3 && node.getStatus() != 2) {
            MetaPropertiesComparator cp;
            if (node.isSelected() && node.isModified() && (cp = node.getPropertiesComparator()) != null) {
                cp.copySelectedProperties();
            }
            for (MetaMapSelection child : node.getChilds()) {
                this.copyProperties(child);
            }
        }
    }

    private void mergeStructure(MetaMapSelection node) {
        if (node.getStatus() != 3 && node.getStatus() != 2) {
            if (node.isMetaCollection()) {
                this.mergeCollections(node, node.getCorrespondentNode());
            }
            if (node.isComplexPropertiesList()) {
                this.mergeComplexProperties(node);
            } else {
                for (MetaMapSelection child : node.getChilds()) {
                    this.mergeStructure(child);
                }
            }
        }
    }

    private void mergeComplexProperties(MetaMapSelection node) {
        MetaMapSelection rnode = node.getCorrespondentNode();
        Map rmap = rnode.getMap();
        if (rmap != null) {
            for (MetaMapSelection child : node.getChilds()) {
                if (!child.isSelected()) continue;
                String xmlName = child.getComplexPropertyXMLName();
                if (child.getStatus() == 3) {
                    if (xmlName == null) continue;
                    rmap.remove(xmlName);
                    continue;
                }
                if (child.getStatus() == 2) {
                    Map map;
                    if (xmlName == null || (map = child.getMap()) == null) continue;
                    rmap.put(xmlName, map);
                    continue;
                }
                this.mergeStructure(child);
            }
        }
    }

    private void mergeCollections(MetaMapSelection lsel, MetaMapSelection rsel) {
        ClassDescription.CollectionDescription cold = lsel.getCollectionDescription();
        List right = rsel.getListFromMap();
        if (right != null) {
            for (MetaMapSelection node : lsel.getChilds()) {
                if (node.getStatus() != 3 || !node.isSelected()) continue;
                if (cold.itemIsRef) {
                    String id = node.getCorrespondentNode().getReferenceID();
                    if (id == null) continue;
                    right.remove(id);
                    continue;
                }
                Map map = node.getCorrespondentNode().getMap();
                if (map == null) continue;
                right.remove(map);
            }
            int k = 0;
            for (MetaMapSelection node : lsel.getChilds()) {
                if (node.isSelected()) {
                    int ind;
                    if (cold.itemIsRef) {
                        String id = null;
                        if (node.getStatus() == 2) {
                            id = node.getReferenceID();
                            if (id != null) {
                                if (k > right.size()) {
                                    right.add(id);
                                } else {
                                    right.add(k, id);
                                }
                            }
                        } else if (node.getStatus() != 3 && (id = node.getCorrespondentNode().getReferenceID()) != null && (ind = right.indexOf(id)) != k && right.remove(id)) {
                            if (k > right.size()) {
                                right.add(id);
                            } else {
                                right.add(k, id);
                            }
                        }
                    } else {
                        Map map = null;
                        if (node.getStatus() == 2) {
                            map = node.getMap();
                            if (map != null) {
                                if (k > right.size()) {
                                    right.add(map);
                                } else {
                                    right.add(k, map);
                                }
                            }
                        } else if (node.getStatus() != 3) {
                            map = node.getCorrespondentNode().getMap();
                            this.mergeStructure(node);
                            if (map != null && (ind = right.indexOf(map)) != k && right.remove(map)) {
                                if (k > right.size()) {
                                    right.add(map);
                                } else {
                                    right.add(k, map);
                                }
                            }
                        }
                    }
                }
                ++k;
            }
        }
    }

    public void updateBothModifiedStatus() {
        this.leftRoot.resetModifiedStatus();
        this.rightRoot.resetModifiedStatus();
    }

    private boolean isItemPositionImportant(ClassDescription.CollectionDescription cold) {
        if (cold.isProxyitem || cold.isObjectViewItem || cold.isTVDiagramItem || cold.isTVConnectorItem) {
            return false;
        }
        return cold.isOrderImportant;
    }

    private String getChangedObjectName(String objectID) {
        if (this.design.getAppView().getChangedObjectsList() == null) {
            return null;
        }
        List<StorableObjectStatus> changedObjects = this.design.getAppView().getChangedObjectsList();
        for (int k = 0; k < changedObjects.size(); ++k) {
            StorableObjectStatus sos = changedObjects.get(k);
            if (!sos.getStorableObjectID().equals(objectID)) continue;
            return sos.getStorableObjectName();
        }
        return null;
    }
}

