/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLFKArc
extends AbstractWXMLDesignObject {
    private FKArc arc = null;

    public WXMLFKArc(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof FKArc;
        if (result) {
            this.arc = (FKArc)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.arc != null) {
            String designName = this.arc.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("rel").append('/').append(this.arc.getDesignPart().getPathIDString()).append('/');
        }
        buffer.append(this.getConfiguration().get("arcPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof FKArc) {
            FKArc arc = (FKArc)object;
            objectInfoNode.setAttribute("table", StringUtilities.encodeAttributeValue(arc.getTable().getObjectID()));
            objectInfoNode.setAttribute("mandatory", String.valueOf(arc.isMandatory()));
            TreeMap<String, String> map = new TreeMap<String, String>();
            int j = 0;
            for (FKIndexAssociation fkey : arc.getFkeys()) {
                map.put("fkey_" + ++j, StringUtilities.encodeAttributeValue(fkey.getObjectID()));
            }
            this.appendProperties(objectInfoNode, "fkeys", map);
        }
    }
}

