/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLTable
extends AbstractWXMLDesignObject {
    Table table = null;

    public WXMLTable(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Table;
        if (result) {
            this.table = (Table)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.table != null) {
            String designName = this.table.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("rel").append('/').append(this.table.getDesignPart().getPathIDString()).append('/');
        }
        buffer.append(this.getConfiguration().get("tablePath"));
        return buffer.toString();
    }

    @Override
    protected void appendContainedObjectInfo(Element parentNode, ContainedObject object) {
        Column column = (Column)object;
        this.appendDataTypeInfo(parentNode, column);
        String abbreviation = column.getAbbreviation();
        if (abbreviation != null) {
            this.appendAbbreviation(parentNode, abbreviation);
        }
        this.appendReferenceInfo(parentNode, column.isReference());
        this.appendLogicalTypeInfo(parentNode, column.getLogicalDatatype());
        this.appendUseDomainInfo(parentNode, column.getUse());
        this.appendSourceTypeInfo(parentNode, column.getSourceType());
        this.appendComputedInfo(parentNode, column.isComputed());
        this.appendFormulaDescInfo(parentNode, column.getFormulaDesc());
        this.appendSubtypeSubstitutionInfo(parentNode, column.isAllowSubtypeSubstitution());
        this.appendRestrictedSubstitutionInfo(parentNode, column);
        this.appendScopeInfo(parentNode, column);
        this.appendSecurityInfo(parentNode, column);
        this.appendUIDefaultsInfo(parentNode, column);
        this.appendAutoIncrementInfo(parentNode, column);
        if (column.isFKColumn()) {
            this.appendIsPreviousColumnInfo(parentNode, column);
            Collection col = column.getRefColAndAssocIDs();
            Iterator it = col.iterator();
            Element associations = parentNode.getOwnerDocument().createElement("associations");
            while (it.hasNext()) {
                Element associated = parentNode.getOwnerDocument().createElement("associated");
                FKElement.FKColRefNode refNode = (FKElement.FKColRefNode)it.next();
                associated.setAttribute("tableid", refNode.remoteTableId);
                associated.setAttribute("indexid", refNode.remoteKeyId);
                associated.setAttribute("references", refNode.refColumnId);
                associated.setAttribute("fkassid", refNode.fkAssocId);
                associations.appendChild(associated);
            }
            parentNode.appendChild(associations);
            parentNode.setAttribute("beforeDrop", StringUtilities.encodeAttributeValue(this.table.getBeforeDrop()));
        }
    }

    @Override
    protected void appendReferenceInfo(Element parentNode, boolean use) {
        Element elm = parentNode.getOwnerDocument().createElement("reference");
        elm.setAttribute("value", String.valueOf(use));
        parentNode.appendChild(elm);
    }

    protected void appendLogicalTypeInfo(Element parentNode, LogicalDatatype type) {
        if (type != null) {
            Element elm = parentNode.getOwnerDocument().createElement("logicaltype");
            elm.setAttribute("dttype", StringUtilities.encodeAttributeValue(type.getName()));
            elm.setAttribute("oid", StringUtilities.encodeAttributeValue(type.getObjectID()));
            parentNode.appendChild(elm);
        }
    }

    protected void appendUseDomainInfo(Element parentNode, short use) {
        Element elm = parentNode.getOwnerDocument().createElement("use");
        if (use == 0) {
            elm.setAttribute("value", "domain");
        } else if (use == 1) {
            elm.setAttribute("value", "logical type");
        } else if (use == 2) {
            elm.setAttribute("value", "distinct type");
        } else if (use == 3) {
            elm.setAttribute("value", "structured type");
        } else if (use == 4) {
            elm.setAttribute("value", "collection type");
        }
        parentNode.appendChild(elm);
    }

    private void appendSourceTypeInfo(Element parentNode, String sourceType) {
        Element elm = parentNode.getOwnerDocument().createElement("sourcetype");
        elm.setAttribute("sort", sourceType);
        parentNode.appendChild(elm);
    }

    protected void appendComputedInfo(Element parentNode, boolean computed) {
        Element elm = parentNode.getOwnerDocument().createElement("computed");
        elm.setAttribute("value", String.valueOf(computed));
        parentNode.appendChild(elm);
    }

    private void appendFormulaDescInfo(Element parentNode, String formulaDesc) {
        Element elm = parentNode.getOwnerDocument().createElement("formula");
        elm.setAttribute("desc", StringUtilities.encodeAttributeValue(formulaDesc));
        parentNode.appendChild(elm);
    }

    private void appendAbbreviation(Element parentNode, String abbreviation) {
        Element elm = parentNode.getOwnerDocument().createElement("abbreviation");
        elm.setTextContent(StringUtilities.encodeAttributeValue(abbreviation));
        parentNode.appendChild(elm);
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Table) {
            Table table = (Table)object;
            objectInfoNode.setAttribute("entitytype", table.getTypeID());
            String scope = table.getScope();
            if (scope != null && !"".equalsIgnoreCase(scope)) {
                objectInfoNode.setAttribute("scope", StringUtilities.encodeAttributeValue(scope));
            }
            objectInfoNode.setAttribute("splittedTableID", table.getSplittedTableID());
            if (table.getBasedOnStructuredType() != null) {
                objectInfoNode.setAttribute("structuredType", StringUtilities.encodeAttributeValue(table.getBasedOnStructuredType().getObjectID()));
            }
            objectInfoNode.setAttribute("allow_type_substitution", String.valueOf(table.isAllowTypeSubstitution()));
            this.appendTableLevelConstraints(objectInfoNode, table);
            objectInfoNode.setAttribute("minVolumes", new Integer(table.getMinVolumes()).toString());
            objectInfoNode.setAttribute("expectedVolumes", new Integer(table.getExpectedVolumes()).toString());
            objectInfoNode.setAttribute("maxVolumes", new Integer(table.getMaxVolumes()).toString());
            objectInfoNode.setAttribute("growthPercent", new Integer(table.getGrowthPercent()).toString());
            objectInfoNode.setAttribute("growthType", table.getGrowthType());
            objectInfoNode.setAttribute("normalForm", table.getNormalForm());
            objectInfoNode.setAttribute("adequatelyNormalized", table.getAdequatelyNormalized());
            String abbreviation = table.getAbbreviation();
            if (abbreviation != null) {
                objectInfoNode.setAttribute("abbreviation", StringUtilities.encodeAttributeValue(abbreviation));
            }
            this.appendScriptInfo(objectInfoNode, "include_in_ddl", table.getShouldGenerateScript() ? VALUE_TRUE : VALUE_FALSE);
            this.appendScriptInfo(objectInfoNode, "beforeDrop", table.getBeforeDrop());
            this.appendScriptInfo(objectInfoNode, "beforeCreate", table.getBeforeCreate());
            this.appendScriptInfo(objectInfoNode, "beforeAlter", table.getBeforeAlter());
            this.appendScriptInfo(objectInfoNode, "afterCreate", table.getAfterCreate());
            this.appendScriptInfo(objectInfoNode, "afterAlter", table.getAfterAlter());
            this.appendScriptInfo(objectInfoNode, "endOfScript", table.getEndOfScript());
            this.appendSpatialTableInfo(objectInfoNode, table);
            objectInfoNode.setAttribute("oid_is_pk", String.valueOf(table.isOidIsPK()));
            this.appendObjects(objectInfoNode, table.getOidPKColumns().toArray(), "oid_pk_columns");
            this.appendColumnGroups(objectInfoNode, table);
        }
    }

    private void appendSpatialTableInfo(Element tableElm, Table table) {
        Element stElm = tableElm.getOwnerDocument().createElement("spatial_table");
        Element param = null;
        stElm.setAttribute("value", String.valueOf(table.isSpatialTable()));
        Iterator spIt = table.getSpatialDefinitions().iterator();
        while (spIt.hasNext()) {
            Element definitionParam = stElm.getOwnerDocument().createElement("spatial_definition");
            SpatialColumnDefObject spObject = (SpatialColumnDefObject)spIt.next();
            String name = spObject.getName();
            if (name != null && !"".equalsIgnoreCase(name)) {
                definitionParam.setAttribute("name", StringUtilities.encodeAttributeValue(name));
            }
            if (spObject.getSpatialColumn() != null) {
                param = definitionParam.getOwnerDocument().createElement("spatial_column");
                param.setAttribute("id", StringUtilities.encodeAttributeValue(spObject.getSpatialColumn().getObjectID()));
                definitionParam.appendChild(param);
            }
            if (spObject.isFunction()) {
                param = definitionParam.getOwnerDocument().createElement("spatial_function");
                param.setAttribute("value", String.valueOf(spObject.isFunction()));
                definitionParam.appendChild(param);
                param = definitionParam.getOwnerDocument().createElement("spatial_func_expression");
                param.setAttribute("value", spObject.getFuncExpression());
                definitionParam.appendChild(param);
            }
            param = definitionParam.getOwnerDocument().createElement("spatial_srid");
            String systemID = spObject.getSystemID();
            if (systemID != null && !"".equalsIgnoreCase(systemID)) {
                param.setAttribute("value", StringUtilities.encodeAttributeValue(systemID));
            }
            definitionParam.appendChild(param);
            if (spObject.getSpatialIndex() != null) {
                Index spatialIndex = spObject.getSpatialIndex();
                param = definitionParam.getOwnerDocument().createElement("spatial_index");
                param.setAttribute("id", StringUtilities.encodeAttributeValue(spatialIndex.getObjectID()));
                param.setAttribute("layer_gtype", spatialIndex.getLayerType());
                param.setAttribute("geodetic", spatialIndex.getGeodetic());
                param.setAttribute("sdo_indx_dims", String.valueOf(spatialIndex.getDimensionsNumber()));
                definitionParam.appendChild(param);
            }
            param = definitionParam.getOwnerDocument().createElement("spatial_table_dimensions");
            for (SpatialColumnDefObject.TableDimension td : spObject.getTableDimensions()) {
                String tolerance;
                String upperBoundary;
                String lowBoundary;
                Element childParam = param.getOwnerDocument().createElement("spatial_table_dimension");
                String dimName = td.getName();
                if (name != null && !"".equalsIgnoreCase(dimName)) {
                    childParam.setAttribute("name", StringUtilities.encodeAttributeValue(dimName));
                }
                if ((lowBoundary = td.getLowBoundary()) != null && !"".equalsIgnoreCase(lowBoundary)) {
                    childParam.setAttribute("low_boundary", StringUtilities.encodeAttributeValue(lowBoundary));
                }
                if ((upperBoundary = td.getUpperBoundary()) != null && !"".equalsIgnoreCase(upperBoundary)) {
                    childParam.setAttribute("upper_boundary", StringUtilities.encodeAttributeValue(upperBoundary));
                }
                if ((tolerance = td.getTolerance()) != null && !"".equalsIgnoreCase(tolerance)) {
                    childParam.setAttribute("tolerance", StringUtilities.encodeAttributeValue(tolerance));
                }
                param.appendChild(childParam);
            }
            definitionParam.appendChild(param);
            stElm.appendChild(definitionParam);
        }
        tableElm.appendChild(stElm);
    }

    public void appendIsPreviousColumnInfo(Element parentNode, Column object) {
        Element elm = parentNode.getOwnerDocument().createElement("is_previous_column");
        elm.setAttribute("value", object.isPreviousColumn() ? VALUE_TRUE : VALUE_FALSE);
        parentNode.appendChild(elm);
    }

    private void appendTableLevelConstraints(Element objectInfoNode, Table table) {
        for (TableLevelConstraint constraint : table.getCheckConstraints()) {
            String rule;
            Element tlcElm = objectInfoNode.getOwnerDocument().createElement("tableconstraint");
            tlcElm.setAttribute("oid", String.valueOf(constraint.getID()));
            String constraintName = constraint.getName();
            if (constraintName != null && !"".equalsIgnoreCase(constraintName)) {
                tlcElm.setAttribute("name", StringUtilities.encodeAttributeValue(constraint.getName()));
            }
            if ((rule = constraint.getRule()) != null && !"".equalsIgnoreCase(rule)) {
                tlcElm.setAttribute("rule", StringUtilities.encodeAttributeValue(rule));
            }
            objectInfoNode.appendChild(tlcElm);
        }
    }

    @Override
    protected void appendKeyObjectInfo(Element keyObjectNode, KeyObject keyObject) {
        Index index;
        String integrityIndId;
        if (keyObject instanceof Index && !keyObject.isFK() && (integrityIndId = (index = (Index)keyObject).getIdOfRecoveredIntegrityIndex()) != null) {
            keyObjectNode.setAttribute("id_of_recovered_integrity_index", integrityIndId);
        }
    }

    protected void appendSecurityInfo(Element parentNode, Column column) {
        Element element = parentNode.getOwnerDocument().createElement("security");
        this.setAttributeIfNotEmpty(element, "containsPII", column.isContainsPII());
        this.setAttributeIfNotEmpty(element, "containsSensitiveInformation", column.isContainsSensitiveInformation());
        parentNode.appendChild(element);
    }

    protected void appendAutoIncrementInfo(Element parentNode, Column column) {
        Element element = parentNode.getOwnerDocument().createElement("auto_increment");
        this.setAttributeIfNotEmpty(element, "auto_increment_column", column.isAutoIncrementColumn());
        this.setAttributeIfNotEmpty(element, "identity_column", column.isIdentityColumn());
        this.setAttributeIfNotEmpty(element, "generate_always", column.isAutoIncrementGenerateAlways());
        this.setAttributeIfNotEmpty(element, "start_with", column.getAutoIncrementStartWith());
        this.setAttributeIfNotEmpty(element, "increment_by", column.getAutoIncrementIncrementBy());
        this.setAttributeIfNotEmpty(element, "min_value", column.getAutoIncrementMinValue());
        this.setAttributeIfNotEmpty(element, "max_value", column.getAutoIncrementMaxValue());
        this.setAttributeIfNotEmpty(element, "cycle", column.isAutoIncrementCycle());
        this.setAttributeIfNotEmpty(element, "disable_cache", column.isAutoIncrementDisableCache());
        this.setAttributeIfNotEmpty(element, "cache", column.getAutoIncrementCache());
        this.setAttributeIfNotEmpty(element, "order", column.isAutoIncrementOrder());
        this.setAttributeIfNotEmpty(element, "sequence_name", column.getAutoIncrementSequenceName());
        this.setAttributeIfNotEmpty(element, "trigger_name", column.getAutoIncrementTriggerName());
        this.setAttributeIfNotEmpty(element, "generate_trigger", column.isAutoIncrementGenerateTrigger());
        parentNode.appendChild(element);
    }

    protected void setAttributeIfNotEmpty(Element element, String attributeName, Object attributeValue) {
        if (attributeValue != null) {
            element.setAttribute(attributeName, String.valueOf(attributeValue));
        }
    }

    protected void setAttributeIfNotEmpty(Element element, String attributeName, String attributeValue) {
        if (StringUtilities.isNotEmpty(attributeValue)) {
            element.setAttribute(attributeName, attributeValue);
        }
    }

    private void appendColumnGroups(Element objectInfoNode, Table table) {
        Element elColumnGroup = null;
        Iterator it = table.getColumnGroupsSet().iterator();
        while (it.hasNext()) {
            elColumnGroup = objectInfoNode.getOwnerDocument().createElement("column_group");
            Table.ColumnGroup cg = (Table.ColumnGroup)it.next();
            elColumnGroup.setAttribute("name", StringUtilities.encodeAttributeValue(cg.getName()));
            elColumnGroup.setAttribute("objectid", cg.getObjectID());
            elColumnGroup.setAttribute("note", cg.getNote());
            for (String col : cg.getColumns()) {
                Element elColumn = objectInfoNode.getOwnerDocument().createElement("cg_column");
                elColumn.setAttribute("objectid", col);
                elColumnGroup.appendChild(elColumn);
            }
            objectInfoNode.appendChild(elColumnGroup);
        }
    }

    protected void appendUIDefaultsInfo(Element parentNode, Column column) {
        Element element = parentNode.getOwnerDocument().createElement("ui_defaults");
        this.setAttributeIfNotEmpty(element, "label", StringUtilities.encodeAttributeValue(column.getDefaultLabel()));
        this.setAttributeIfNotEmpty(element, "formatMask", StringUtilities.encodeAttributeValue(column.getDefaultFormatMask()));
        this.setAttributeIfNotEmpty(element, "formDisplayWidth", column.getDefaultFormDisplayWidth());
        this.setAttributeIfNotEmpty(element, "formMaximumWidth", column.getDefaultFormMaximumWidth());
        this.setAttributeIfNotEmpty(element, "formHeight", column.getDefaultFormHeight());
        this.setAttributeIfNotEmpty(element, "helpText", StringUtilities.encodeAttributeValue(column.getDefaultHelpText()));
        this.setAttributeIfNotEmpty(element, "readOnly", String.valueOf(column.isDefaultReadOnly()));
        this.setAttributeIfNotEmpty(element, "displayedOnReports", String.valueOf(column.isDefaultDisplayedOnReports()));
        this.setAttributeIfNotEmpty(element, "displayedOnForms", String.valueOf(column.isDefaultDisplayedOnForms()));
        this.setAttributeIfNotEmpty(element, "displayAs", column.getDefaultDisplayAs());
        parentNode.appendChild(element);
    }
}

