/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLLocation
extends AbstractWXMLDesignObject
implements BIConstants {
    private BILocation location = null;

    public WXMLLocation(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof BILocation;
        if (result) {
            this.location = (BILocation)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.location != null) {
            String designName = this.location.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("businessinfo").append('/');
        }
        buffer.append(this.getConfiguration().get("locationPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof BILocation) {
            BILocation location = (BILocation)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("type", StringUtilities.encodeAttributeValue(String.valueOf(location.getLocationType())));
            map.put("address", StringUtilities.encodeAttributeValue(String.valueOf(location.getAddress())));
            map.put("city", StringUtilities.encodeAttributeValue(String.valueOf(location.getCity())));
            map.put("postcode", StringUtilities.encodeAttributeValue(String.valueOf(location.getPostCode())));
            map.put("area", StringUtilities.encodeAttributeValue(String.valueOf(location.getArea())));
            map.put("country", StringUtilities.encodeAttributeValue(String.valueOf(location.getCountry())));
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }
}

