/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLStructuredType
extends AbstractWXMLDesignObject
implements DTConstants {
    private StructuredType structuredType = null;

    public WXMLStructuredType(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof StructuredType;
        if (result) {
            this.structuredType = (StructuredType)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.structuredType != null) {
            String designName = this.structuredType.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("datatypes").append('/');
        }
        buffer.append(this.getConfiguration().get("structuredtypePath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)object;
            DesignPart designPart = object.getDesignPart();
            boolean isVisible = object.getFirstViewForDPV(designPart.getMainView()) != null && object.isVisible();
            objectInfoNode.setAttribute("visible", String.valueOf(isVisible));
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("parent_type", String.valueOf(structuredType.getParentType() != null ? StringUtilities.encodeAttributeValue(structuredType.getParentType().getObjectID()) : NULL_STR));
            map.put("final", String.valueOf(structuredType.isFinal()));
            map.put("instantiable", String.valueOf(structuredType.isInstantiable()));
            map.put("predefined", String.valueOf(structuredType.isPredefined()));
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }

    @Override
    protected void appendContainedElements(Document doc, Element parentNode, DesignObject object) {
        Element mElm = doc.createElement("contained");
        parentNode.appendChild(mElm);
        TypeElement[] elements = ((StructuredType)object).getElements();
        for (int i = 0; i < elements.length; ++i) {
            this.appendElementInfo(doc, mElm, elements[i]);
        }
        mElm = doc.createElement("methods");
        parentNode.appendChild(mElm);
        Method[] methods = ((StructuredType)object).getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.appendMethodInfo(doc, mElm, methods[i]);
        }
    }

    private Element appendElementInfo(Document doc, Element objectNode, TypeElement te) {
        Element elementNode = this.appendDesignObjectInfo(doc, objectNode, te);
        objectNode.appendChild(elementNode);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("reference", String.valueOf(te.isReference()));
        map.put("typeid", te.getType() != null ? StringUtilities.encodeAttributeValue(te.getType().getObjectID()) : NULL_STR);
        map.put("size", String.valueOf(te.getSize()));
        map.put("Scale", String.valueOf(te.getScale()));
        map.put("Precision", String.valueOf(te.getPrecision()));
        map.put("mandatory", String.valueOf(te.isMandatory()));
        this.appendProperties(elementNode, "attributes", map);
        return elementNode;
    }

    private Element appendMethodInfo(Document doc, Element objectNode, Method method) {
        Element elementNode = this.appendDesignObjectInfo(doc, objectNode, method);
        objectNode.appendChild(elementNode);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("constructor", String.valueOf(method.isConstructor()));
        map.put("overrided_method", method.getOverridedMethod() != null ? StringUtilities.encodeAttributeValue(method.getOverridedMethod().getObjectID()) : NULL_STR);
        map.put("body", method.getBody());
        this.appendProperties(elementNode, "attributes", map);
        map = new TreeMap();
        for (MethodParam param : method.getParameters()) {
            this.appendParamInfo(doc, elementNode, param, "methodparam");
        }
        if (method.getReturnValue() != null) {
            this.appendParamInfo(doc, elementNode, method.getReturnValue(), "return_value");
        }
        return elementNode;
    }

    private Element appendParamInfo(Document doc, Element objectNode, MethodParam param, String tagName) {
        Element elementNode = doc.createElement(tagName);
        objectNode.appendChild(elementNode);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("id", param.getObjectID());
        map.put("name", param.getName());
        map.put("typeid", param.getType() != null ? StringUtilities.encodeAttributeValue(param.getType().getObjectID()) : NULL_STR);
        map.put("size", String.valueOf(param.getSize()));
        map.put("Scale", String.valueOf(param.getScale()));
        map.put("Precision", String.valueOf(param.getPrecision()));
        map.put("reference", String.valueOf(param.isReference()));
        this.appendProperties(elementNode, "attributes", map);
        return elementNode;
    }
}

