/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLStore
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLStore(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getProcessModel().getInfoStoreSet().createInfoStore(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        int i;
        InfoStore store = (InfoStore)super.recreateObject(objInfo, design, tryReadWriteLocking);
        String synonym = objInfo.getAttribute("synonym");
        if (synonym != null) {
            store.setSynonym(StringUtilities.decodeAttributeValue(synonym));
        }
        Map map = this.getProperties(objInfo, "attributes");
        store.setSystemObjective((String)map.get("systemobjective"));
        store.setType(StringUtilities.decodeAttributeValue((String)map.get("type")));
        store.setRdbmsSite(StringUtilities.decodeAttributeValue((String)map.get("rdbmstype")));
        store.setObjectType(StringUtilities.decodeAttributeValue((String)map.get("objectType")));
        store.setImplementationName(StringUtilities.decodeAttributeValue((String)map.get("implementationName")));
        store.setScope(StringUtilities.decodeAttributeValue((String)map.get("scope")));
        store.setOwner(StringUtilities.decodeAttributeValue((String)map.get("owner")));
        store.setSource(StringUtilities.decodeAttributeValue((String)map.get("source")));
        store.setFileName(StringUtilities.decodeAttributeValue((String)map.get("filename")));
        store.setLocation(StringUtilities.decodeAttributeValue((String)map.get("location")));
        store.setFileType(StringUtilities.decodeAttributeValue((String)map.get("filetype")));
        store.setFieldSeparator((String)map.get("fieldseparator"));
        store.setTransferType(StringUtilities.decodeAttributeValue((String)map.get("transfertype")));
        store.setSelfDescribing(new Boolean((String)map.get("selfDescribing")));
        store.setSkipRecords(new Integer((String)map.get("skipRecords")));
        store.setTextDelimiter(StringUtilities.decodeAttributeValue((String)map.get("textDelimiter")));
        Map objMap = this.getProperties(objInfo, "storedatas");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            String aID = (String)objMap.get(objects[i]);
            ExternalData data = (ExternalData)store.getDesign().getProcessModel().getExternalDataSet().getObjectByID(aID);
            if (data == null) continue;
            store.addData(data);
        }
        objMap = this.getProperties(objInfo, "entityimpl");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            String entityID = (String)objects[i];
            String tableID = (String)objMap.get(objects[i]);
            Entity entity = (Entity)store.getDesign().getDesignObject(entityID);
            Table table = (Table)store.getDesign().getDesignObject(tableID);
            if (entity == null || table == null) continue;
            store.addEntityImpl(entity, table);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(store.getObjectID())).append(".dmd");
        store.setFilePath(buffer.toString());
        return store;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            if (this.isOldDesign()) {
                buffer.append(designName).append('/').append("processmodel").append('/');
            } else {
                buffer.append(designName).append('/').append("pm").append('/');
            }
        }
        buffer.append(this.getConfiguration().get("storePath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == InfoStore.class;
    }
}

