/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.LogSyntaxTextArea;

public class ExternalLogDialog
extends CustomDialog {
    private JDialog dialog;
    private LogSyntaxTextArea editor;
    private JPanel footerPanel;
    private JButton closeButton;

    private ExternalLogDialog(ApplicationView appView) {
        super(appView);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)((Object)this.getEditorPane())), "Center");
        this.add((Component)this.getFooterPanel(), "South");
    }

    protected LogSyntaxTextArea getEditorPane() {
        if (this.editor == null) {
            this.editor = new LogSyntaxTextArea();
        }
        return this.editor;
    }

    @Override
    protected void close() {
        this.dialog.dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ExternalLogDialog.Log"));
            this.dialog.setContentPane(this);
            this.dialog.setSize(860, 640);
            this.setDefaultActions(this.dialog, false);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    public void showDialog() {
        if (this.loadLog()) {
            CommonUtil.centerOnScreen(this.getDialog());
            this.getDialog().setVisible(true);
        }
    }

    public JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            this.footerPanel = new JPanel();
            this.footerPanel.add(this.getCloseButton());
        }
        return this.footerPanel;
    }

    public JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton(Messages.getString("LogReport.Close"));
            this.closeButton.setMnemonic(67);
            this.closeButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ExternalLogDialog.this.close();
                }
            });
            this.closeButton.setToolTipText(Messages.getString("LogReport.Close"));
        }
        return this.closeButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadLog() {
        try {
            try (BufferedReader br = new BufferedReader(new FileReader(new File(System.getProperty("log.file.name"))));){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append('\n');
                    line = br.readLine();
                }
                this.getEditorPane().setText(sb.toString());
                int position = this.getEditorPane().getDocument().getLength() - 1;
                if (position < 0) {
                    position = 0;
                    this.getEditorPane().setText("The current log file is empty.\nPlease check contents of file datamodeler.log.1 in folder datamodeler/log if this file exists.");
                }
                this.getEditorPane().setCaretPosition(position);
            }
            return true;
        }
        catch (Exception e) {
            MessageDialogs.showErrorMessage(Messages.getString("ExternalLogDialog.ErrorReadingFile"));
            return false;
        }
    }

    public static void showExternalLog() {
        ExternalLogDialog dialog = new ExternalLogDialog(ApplicationView.getInstance());
        dialog.showDialog();
    }
}

