/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelListener;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;

public class OverviewPanel
extends JPanel
implements ComponentListener,
DiagramModelListener,
Observer,
PropertyChangeListener {
    protected AbstractDiagram diagram;
    protected AbstractDiagram originalDiagram;
    protected PannerViewfinder v;
    protected Rectangle r;
    double graphWindowToPannerScale = 0.5;
    static final int PANEL_BUFFER = 2;

    protected OverviewPanel(AbstractDiagram d, JViewport jvp) {
        this.originalDiagram = d;
        this.v = new PannerViewfinder(this, jvp);
        ViewRedirector view = new ViewRedirector(d, d.getDiagramLayoutCache());
        this.diagram = new AbstractDiagram(d.getModel(), view);
        this.diagram.setAntiAliased(true);
        this.diagram.setPageGridVisible(false);
        this.diagram.getModel().addDiagramModelListener(this);
        this.diagram.setEnabled(false);
        this.diagram.addMouseListener(this.v);
        this.diagram.addMouseMotionListener(this.v);
        d.addPropertyChangeListener("scale", this.v);
        d.addPropertyChangeListener("diagramChanged", this);
        this.addComponentListener(this);
        d.getDiagramLayoutCache().addObserver(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.diagram, "Center");
    }

    public static JPanel createOverviewPanel(AbstractDiagram d, JViewport jvp) {
        JPanel panelWithInternalOffset = new JPanel();
        panelWithInternalOffset.setLayout(new BorderLayout());
        panelWithInternalOffset.setBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE));
        panelWithInternalOffset.add((Component)new OverviewPanel(d, jvp), "Center");
        return panelWithInternalOffset;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.componentResized(null);
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.v.update(g);
    }

    @Override
    public void diagramChanged(DiagramModelEvent e) {
        this.componentResized(null);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (DefaultDiagramModel.canUpdate) {
            Dimension d = this.v.getViewport().getView().getSize();
            d.setSize((double)(d.width * 1) / this.v.zoomScale, (double)(d.height * 1) / this.v.zoomScale);
            Dimension s = this.getSize();
            double sx = s.getWidth() / d.getWidth();
            double sy = s.getHeight() / d.getHeight();
            this.graphWindowToPannerScale = Math.min(sx, sy);
            this.diagram.setScale(this.graphWindowToPannerScale);
            this.v.synchViewportWithPanner();
            this.repaint();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.componentResized(e);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        this.componentResized(null);
    }

    class PannerViewfinder
    implements MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    ChangeListener {
        public final int LEFT_VERTICAL = 1;
        public final int RIGHT_VERTICAL = 2;
        public final int UPPER_HORIZONTAL = 4;
        public final int LOWER_HORIZONTAL = 8;
        public final int NW_CORNER = 5;
        public final int NE_CORNER = 6;
        public final int SW_CORNER = 9;
        public final int SE_CORNER = 10;
        int scaledWidth = 50;
        int scaledHeight = 25;
        int last_x;
        int last_y;
        Rectangle pannerContainerRectangle;
        Rectangle pannerViewRectangle;
        Rectangle pannerViewRectangleCopy;
        Rectangle pannerContainerRectangleCopy;
        Container container;
        JViewport viewport;
        double zoomScale = 1.0;
        double combinedScale;
        boolean isActive;
        BasicStroke stroke;
        float[] dash1;
        BasicStroke dashStroke;
        private Point viewportPosition;

        public PannerViewfinder(Container c, JViewport jvp) {
            this.combinedScale = OverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            this.isActive = false;
            this.stroke = new BasicStroke(1.0f);
            this.dash1 = new float[]{2.5f};
            this.dashStroke = new BasicStroke(1.0f, 0, 0, 1.0f, this.dash1, 0.0f);
            this.container = c;
            this.viewport = jvp;
            this.viewport.addChangeListener(this);
            this.pannerViewRectangle = new Rectangle(0, 0, this.scaledWidth, this.scaledHeight);
            this.viewportPosition = new Point(0, 0);
        }

        private boolean isContained(MouseEvent me) {
            return this.pannerViewRectangle.contains(me.getX(), me.getY());
        }

        public JViewport getViewport() {
            return this.viewport;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.synchViewportWithPanner();
            this.container.repaint();
        }

        public void synchViewportWithPanner() {
            Point p = this.viewport.getViewPosition();
            this.combinedScale = OverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            int pannerx = (int)(p.getX() * this.combinedScale);
            int pannery = (int)(p.getY() * this.combinedScale);
            this.pannerViewRectangle.setLocation(pannerx, pannery);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.zoomScale = (Double)evt.getNewValue();
            this.combinedScale = OverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            this.container.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Cursor c = this.container.getCursor();
            int cursorType = c.getType();
            if (cursorType == 0) {
                this.last_x = this.pannerViewRectangle.x - e.getX();
                this.last_y = this.pannerViewRectangle.y - e.getY();
                if (this.isContained(e)) {
                    this.updatePannerLocation(e);
                    this.isActive = true;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.isActive) {
                this.updatePannerLocation(e);
                this.updateViewPort(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isActive) {
                this.isActive = false;
            }
        }

        private void updateViewPort(MouseEvent e) {
            int x = (int)(1.0 / this.combinedScale * this.pannerViewRectangle.getX());
            int y = (int)(1.0 / this.combinedScale * this.pannerViewRectangle.getY());
            Rectangle r = this.viewport.getViewRect();
            if ((double)x + r.getWidth() > this.viewport.getViewSize().getWidth()) {
                x = (int)(this.viewport.getViewSize().getWidth() - r.getWidth());
            }
            if ((double)y + r.getHeight() > this.viewport.getViewSize().getHeight()) {
                y = (int)(this.viewport.getViewSize().getHeight() - r.getHeight());
            }
            this.viewportPosition.setLocation(x, y);
            this.viewport.setViewPosition(this.viewportPosition);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.isContained(e)) {
                this.isActive = true;
                this.pannerViewRectangle.setLocation(e.getPoint());
                this.container.repaint();
                this.isActive = false;
                this.updateViewPort(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        public void updatePannerLocation(MouseEvent e) {
            this.pannerViewRectangle.setLocation(this.last_x + e.getX(), this.last_y + e.getY());
            this.ensureWithinPannerBounds();
            this.container.repaint();
        }

        public void update(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Rectangle viewportR = this.viewport.getViewRect();
            Dimension viewD = this.viewport.getView().getSize();
            this.combinedScale = OverviewPanel.this.graphWindowToPannerScale / this.zoomScale;
            if (this.pannerContainerRectangle == null) {
                this.pannerContainerRectangle = new Rectangle();
            }
            this.pannerContainerRectangle.setSize((int)(viewD.getWidth() * this.combinedScale) - 2, (int)(viewD.getHeight() * this.combinedScale) - 2);
            this.scaledWidth = (int)(viewportR.getWidth() * this.pannerContainerRectangle.getWidth() / viewD.getWidth());
            this.scaledHeight = (int)(viewportR.getHeight() * this.pannerContainerRectangle.getHeight() / viewD.getHeight());
            g2.setStroke(this.stroke);
            this.pannerViewRectangle.setSize(this.scaledWidth, this.scaledHeight);
            g2.setColor(Color.red);
            g2.draw(this.pannerViewRectangle);
        }

        private void ensureWithinPannerBounds() {
            int new_x = this.pannerViewRectangle.x;
            int new_y = this.pannerViewRectangle.y;
            if ((double)(this.pannerViewRectangle.x + this.scaledWidth) > this.pannerContainerRectangle.getWidth()) {
                new_x = (int)this.pannerContainerRectangle.getWidth() - this.scaledWidth + 2;
            }
            if (this.pannerViewRectangle.x < 0) {
                new_x = 0;
            }
            if ((double)(this.pannerViewRectangle.y + this.scaledHeight) > this.pannerContainerRectangle.getHeight()) {
                new_y = (int)this.pannerContainerRectangle.getHeight() - this.scaledHeight + 2;
            }
            if (this.pannerViewRectangle.y < 0) {
                new_y = 0;
            }
            this.pannerViewRectangle.setLocation(new_x, new_y);
        }
    }

    public class ViewRedirector
    extends DiagramLayoutCache {
        protected DiagramLayoutCache realView;

        public ViewRedirector(AbstractDiagram diagram, DiagramLayoutCache realView) {
            super(diagram);
            this.realView = realView;
            this.setModel(diagram.getModel());
        }

        @Override
        public CellView[] getRoots() {
            return this.realView.getRoots();
        }

        @Override
        public CellView getMapping(Object cell, boolean create) {
            if (this.realView != null) {
                return this.realView.getMapping(cell, create);
            }
            return null;
        }

        @Override
        public void putMapping(Object cell, CellView view) {
            if (this.realView != null) {
                this.realView.putMapping(cell, view);
            }
        }
    }
}

