/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.CubeSet;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectElementsDialog;

public class MeasureFolderPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private MeasureFolder measureFolder;
    private JTable sTable;
    private List selectedMeasureWrappers;
    private JButton btnProperties;
    private JButton btnAdd;
    private JButton btnRemove;
    private List allMeasures;
    private JPanel pnMeasures;

    public MeasureFolderPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
    }

    @Override
    public String getCaption() {
        return Messages.getString("MeasureFolderPropertiesDialogEx.MeasureFolderProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "MEASUREFOLDER_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof MeasureFolder) {
            this.measureFolder = (MeasureFolder)object;
            this.initDefaults(false);
            this.taDescription.setText(this.measureFolder.getDescription());
            this.selectedMeasureWrappers.addAll(this.measureFolder.getMeasures());
            this.initOracleNames();
            this.initDynamicProperties();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.selectedMeasureWrappers = new ArrayList();
        this.allMeasures = new ArrayList();
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getMeasuresPanel());
        this.addToTree(root, this.getOracleNamesPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.measureFolder.setName(this.tfName.getText());
        this.measureFolder.setComment(this.taComments.getText());
        this.measureFolder.setNotes(this.taNotes.getText());
        this.measureFolder.setDescription(this.taDescription.getText());
        this.measureFolder.removeMeasures();
        Iterator itm = this.selectedMeasureWrappers.iterator();
        while (itm.hasNext()) {
            this.measureFolder.addMeasure((MeasureFolder.MFElement)itm.next());
        }
        this.setOracleNames();
        MeasureFolderPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.measureFolder.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.measureFolder.setProperty(dp.getName(), dp.getValue());
        }
    }

    private void getAllMeasures(MeasureFolder measureFolder) {
        CubeSet cubes = ((MultidimensionalDesign)measureFolder.getDesignPart()).getCubeSet();
        Iterator cubeIterator = cubes.iterator();
        while (cubeIterator.hasNext()) {
            Cube cube = (Cube)cubeIterator.next();
            for (Measure measure : cube.getMeasures()) {
                MeasureFolder measureFolder2 = measureFolder;
                measureFolder2.getClass();
                MeasureFolder.MFElement mfelement = measureFolder2.new MeasureFolder.MFElement(cube, measure);
                if (this.isSelected(mfelement)) continue;
                this.allMeasures.add(mfelement);
            }
            for (Slice slice : cube.getPrecalculatedSlices()) {
                for (Slice.MeasureWrapper measure : slice.getSelectedMeasureWrappers()) {
                    MeasureFolder measureFolder3 = measureFolder;
                    measureFolder3.getClass();
                    MeasureFolder.MFElement mfelement = measureFolder3.new MeasureFolder.MFElement(slice, measure);
                    if (this.isSelected(mfelement)) continue;
                    this.allMeasures.add(mfelement);
                }
            }
        }
    }

    private boolean isSelected(MeasureFolder.MFElement mfelement) {
        for (MeasureFolder.MFElement element : this.selectedMeasureWrappers) {
            if (!element.toString().equals(mfelement.toString())) continue;
            return true;
        }
        return false;
    }

    protected JPanel getMeasuresPanel() {
        if (this.pnMeasures == null) {
            this.pnMeasures = this.createPage(Messages.getString("MeasureFolderPropertiesDialogEx.Measures"));
            this.sTable = new JTable(new MeasureWrappersModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MeasureFolder.MFElement mfe;
                    Measure measure;
                    int row;
                    if (e.getClickCount() == 2 && (row = MeasureFolderPropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && row < MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size() && (measure = (Measure)((MultidimensionalDesign)(mfe = (MeasureFolder.MFElement)MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.get(row)).getParent().getDesignPart()).getMeasureSet().getObjectByID(mfe.getMeasureObjectID())) != null) {
                        measure.showPropertyDialog();
                    }
                }
            });
            this.sTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = MeasureFolderPropertiesDialogEx.this.sTable.getSelectedRow();
                        if (selectedRow == -1) {
                            MeasureFolderPropertiesDialogEx.this.btnProperties.setEnabled(false);
                            MeasureFolderPropertiesDialogEx.this.btnRemove.setEnabled(false);
                        } else {
                            MeasureFolderPropertiesDialogEx.this.btnProperties.setEnabled(true);
                            MeasureFolderPropertiesDialogEx.this.btnRemove.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.sTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProperties.setEnabled(false);
            this.btnProperties.setToolTipText(BTN_PROPERTIES);
            this.btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MeasureFolder.MFElement mfe;
                    Measure measure;
                    int row = MeasureFolderPropertiesDialogEx.this.sTable.getSelectedRow();
                    if (row != -1 && MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && row < MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size() && (measure = (Measure)((MultidimensionalDesign)(mfe = (MeasureFolder.MFElement)MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.get(row)).getParent().getDesignPart()).getMeasureSet().getObjectByID(mfe.getMeasureObjectID())) != null) {
                        measure.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MeasureFolderPropertiesDialogEx.this.allMeasures.clear();
                        MeasureFolderPropertiesDialogEx.this.getAllMeasures(MeasureFolderPropertiesDialogEx.this.measureFolder);
                        SelectElementsDialog dialog = new SelectElementsDialog(MeasureFolderPropertiesDialogEx.this.getAppView(), MeasureFolderPropertiesDialogEx.this.allMeasures, MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers);
                        dialog.setVisible(true);
                        MeasureFolderPropertiesDialogEx.this.sTable.clearSelection();
                        int lastRow = MeasureFolderPropertiesDialogEx.this.sTable.convertRowIndexToView(MeasureFolderPropertiesDialogEx.this.sTable.getModel().getRowCount() - 1);
                        MeasureFolderPropertiesDialogEx.this.sTable.setRowSelectionInterval(lastRow, lastRow);
                        MeasureFolderPropertiesDialogEx.this.sTable.updateUI();
                    }
                });
                this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setEnabled(false);
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = MeasureFolderPropertiesDialogEx.this.sTable.getSelectedRow();
                        if (objectNumber != -1 && MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && objectNumber < MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                            MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.remove(objectNumber);
                            MeasureFolderPropertiesDialogEx.this.sTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAdd);
                toolBar.add(this.btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnMeasures.add(pPanel);
        }
        return this.pnMeasures;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class MeasureWrappersModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("MeasureFolderPropertiesDialogEx.MeasureName")};

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            return this.COL_NAMES[col];
        }

        @Override
        public int getRowCount() {
            return MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            MeasureFolder.MFElement object = (MeasureFolder.MFElement)MeasureFolderPropertiesDialogEx.this.selectedMeasureWrappers.get(row);
            if (col == 0) {
                return object;
            }
            return "";
        }
    }
}

