/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;

public abstract class AbstractPropertyTab
extends Component {
    protected static final String ADD_CAPTION = AbstractPropertyDialog.ADD_CAPTION;
    protected static final String REMOVE_CAPTION = AbstractPropertyDialog.REMOVE_CAPTION;
    protected static final String YES = AbstractPropertyDialog.YES;
    protected static final String NO = AbstractPropertyDialog.NO;
    protected static final String[] YES_NO = AbstractPropertyDialog.YES_NO;
    protected static final int FIELD_WIDTH = 26;
    private static final int RIGHT_MARGIN_WIDTH = 20;
    private int dialogWidth = this.getDialogWidth();
    private ApplicationView appView;
    protected StorageDesign storageDesign;
    private StorageObject storageObject;

    public AbstractPropertyTab(ApplicationView appView, StorageDesign storageDesign, StorageObject storageObject) {
        this.appView = appView;
        this.storageDesign = storageDesign;
        this.storageObject = storageObject;
    }

    protected int getDialogWidth() {
        return 450;
    }

    protected void setLabelConstraints(SpringLayout layout, JLabel label, int x, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(label);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    protected void setLabelConstraints(SpringLayout layout, JLabel label, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(SpringLayout layout, Component c, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(c);
        labelCons.setConstraint("East", Spring.constant(this.dialogWidth - 20));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(SpringLayout layout, Component c, int x, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    public void setBG(Component c) {
        c.setBackground(Color.WHITE);
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public StorageObject getStorageObject() {
        return this.storageObject;
    }

    protected boolean isEditable() {
        if (this.getStorageObject().isReadOnly()) {
            return false;
        }
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }
}

