/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class PKPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private PKProxySqlServerv2k5 pkey;
    private String comment = "";
    private String commentInRDBMS = "";
    private JTextField tfTable;
    private JComboBox cbClustered;
    private JComboBox cbFilegroup;
    private JIntegerField ifFillFactor;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;
    private JComboBox cbPartitionScheme;
    private JComboBox cbPartitioningColumn;
    private JComboBox cbPadIndex;
    private JComboBox cbRecomputeStatistics;
    private JComboBox cbIgnoreDupKey;
    private JComboBox cbAllowRowLocks;
    private JComboBox cbAllowPageLocks;

    public PKPropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.pkey = (PKProxySqlServerv2k5)object;
        this.setHeight(430);
        this.initColumnsView(this.getPane().getPreferredSize().height - 70);
        this.initCommentsView(180);
        this.initCommentsInRDBMS();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("PKPropertyDialogSqlServerv2k5.PKProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initClustered();
        this.initFileGroup();
        this.initFillFactor();
        this.initPartitionScheme();
        this.initPartitioningColumn();
        this.initPadIndex();
        this.initRecomputeStatistics();
        this.initIgnoreDupKey();
        this.initAllowRowLocks();
        this.initAllowPageLocks();
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initClustered() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.Clustered"));
        this.general.add(label);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbClustered, 80);
    }

    private void initFileGroup() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.Filegroup"));
        this.general.add(label);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbFilegroup, 110);
    }

    private void initPartitionScheme() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.PartitionScheme"));
        this.general.add(label);
        this.cbPartitionScheme = new JComboBox();
        this.setBG(this.cbPartitionScheme);
        this.cbPartitionScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitionScheme.setToolTipText(Messages.getString("PKPropertyDialogSqlServerv2k5.PartitionSchemeWillBeTaken"));
        this.general.add(this.cbPartitionScheme);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbPartitionScheme, 140);
    }

    private void initPartitioningColumn() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.PartitioningColumn"));
        this.general.add(label);
        this.cbPartitioningColumn = new JComboBox();
        this.setBG(this.cbPartitioningColumn);
        this.cbPartitioningColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartitioningColumn);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbPartitioningColumn, 170);
    }

    private void initPadIndex() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.PadIndex"));
        this.general.add(label);
        this.cbPadIndex = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPadIndex);
        this.cbPadIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPadIndex);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbPadIndex, 200);
    }

    private void initFillFactor() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.FillFactor"));
        this.general.add(label);
        this.ifFillFactor = new JIntegerField(0, 26);
        this.general.add(this.ifFillFactor);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifFillFactor, 230);
    }

    private void initRecomputeStatistics() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.RecomputeStat"));
        this.general.add(label);
        this.cbRecomputeStatistics = new JComboBox<String>(ConstantsSqlServer.AUTO_NO_CHOICES);
        this.setBG(this.cbRecomputeStatistics);
        this.cbRecomputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecomputeStatistics);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbRecomputeStatistics, 260);
    }

    private void initIgnoreDupKey() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.IgnoreDupKey"));
        this.general.add(label);
        this.cbIgnoreDupKey = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIgnoreDupKey);
        this.cbIgnoreDupKey.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIgnoreDupKey);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbIgnoreDupKey, 290);
    }

    private void initAllowRowLocks() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.AllowRowLocks"));
        this.general.add(label);
        this.cbAllowRowLocks = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbAllowRowLocks);
        this.cbAllowRowLocks.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAllowRowLocks);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbAllowRowLocks, 320);
    }

    private void initAllowPageLocks() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.AllowPageLocks"));
        this.general.add(label);
        this.cbAllowPageLocks = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbAllowPageLocks);
        this.cbAllowPageLocks.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAllowPageLocks);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbAllowPageLocks, 350);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogSqlServerv2k5.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.columnList);
        sp.setPreferredSize(new Dimension(395, 380));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initCommentsInRDBMS() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogSqlServerv2k5.CommentsInRDBMS"));
        this.comments.add(label);
        this.setLabelConstraints(this.getCommentsLayout(), label, 10, 200);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(395, 160));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 230);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.pkey.getName());
        this.tfName.setText(this.pkey.getName());
        ColumnProxy[] proxies = this.pkey.getColumnProxies();
        for (int i = 0; i < proxies.length; ++i) {
            ColumnProxy proxy = proxies[i];
            this.columnListModel.addElement(proxy);
        }
        this.tfTable.setText(this.pkey.getTableName());
        if (this.pkey.isClustered()) {
            this.cbClustered.setSelectedItem(YES);
        } else {
            this.cbClustered.setSelectedItem(NO);
        }
        if (((TableProxySqlServer)this.pkey.getTableProxy()).existClusteredIndex(this.pkey)) {
            this.cbClustered.setEnabled(false);
        } else {
            this.cbClustered.setEnabled(true);
        }
        this.cbFilegroup.addItem(null);
        this.cbPartitionScheme.addItem(null);
        DataBaseSqlServerv2k5 db = (DataBaseSqlServerv2k5)((TableProxySqlServer)this.pkey.getTableProxy()).getDatabase();
        if (db != null) {
            for (FileGroupSqlServer fg : (StorageObjectCollection)db.getChild(0)) {
                this.cbFilegroup.addItem(fg);
            }
            this.cbFilegroup.setSelectedItem(this.pkey.getFilegroup());
            for (PartitionFunctionSqlServerv2k5 partFunc : db.getPartitionFunction()) {
                Iterator partSchemeIt = partFunc.getPartitionScheme().iterator();
                while (partSchemeIt.hasNext()) {
                    this.cbPartitionScheme.addItem(partSchemeIt.next());
                }
            }
            this.cbPartitionScheme.setSelectedItem(this.pkey.getPartitionScheme());
        }
        this.fillComboItems(this.pkey.getTableProxy().getColumnProxies(), this.cbPartitioningColumn);
        this.cbPartitioningColumn.setSelectedItem(this.pkey.getPartitioningColumn());
        this.ifFillFactor.setValue((long)this.pkey.getFillFactor());
        this.cbRecomputeStatistics.setSelectedItem(this.pkey.getRecomputeStatistics());
        this.cbIgnoreDupKey.setSelectedItem(PKPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.pkey.getIgnoreDupKey()));
        this.cbAllowRowLocks.setSelectedItem(this.pkey.getAllowRowLocks());
        this.cbAllowPageLocks.setSelectedItem(this.pkey.getAllowPageLocks());
        this.cbPadIndex.setSelectedItem(PKPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.pkey.getPadIndex()));
        this.comment = this.pkey.getObject().getComment();
        this.commentInRDBMS = this.pkey.getObject().getCommentInRDBMS();
        if (this.pkey.isCommentChanged()) {
            this.getCommentsList().insert(this.pkey.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.pkey.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.pkey.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initColumnsSortOrder();
    }

    @Override
    protected void setProperties() {
        if (this.pkey != null) {
            this.pkey.setName(this.tfName.getText());
            if (((String)this.cbClustered.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.pkey.setClustered(true);
            } else {
                this.pkey.setClustered(false);
            }
            if (((TableProxySqlServer)this.pkey.getTableProxy()).existClusteredIndex(this.pkey)) {
                this.cbClustered.setEnabled(false);
            } else {
                this.cbClustered.setEnabled(true);
            }
            this.pkey.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.pkey.setFillFactor(this.ifFillFactor.getIntValue());
            this.ifFillFactor.setValue((long)this.pkey.getFillFactor());
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.pkey.setComment(commentText);
                this.pkey.setCommentChanged(true);
            } else {
                this.pkey.setComment("");
                this.pkey.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.pkey.setCommentInRDBMS(commentInRDBMSText);
                this.pkey.setCommentInRDBMSChanged(true);
            } else {
                this.pkey.setCommentInRDBMS("");
                this.pkey.setCommentInRDBMSChanged(false);
            }
            this.pkey.setPartitionScheme((PartitionSchemeSqlServer)this.cbPartitionScheme.getSelectedItem());
            this.pkey.setPartitioningColumn((ColumnProxy)this.cbPartitioningColumn.getSelectedItem());
            this.pkey.setPadIndex(PKPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbPadIndex.getSelectedItem()));
            this.pkey.setRecomputeStatistics((String)this.cbRecomputeStatistics.getSelectedItem());
            this.pkey.setAllowRowLocks((String)this.cbAllowRowLocks.getSelectedItem());
            this.pkey.setAllowPageLocks((String)this.cbAllowPageLocks.getSelectedItem());
            this.pkey.setIgnoreDupKey(PKPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbIgnoreDupKey.getSelectedItem()));
            this.applyColumnsSortOrder();
        }
    }

    protected void initColumnsView(int height) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogSqlServerv2k5.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        JScrollPane sp = new JScrollPane(this.columnsTable);
        sp.setPreferredSize(new Dimension(395, height));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(sp);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.pkey.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection colNodes = this.sortModel.getColumnsSortOrederColl();
        Iterator it = colNodes.iterator();
        Index ind = (Index)this.pkey.getObject();
        while (it.hasNext()) {
            ColumnsSortOrderModel.ColumnNode cn = (ColumnsSortOrderModel.ColumnNode)it.next();
            Column col = (Column)ind.getElementByID(cn.objectId);
            if (col == null) continue;
            ind.setColumnSortOrder(col, cn.sortOrder);
        }
    }
}

