/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.v81.OwnerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SequenceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StoredProcedureUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.StoredProcedurePropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.UserAndGroupPermissionsDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.SchemaPropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.SequencePropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TablePropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TableViewPropertyDialogUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TriggerPropertyDialogUDBv81;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class OwnerPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private static final long serialVersionUID = 3281813884019124244L;
    private OwnerUDBv81 owner;
    private JPanel schemas;
    private DefaultListModel schemaListModel;
    private JList schemaList;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel triggers;
    private DefaultListModel triggerListModel;
    private JList triggerList;
    private JPanel views;
    private DefaultListModel viewListModel;
    private JList viewList;
    private JPanel procedures;
    private DefaultListModel procListModel;
    private JList procList;
    private JPanel sequences;
    private DefaultListModel seqListModel;
    private JList seqList;
    private JButton bnPermissions;
    private UserAndGroupPermissionsDialogUDB dialog;

    public OwnerPropertyDialogUDBv81(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.owner = (OwnerUDBv81)object;
        this.setHeight(150);
        this.initCommentsView(80);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("OwnerPropertyDialogUDBv81.OwnerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initPermissionsButton();
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("OwnerPropertyDialogUDBv81.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 75);
    }

    @Override
    protected void addTabs() {
        this.initSchemasView();
        this.initTablesView();
        this.initTriggersView();
        this.initViewsView();
        this.initStoredProceduresView();
        this.initSequencesView();
    }

    private void initSchemasView() {
        this.schemas = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.Schemas"), this.schemas);
        this.initSchemas();
    }

    private void initSchemas() {
        this.schemaListModel = new DefaultListModel();
        this.schemaList = new JList(this.schemaListModel);
        this.schemaList.addMouseListener(new SchemaListMouseListener());
        JScrollPane spTS = new JScrollPane(this.schemaList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.schemas.add(spTS);
        this.setObjectConstraints(this.getSchemaLayout(), spTS, 10, 12);
    }

    protected SpringLayout getSchemaLayout() {
        return (SpringLayout)this.schemas.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane spTS = new JScrollPane(this.tableList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(spTS);
        this.setObjectConstraints(this.getTableLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initTriggersView() {
        this.triggers = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.Triggers"), this.triggers);
        this.initTriggers();
    }

    private void initTriggers() {
        this.triggerListModel = new DefaultListModel();
        this.triggerList = new JList(this.triggerListModel);
        this.triggerList.addMouseListener(new TriggerListMouseListener());
        JScrollPane spTS = new JScrollPane(this.triggerList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.triggers.add(spTS);
        this.setObjectConstraints(this.getTriggerLayout(), spTS, 10, 12);
    }

    protected SpringLayout getTriggerLayout() {
        return (SpringLayout)this.triggers.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.addMouseListener(new ViewListMouseListener());
        JScrollPane spTS = new JScrollPane(this.viewList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(spTS);
        this.setObjectConstraints(this.getViewLayout(), spTS, 10, 12);
    }

    protected SpringLayout getViewLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initStoredProceduresView() {
        this.procedures = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.StoredProcedures"), this.procedures);
        this.initProcedures();
    }

    private void initProcedures() {
        this.procListModel = new DefaultListModel();
        this.procList = new JList(this.procListModel);
        this.procList.addMouseListener(new ProcListMouseListener());
        JScrollPane spTS = new JScrollPane(this.procList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.procedures.add(spTS);
        this.setObjectConstraints(this.getProcedureLayout(), spTS, 10, 12);
    }

    protected SpringLayout getProcedureLayout() {
        return (SpringLayout)this.procedures.getLayout();
    }

    private void initSequencesView() {
        this.sequences = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogUDBv81.Sequences"), this.sequences);
        this.initSequences();
    }

    private void initSequences() {
        this.seqListModel = new DefaultListModel();
        this.seqList = new JList(this.seqListModel);
        this.seqList.addMouseListener(new SequencesListMouseListener());
        JScrollPane spTS = new JScrollPane(this.seqList);
        spTS.setPreferredSize(new Dimension(395, 80));
        spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.sequences.add(spTS);
        this.setObjectConstraints(this.getSequencesLayout(), spTS, 10, 12);
    }

    protected SpringLayout getSequencesLayout() {
        return (SpringLayout)this.sequences.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.owner.getName());
        this.tfName.setText(this.owner.getName());
        this.getCommentsList().insert(this.owner.getComment(), 0);
        if (this.owner.isNullInstance()) {
            this.tfName.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
        Object[] schema = this.getStorageDesign().getSchemaSet().toArray();
        for (int i = 0; i < schema.length; ++i) {
            if (((SchemaUDBv81)schema[i]).getOwner() != this.owner) continue;
            this.schemaListModel.addElement(schema[i]);
        }
        Object[] table = this.getStorageDesign().getTableProxySet().toArray();
        TableProxyUDBv81 t = null;
        for (int i = 0; i < table.length; ++i) {
            t = (TableProxyUDBv81)table[i];
            if (t.getOwner() != this.owner && (t.getSchema() == null || t.getSchema().getOwner() != this.owner)) continue;
            this.tableListModel.addElement(table[i]);
        }
        Object[] tr = this.getStorageDesign().getTriggerSet().toArray();
        for (int i = 0; i < tr.length; ++i) {
            if (((TriggerUDBv81)tr[i]).getOwner() != this.owner) continue;
            this.triggerListModel.addElement(tr[i]);
        }
        Object[] view = this.getStorageDesign().getTableViewProxySet().toArray();
        TableViewProxyUDBv81 v = null;
        for (int i = 0; i < view.length; ++i) {
            v = (TableViewProxyUDBv81)view[i];
            if (v.getOwner() != this.owner && (v.getSchema() == null || v.getSchema().getOwner() != this.owner)) continue;
            this.viewListModel.addElement(view[i]);
        }
        Object[] proc = this.getStorageDesign().getStoredProcedureSet().toArray();
        for (int i = 0; i < proc.length; ++i) {
            if (((StoredProcedureUDBv81)proc[i]).getOwner() != this.owner) continue;
            this.procListModel.addElement(proc[i]);
        }
        Object[] seq = ((StorageDesignUDBv81)this.getStorageDesign()).getSequenceSet().toArray();
        for (int i = 0; i < seq.length; ++i) {
            if (((SequenceUDBv81)seq[i]).getOwner() != this.owner) continue;
            this.seqListModel.addElement(seq[i]);
        }
    }

    @Override
    protected void setProperties() {
        if (this.owner != null && !this.owner.isNullInstance()) {
            String oldName = this.owner.getName();
            this.owner.setName(this.tfName.getText());
            this.owner.setComment(this.getCommentsList().getText());
            if (!this.tfName.getText().equals(oldName)) {
                this.owner.setNameChanged(true);
            }
        }
    }

    private class SequencesListMouseListener
    extends MouseAdapter {
        private SequencesListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SequenceUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (SequenceUDBv81)OwnerPropertyDialogUDBv81.this.seqList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                SequencePropertyDialogUDBv81 dialog = new SequencePropertyDialogUDBv81(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class ProcListMouseListener
    extends MouseAdapter {
        private ProcListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            StoredProcedureUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (StoredProcedureUDBv81)OwnerPropertyDialogUDBv81.this.procList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                StoredProcedurePropertyDialogUDB dialog = new StoredProcedurePropertyDialogUDB(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class ViewListMouseListener
    extends MouseAdapter {
        private ViewListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableViewProxyUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (TableViewProxyUDBv81)OwnerPropertyDialogUDBv81.this.viewList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableViewPropertyDialogUDBv81 dialog = new TableViewPropertyDialogUDBv81(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class TriggerListMouseListener
    extends MouseAdapter {
        private TriggerListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TriggerUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (TriggerUDBv81)OwnerPropertyDialogUDBv81.this.triggerList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TriggerPropertyDialogUDBv81 dialog = new TriggerPropertyDialogUDBv81(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyUDBv81)OwnerPropertyDialogUDBv81.this.tableList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TablePropertyDialogUDBv81 dialog = new TablePropertyDialogUDBv81(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class SchemaListMouseListener
    extends MouseAdapter {
        private SchemaListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SchemaUDBv81 selected;
            if (e.getClickCount() == 2 && (selected = (SchemaUDBv81)OwnerPropertyDialogUDBv81.this.schemaList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                SchemaPropertyDialogUDBv81 dialog = new SchemaPropertyDialogUDBv81(OwnerPropertyDialogUDBv81.this.owner.getDesign().getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OwnerPropertyDialogUDBv81.this.dialog == null) {
                OwnerPropertyDialogUDBv81.this.dialog = new UserAndGroupPermissionsDialogUDB(OwnerPropertyDialogUDBv81.this.getAppView(), OwnerPropertyDialogUDBv81.this.getStorageDesign(), OwnerPropertyDialogUDBv81.this.owner);
            }
            OwnerPropertyDialogUDBv81.this.dialog.showDialog();
        }
    }
}

