/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.glossary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.editor.StringEditor;
import oracle.dbtools.crest.swingui.glossary.ImportGlossaryDialog;
import oracle.dbtools.crest.swingui.glossary.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.compare.StringComparator;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JCharField;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class GlossaryDialog
extends CustomDialog {
    private Glossary glossary;
    private ApplicationView appView;
    private List allWords;
    private List selectedWords = new ArrayList();
    private JDialog dialog;
    private JButton bnClose;
    private JButton bnSave;
    private JButton bnSaveAs;
    private JButton bnImport;
    private JButton bnExport;
    private WordJTable wordsTable;
    private boolean badWordName = false;
    private static final Comparator COMPARATOR = new StringComparator();
    private JComboBox cbFilter;
    private JTextField tfName;
    private JTextField tfDescription;
    public static String CWD_GLOSS_DESC = Messages.getString("GlossaryDialog.CWDGlossaryFiles");
    public static String ERWIN_TXT_GLOSS_DESC = Messages.getString("GlossaryDialog.ERwinExportedNamesTXT");
    public static String DM_CSV_GLOSS_DESC = Messages.getString("GlossaryDialog.DMExportedNamesCSV");
    public static String EXCEL_GLOSS_DESC = Messages.getString("GlossaryDialog.PreviouslyExportedExcelFiles");
    public static String RDA7_GLOSS_DESC = Messages.getString("GlossaryDialog.RDA7GlossaryFiles");
    private static String CHARACTER_L = Messages.getString("GlossaryDialog.Character");
    private static String SPACE_L = Messages.getString("GlossaryDialog.Space");
    private static String ALL_L = Messages.getString("GlossaryDialog.ALL");
    private static String PRIME_WORD_L = Messages.getString("GlossaryDialog.PrimeWord");
    private static String CLASS_WORD_L = Messages.getString("GlossaryDialog.ClassWord");
    private static String MODIFIER_L = Messages.getString("GlossaryDialog.Modifier");
    private static String QUALIFIER_L = Messages.getString("GlossaryDialog.Qualifier");
    private static String UNCLASSIFIED_L = Messages.getString("GlossaryDialog.Unclassified");
    private JCheckBox chbIncomplete = new JCheckBox(Messages.getString("GlossaryDialog.IncompleteModifiers"));
    private JCheckBox chbCaseSensitive = new JCheckBox(Messages.getString("GlossaryDialog.CaseSensitive"));
    private JComboBox cbSeparator;
    private JLabel lbSeparator = new JLabel(Messages.getString("GlossaryDialog.Separator"));
    private JCharField tfSeparator = new JCharField();
    private JLabel lbCharSep = new JLabel(Messages.getString("GlossaryDialog.SepChar"));
    private JCheckBox chbUniqueAbbreviations = new JCheckBox(Messages.getString("GlossaryDialog.UniqueAbbreviations"));
    private JButton bnSeparator = new JButton(Messages.getString("GlossaryDialog.ApplyNewSeparator"));
    private JButton removeButton;
    private static File lastExpFolder = null;
    private static File lastImpFolder = null;
    private LinkedHashMap mapSeparator = new LinkedHashMap();
    private LinkedHashMap mapFilter = new LinkedHashMap();
    private Window wind;

    public GlossaryDialog(Window wind, Glossary glossary) {
        super(ApplicationView.getInstance());
        this.appView = ApplicationView.getInstance();
        this.glossary = glossary;
        this.wind = wind;
        this.mapSeparator.put(Glossary.CHARACTER, CHARACTER_L);
        this.mapSeparator.put(Glossary.SPACE, SPACE_L);
        this.cbSeparator = new JComboBox<Object>(this.mapSeparator.values().toArray());
        this.mapFilter.put(ALL_L, ALL_L);
        this.mapFilter.put("Prime Word", PRIME_WORD_L);
        this.mapFilter.put("Class Word", CLASS_WORD_L);
        this.mapFilter.put("Modifier", MODIFIER_L);
        this.mapFilter.put("Qualifier", QUALIFIER_L);
        this.mapFilter.put(UNCLASSIFIED_L, UNCLASSIFIED_L);
        this.allWords = glossary.getWords();
        this.selectedWords.addAll(this.allWords);
        Collections.sort(this.selectedWords, COMPARATOR);
        this.add((Component)this.initWordsPanel(), "Center");
        this.add((Component)this.initButtonsPanel(), "South");
        this.validateMultiwords(glossary.getMW_SeparatorChar());
    }

    private boolean save() {
        if (this.stopEditing()) {
            this.glossary.setName(this.tfName.getText());
            this.glossary.setDescription(this.tfDescription.getText());
            this.glossary.setIncompleteModifiers(this.chbIncomplete.isSelected());
            this.glossary.setUniqueAbbreviations(this.chbUniqueAbbreviations.isSelected());
            this.glossary.setCaseSensitive(this.chbCaseSensitive.isSelected());
            this.glossary.save();
            this.glossary.clearDirtyFlag();
            ((JDialog)this.getDialog()).setTitle(Messages.getString("GlossaryDialog.GlossaryEditor") + this.glossary.getFileName());
            return true;
        }
        return false;
    }

    private boolean saveAs() {
        if (this.stopEditing()) {
            this.glossary.setName(this.tfName.getText());
            this.glossary.setDescription(this.tfDescription.getText());
            this.glossary.setIncompleteModifiers(this.chbIncomplete.isSelected());
            this.glossary.setUniqueAbbreviations(this.chbUniqueAbbreviations.isSelected());
            this.glossary.setCaseSensitive(this.chbCaseSensitive.isSelected());
            this.glossary.saveAs(this.appView);
            this.glossary.clearDirtyFlag();
            ((JDialog)this.getDialog()).setTitle(Messages.getString("GlossaryDialog.GlossaryEditor") + this.glossary.getFileName());
            return true;
        }
        return false;
    }

    private boolean exportToFile() {
        if (this.stopEditing()) {
            try {
                File file;
                int status;
                URLFilter csvFilter = new URLFilter(){

                    public boolean accept(URL url) {
                        File file = new File(url.getPath());
                        return file.getName().toLowerCase().endsWith(".csv") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("GlossaryDialog.CSVFile");
                    }
                };
                URLFilter xlsFilter = new URLFilter(){

                    public boolean accept(URL url) {
                        File file = new File(url.getPath());
                        return file.getName().toLowerCase().endsWith(".xls") || file.getName().toLowerCase().endsWith(".xlsx") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("GlossaryDialog.ExcelFiles");
                    }
                };
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(0);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setURLFilter(csvFilter);
                fileChooser.setURLFilter(xlsFilter);
                fileChooser.setPathContext("dataModeler_Glossary");
                if (lastExpFolder != null) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
                } else {
                    String lastDir = this.appView.getSettings().getDefaultSavePath();
                    if (lastDir != null && lastDir.length() > 0) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = this.appView.getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                }
                String name = this.tfName.getText().trim();
                if (!"".equalsIgnoreCase(name)) {
                    ApplicationView.waitLoadFilesThreadToComplete();
                    fileChooser.setFileNameURL(name + ".csv");
                }
                if ((status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("GlossaryDialog.ExportCWDGlossaryToCSVFile"))) == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    lastExpFolder = file.getParentFile();
                    String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length());
                    if (extension.equalsIgnoreCase("xls")) {
                        if (this.glossary.exportAsXLSFile(file)) {
                            MessageDialogs.showMessage(MessageFormat.format(Messages.getString("GlossaryDialog.GlossaryExportedOK"), file));
                        }
                    } else if (extension.equalsIgnoreCase("xlsx")) {
                        if (this.glossary.exportAsXLSXFile(file)) {
                            MessageDialogs.showMessage(MessageFormat.format(Messages.getString("GlossaryDialog.GlossaryExportedOK"), file));
                        }
                    } else if (extension.equalsIgnoreCase("csv") && this.glossary.exportAsCSVFile(file, this.appView)) {
                        MessageDialogs.showMessage(MessageFormat.format(Messages.getString("GlossaryDialog.GlossaryExportedOK"), file));
                    }
                }
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("GlossaryDialog.UnexpectedError"), t.getMessage()}, Messages.getString("GlossaryDialog.WriteError"), 0);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean stopEditing() {
        int row = this.wordsTable.getEditingRow();
        int col = this.wordsTable.getEditingColumn();
        return col <= -1 || row <= -1 || this.wordsTable.getCellEditor(row, col).stopCellEditing();
    }

    @Override
    protected void close() {
        int result;
        if (this.glossary.isDirty() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("GlossaryDialog.Glossary"), this.glossary.getName()), Messages.getString("GlossaryDialog.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 0 && !this.save()) {
            return;
        }
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.wind, Messages.getString("GlossaryDialog.GlossaryEditor") + this.glossary.getFileName());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setModal(false);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.bnSave);
            this.setDefaultActions(this.dialog);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = GlossaryDialog.this.dialog.getWidth();
                    int h = GlossaryDialog.this.dialog.getHeight();
                    w = Math.max(GlossaryDialog.this.getMinimumWidth(), w);
                    h = Math.max(GlossaryDialog.this.getMinimumHeight(), h);
                    GlossaryDialog.this.dialog.setSize(w, h);
                }
            });
            this.dialog.pack();
            this.dialog.setModal(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    protected int getMinimumWidth() {
        return 1050;
    }

    protected int getMinimumHeight() {
        return 600;
    }

    private JPanel initButtonsPanel() {
        JPanel pnButtons = new JPanel(new FlowLayout(2));
        this.bnImport = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.Import")));
        this.bnImport.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("GlossaryDialog.Import")));
        this.bnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryDialog.this.importGlossary(GlossaryDialog.this.appView);
            }
        });
        this.bnExport = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.Export")));
        this.bnExport.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("GlossaryDialog.Export")));
        this.bnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryDialog.this.exportToFile();
            }
        });
        this.bnSave = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.Save")));
        this.bnSave.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("GlossaryDialog.Save")));
        this.bnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryDialog.this.save();
            }
        });
        this.bnSaveAs = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.SaveAs")));
        this.bnSaveAs.setMnemonic(MenuUtils.getMnemonicChar(Messages.getString("GlossaryDialog.SaveAs")));
        this.bnSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryDialog.this.saveAs();
            }
        });
        this.bnClose = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.Close")));
        this.bnClose.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("GlossaryDialog.Close")));
        this.bnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryDialog.this.close();
            }
        });
        pnButtons.add(this.bnImport);
        pnButtons.add(this.bnExport);
        pnButtons.add(this.bnSave);
        pnButtons.add(this.bnSaveAs);
        pnButtons.add(this.bnClose);
        JButton bnHelp = new JButton(MenuUtils.getMnemonicStr(Messages.getString("GlossaryDialog.Help")));
        bnHelp.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("GlossaryDialog.Help")));
        bnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryDialog.this.showHelp();
            }
        });
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        pnButtons.add(bnHelp);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnSaveAs.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        return pnButtons;
    }

    private JPanel initWordsPanel() {
        Dimension comboDim = new Dimension(100, 22);
        Dimension charDim = new Dimension(10, 22);
        JPanel jpanel = new JPanel(new BorderLayout());
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("GlossaryDialog.GlossaryProperties"));
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("GlossaryDialog.Words"));
        TitledBorder optionsBorder = new TitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("GlossaryDialog.Options"));
        JPanel editorPanel = new JPanel();
        editorPanel.setPreferredSize(new Dimension(900, 600));
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        editorPanel.setLayout(gridBagLayout2);
        JPanel glossPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.tfName = new JTextField(this.glossary.getName());
        JLabel jLabel2 = new JLabel();
        this.tfDescription = new JTextField(this.glossary.getDescription());
        JPanel wordsPanel = new JPanel();
        BorderLayout borderLayout2 = new BorderLayout();
        this.cbFilter = new JComboBox();
        for (String value : this.mapFilter.values()) {
            this.cbFilter.addItem(value);
        }
        this.cbFilter.setSelectedItem(this.mapFilter.get(ALL_L));
        this.cbFilter.setMaximumSize(comboDim);
        this.cbFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryDialog.this.filterWords();
            }
        });
        JButton addButton = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        addButton.addActionListener(new AddWordAction());
        this.removeButton = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.removeButton.addActionListener(new RemoveWordAction());
        this.removeButton.setEnabled(false);
        JLabel lbFilter = new JLabel();
        JLabel lbDefault = new JLabel();
        JPanel tablePanel = new JPanel(new BorderLayout());
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(0);
        JPanel pnOptions = new JPanel(fl);
        pnOptions.setBorder(optionsBorder);
        pnOptions.add(this.chbIncomplete);
        String tip = Messages.getString("GlossaryDialog.HTMLTip1.0") + "\n" + Messages.getString(Messages.getString("GlossaryDialog.5"));
        this.chbIncomplete.setToolTipText(tip);
        pnOptions.add(this.chbCaseSensitive);
        pnOptions.add(this.chbUniqueAbbreviations);
        this.chbUniqueAbbreviations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryDialog.this.checkAndShowWordsWithNoneUniqueAbbreviations();
            }
        });
        this.chbUniqueAbbreviations.setToolTipText(Messages.getString("GlossaryDialog.ShowReportAboutWords"));
        pnOptions.add(this.lbSeparator);
        pnOptions.add(this.cbSeparator);
        pnOptions.add(this.lbCharSep);
        this.cbSeparator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryDialog.this.bnSeparator.setEnabled(GlossaryDialog.this.isDifferentSeparator() && !"".equalsIgnoreCase(GlossaryDialog.this.tfSeparator.getText()));
                String key = "";
                for (Map.Entry pairs : GlossaryDialog.this.mapSeparator.entrySet()) {
                    if (!pairs.getValue().equals(GlossaryDialog.this.cbSeparator.getSelectedItem().toString())) continue;
                    key = (String)pairs.getKey();
                    break;
                }
                if (Glossary.SPACE.equalsIgnoreCase(key)) {
                    GlossaryDialog.this.tfSeparator.setEnabled(false);
                } else {
                    GlossaryDialog.this.tfSeparator.setEnabled(true);
                }
            }
        });
        tip = Messages.getString("GlossaryDialog.HTMLTip12.0") + "\n" + Messages.getString("GlossaryDialog.HTMLTip12.1");
        this.cbSeparator.setToolTipText(tip);
        this.cbSeparator.setPreferredSize(new Dimension(100, (int)this.cbSeparator.getPreferredSize().getHeight()));
        this.bnSeparator.setEnabled(this.isDifferentSeparator());
        this.tfSeparator.setPreferredSize(charDim);
        pnOptions.add(this.tfSeparator);
        pnOptions.add(this.bnSeparator);
        this.tfSeparator.setText(String.valueOf(this.glossary.getMultiWordSeparator()));
        this.tfSeparator.setToolTipText(tip);
        glossPanel.setBorder(titledBorder1);
        glossPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 82));
        glossPanel.setLayout(gridBagLayout1);
        jLabel1.setText(Messages.getString("GlossaryDialog.Name"));
        jLabel2.setText(Messages.getString("GlossaryDialog.Description"));
        wordsPanel.setLayout(borderLayout2);
        wordsPanel.setBorder(titledBorder2);
        tablePanel.setBorder(BorderFactory.createEtchedBorder());
        lbFilter.setText(Messages.getString("GlossaryDialog.Filter"));
        lbDefault.setText(Messages.getString("GlossaryDialog.DefaultType"));
        jpanel.add((Component)editorPanel, "Center");
        editorPanel.add((Component)glossPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 11, 0, 11), 0, -1));
        glossPanel.add((Component)jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 11, 0, 10), 29, 7));
        glossPanel.add((Component)this.tfName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 11, 0, 274), 176, 3));
        glossPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 11, 10, 0), 13, 4));
        glossPanel.add((Component)this.tfDescription, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 11, 10, 11), 428, 1));
        glossPanel.add((Component)pnOptions, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(8, 11, 10, 11), 428, 1));
        editorPanel.add((Component)wordsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(6, 11, 16, 11), 309, 197));
        JPanel jpanel2 = new JPanel(new FlowLayout(0));
        wordsPanel.add((Component)jpanel2, "North");
        jpanel2.add(addButton);
        jpanel2.add(this.removeButton);
        jpanel2.add(new JPanel());
        jpanel2.add(lbFilter);
        jpanel2.add(this.cbFilter);
        this.bnSeparator.setEnabled(this.isDifferentSeparator());
        wordsPanel.add((Component)tablePanel, "Center");
        this.bnSeparator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlossaryDialog.this.replaceSeparators();
                GlossaryDialog.this.bnSeparator.setEnabled(false);
            }
        });
        this.bnSeparator.setToolTipText(Messages.getString("GlossaryDialog.ApplyNewSeparatorForMultiwordTerms"));
        this.wordsTable = new WordJTable(new WordsModel());
        this.tuneWordsTable(this.wordsTable);
        this.wordsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = GlossaryDialog.this.wordsTable.getSelectedRow();
                if (row > -1) {
                    GlossaryDialog.this.removeButton.setEnabled(true);
                }
            }
        });
        tablePanel.add(new JScrollPane(this.wordsTable));
        this.initProperties();
        String key = "";
        for (Map.Entry pairs : this.mapSeparator.entrySet()) {
            if (!pairs.getValue().equals(this.cbSeparator.getSelectedItem().toString())) continue;
            key = (String)pairs.getKey();
            break;
        }
        if (Glossary.SPACE.equalsIgnoreCase(key)) {
            this.tfSeparator.setEnabled(false);
        } else {
            this.tfSeparator.setEnabled(true);
        }
        return jpanel;
    }

    private boolean isDifferentSeparator() {
        String oldType = this.glossary.getSeparatorType();
        char oldSep = this.glossary.getMultiWordSeparator();
        String key = "";
        for (Map.Entry pairs : this.mapSeparator.entrySet()) {
            if (!pairs.getValue().equals(this.cbSeparator.getSelectedItem().toString())) continue;
            key = (String)pairs.getKey();
            break;
        }
        String newsep = this.tfSeparator.getText();
        char newSep = '\u0000';
        if (!"".equals(newsep)) {
            newSep = newsep.charAt(0);
        }
        return !oldType.equals(key) || oldType.equals(Glossary.CHARACTER) && oldSep != newSep;
    }

    private void replaceSeparators() {
        if (this.isDifferentSeparator()) {
            char oldSep = this.glossary.getMW_SeparatorChar();
            String key = "";
            for (Map.Entry pairs : this.mapSeparator.entrySet()) {
                if (!pairs.getValue().equals(this.cbSeparator.getSelectedItem().toString())) continue;
                key = (String)pairs.getKey();
                break;
            }
            this.glossary.setSeparatorType(key);
            String newsep = this.tfSeparator.getText();
            char newSep = '\u0000';
            if (!"".equals(newsep)) {
                newSep = newsep.charAt(0);
            }
            this.glossary.setMultiWordSeparator(newSep);
            newSep = this.glossary.getMW_SeparatorChar();
            this.glossary.replaceSeparator(oldSep, newSep);
            this.validateMultiwords(newSep);
            this.wordsTable.updateUI();
        }
    }

    private void initProperties() {
        this.chbCaseSensitive.setSelected(this.glossary.isCaseSensitive());
        this.chbUniqueAbbreviations.setSelected(this.glossary.isUniqueAbbreviations());
        this.chbIncomplete.setSelected(this.glossary.isIncompleteModifiers());
        this.cbSeparator.setSelectedItem(this.mapSeparator.get(this.glossary.getSeparatorType()));
        this.tfSeparator.setText(String.valueOf(this.glossary.getMultiWordSeparator()));
        this.tfSeparator.addCaretListener(new SeparatorUpdate());
        this.tfName.addCaretListener(new SeparatorUpdate());
    }

    private void tuneWordsTable(JTable wtable) {
        wtable.getTableHeader().setReorderingAllowed(false);
        wtable.setCellSelectionEnabled(true);
        TableColumn column = wtable.getColumnModel().getColumn(0);
        column.setCellEditor(new NameCellEditor(new JTextField()));
        column.setPreferredWidth(140);
        column.setMinWidth(40);
        column = wtable.getColumnModel().getColumn(1);
        column.setCellEditor(new TextCellEditor(new JTextField()));
        column.setPreferredWidth(110);
        column.setMinWidth(40);
        column = wtable.getColumnModel().getColumn(2);
        column.setCellEditor(new TextCellEditor(new JTextField()));
        column.setPreferredWidth(80);
        column.setMinWidth(40);
        column = wtable.getColumnModel().getColumn(3);
        column.setCellEditor(new TextCellEditor(new JTextField()));
        column.setPreferredWidth(140);
        column.setMinWidth(40);
        column = wtable.getColumnModel().getColumn(4);
        column.setPreferredWidth(60);
        column.setMinWidth(60);
        column = wtable.getColumnModel().getColumn(5);
        column.setPreferredWidth(40);
        column.setMinWidth(40);
        column = wtable.getColumnModel().getColumn(6);
        column.setPreferredWidth(70);
        column.setMinWidth(70);
        column = wtable.getColumnModel().getColumn(7);
        column.setPreferredWidth(70);
        column.setMinWidth(70);
        column = wtable.getColumnModel().getColumn(8);
        column.setCellEditor(new DescriptionCellEditor());
        column.setPreferredWidth(200);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    @Override
    protected String getHelpIndex() {
        return "GLOSSARY_EDITOR";
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    private void filterWords() {
        if (this.stopEditing()) {
            String key = "";
            for (Map.Entry pairs : this.mapFilter.entrySet()) {
                if (!pairs.getValue().equals(this.cbFilter.getSelectedItem().toString())) continue;
                key = (String)pairs.getKey();
                break;
            }
            this.selectedWords.clear();
            if (ALL_L.equals(key)) {
                this.selectedWords.addAll(this.allWords);
            } else {
                this.addToList(key, this.selectedWords);
            }
            Collections.sort(this.selectedWords, COMPARATOR);
            this.wordsTable.updateUI();
        }
    }

    private void addToList(String type, List selList) {
        for (GlossaryWord word : this.allWords) {
            if (type.equals("Prime Word") && word.isPrimaryWord()) {
                selList.add(word);
                continue;
            }
            if (type.equals("Class Word") && word.isClassWord()) {
                selList.add(word);
                continue;
            }
            if (type.equals("Modifier") && word.isModifier()) {
                selList.add(word);
                continue;
            }
            if (type.equals("Qualifier") && word.isQualifier()) {
                selList.add(word);
                continue;
            }
            if (!type.equals(UNCLASSIFIED_L) || word.isPrimaryWord() || word.isClassWord() || word.isQualifier() || word.isModifier()) continue;
            selList.add(word);
        }
    }

    public void importGlossary(ApplicationView appView) {
        try {
            File file;
            URLFilter cwdFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return url.getFile().toLowerCase().endsWith(".glossary") || file.isDirectory();
                }

                public String toString() {
                    return CWD_GLOSS_DESC;
                }
            };
            URLFilter erwinCSVFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".csv") || file.isDirectory();
                }

                public String toString() {
                    return DM_CSV_GLOSS_DESC;
                }
            };
            URLFilter erwinTXTFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".txt") || file.isDirectory();
                }

                public String toString() {
                    return ERWIN_TXT_GLOSS_DESC;
                }
            };
            URLFilter xlsFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".xls") || file.getName().toLowerCase().endsWith(".xlsx") || file.isDirectory();
                }

                public String toString() {
                    return EXCEL_GLOSS_DESC;
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(erwinCSVFilter);
            fileChooser.setURLFilter(erwinTXTFilter);
            fileChooser.setURLFilter(xlsFilter);
            fileChooser.setURLFilter(cwdFilter);
            fileChooser.setPathContext("dataModeler_Glossary");
            ApplicationView.waitLoadFilesThreadToComplete();
            if (lastImpFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastImpFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultImportPath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("GlossaryDialog.SelectTypeAndGlossaryFile"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                LogReport lr;
                String error;
                lastImpFolder = file.getParentFile();
                URLFilter filter = fileChooser.getSelectedFilter();
                Glossary newGlossary = null;
                String description = filter.toString();
                if (description.equals(ERWIN_TXT_GLOSS_DESC) || description.equals(DM_CSV_GLOSS_DESC)) {
                    newGlossary = new Glossary(new File(" "));
                    error = newGlossary.importERwinGlossaryFile(file);
                    this.selectedWords.clear();
                    this.selectedWords.addAll(this.allWords);
                    Collections.sort(this.selectedWords, COMPARATOR);
                    this.wordsTable.updateUI();
                    if (!"".equalsIgnoreCase(error)) {
                        lr = new LogReport(appView);
                        lr.setName(Messages.getString("GlossaryDialog.Errors"));
                        lr.setLog(error);
                        lr.showModalDialog(new Dimension(750, 550));
                    }
                } else if (description.equals(CWD_GLOSS_DESC)) {
                    newGlossary = new Glossary(new File(" "));
                    error = newGlossary.importGlossary(file, appView);
                    this.selectedWords.clear();
                    this.selectedWords.addAll(this.allWords);
                    Collections.sort(this.selectedWords, COMPARATOR);
                    this.wordsTable.updateUI();
                    if (!"".equalsIgnoreCase(error)) {
                        lr = new LogReport(appView);
                        lr.setName(Messages.getString("GlossaryDialog.Errors"));
                        lr.setLog(error);
                        lr.showModalDialog(new Dimension(750, 550));
                    }
                } else if (description.equals(EXCEL_GLOSS_DESC)) {
                    newGlossary = new Glossary(new File(" "));
                    error = newGlossary.ImportExcelFile(file);
                    this.selectedWords.clear();
                    this.selectedWords.addAll(this.allWords);
                    Collections.sort(this.selectedWords, COMPARATOR);
                    this.wordsTable.updateUI();
                    if (!"".equalsIgnoreCase(error)) {
                        lr = new LogReport(appView);
                        lr.setName(Messages.getString("GlossaryDialog.Errors"));
                        lr.setLog(error);
                        lr.showModalDialog(new Dimension(750, 550));
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("GlossaryDialog.ImportIsNotImplemented")}, Messages.getString("GlossaryDialog.ImportError"), 2);
                }
                if (newGlossary != null) {
                    int count = this.allWords.size();
                    ImportGlossaryDialog dialog = new ImportGlossaryDialog(this.getApplicationView(), newGlossary, this.glossary);
                    dialog.setModal(true);
                    dialog.show();
                    if (count != this.allWords.size()) {
                        this.cbFilter.setSelectedItem(this.mapFilter.get(ALL_L));
                        this.filterWords();
                        this.wordsTable.updateUI();
                    }
                    MessageDialogs.showMessage(MessageFormat.format(Messages.getString("GlossaryDialog.GlossaryImportedOK"), file));
                }
            }
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("GlossaryDialog.UnexpectedError"), t.getMessage()}, Messages.getString("GlossaryDialog.ImportError"), 0);
        }
    }

    private void validateMultiwords(char separator) {
        String error;
        if (' ' != separator && !"".equals(error = this.glossary.validateMultiWordsForSpaces(separator))) {
            LogReport lr = new LogReport(this.appView);
            lr.setName(Messages.getString("GlossaryDialog.WordsContainingSPACECharacter"));
            lr.setLog(error);
            lr.showModalDialog(new Dimension(750, 550));
            int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), new Object[]{MessageFormat.format(Messages.getString("GlossaryDialog.WouldYouLikeSPACEToBeReplacedWith"), Character.valueOf(separator))}, Messages.getString("GlossaryDialog.MultiwordsValidationError"), 0);
            if (result == 0) {
                this.glossary.replaceSeparator(' ', separator);
            }
        }
    }

    private void checkAndShowWordsWithNoneUniqueAbbreviations() {
        if (this.chbUniqueAbbreviations.isSelected()) {
            List list = this.glossary.getWordsWithNoneUniqueAbbreviations();
            StringBuffer sb = new StringBuffer();
            Iterator it = list.iterator();
            boolean first = true;
            while (it.hasNext()) {
                GlossaryWord word = (GlossaryWord)it.next();
                if ("".equals(word.getAbbreviation().trim())) {
                    if (first) {
                        first = false;
                        if (sb.length() > 0) {
                            sb.append("\n\n\n");
                        }
                        sb.append(Messages.getString("GlossaryDialog.WordsWithoutAbbreviation"));
                    }
                    sb.append(word.getName()).append("\n");
                    continue;
                }
                sb.append(this.getStringWithLingth(word.getName(), 40)).append("   ").append(this.getStringWithLingth(word.getAbbreviation(), 15)).append("   ").append(this.getStringWithLingth(word.getAltAbbrevation(), 15)).append("\n");
            }
            if (sb.length() > 0) {
                LogReport lr = new LogReport(this.appView);
                lr.setName(Messages.getString("GlossaryDialog.WordsWithNoneUniqueAbbreviation"));
                lr.setLog(sb.toString());
                lr.showModalDialog(new Dimension(750, 550));
            }
        }
    }

    private String getStringWithLingth(String input, int length) {
        int strl = input.length();
        if (strl > length) {
            return input.substring(0, length);
        }
        String spaces = "";
        for (int i = strl; i < length; ++i) {
            spaces = spaces + ' ';
        }
        return input + spaces;
    }

    class SeparatorUpdate
    implements CaretListener {
        SeparatorUpdate() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            GlossaryDialog.this.bnSeparator.setEnabled(GlossaryDialog.this.isDifferentSeparator() && !"".equalsIgnoreCase(GlossaryDialog.this.tfSeparator.getText()));
        }
    }

    class DescriptionCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;
        JButton temp = new JButton();
        StringEditor datatypeDialog;

        DescriptionCellEditor() {
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.datatypeDialog = new StringEditor(GlossaryDialog.this.appView, this.button.getText(), Messages.getString("GlossaryDialog.ShortDescription"));
            this.datatypeDialog.setModal(true);
            this.datatypeDialog.show();
            if (!this.datatypeDialog.cancel) {
                this.button.setText(this.datatypeDialog.getText());
            }
            this.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            String text = (String)value;
            this.button.setText(text);
            return this.button;
        }
    }

    class WordJTable
    extends JTable {
        boolean badName;

        public WordJTable(TableModel dm) {
            super(dm);
            this.badName = false;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!this.badName) {
                super.valueChanged(e);
            } else {
                int sel;
                int row = GlossaryDialog.this.wordsTable.getEditingRow();
                if (row != (sel = GlossaryDialog.this.wordsTable.getSelectedRow())) {
                    GlossaryDialog.this.wordsTable.clearSelection();
                    GlossaryDialog.this.wordsTable.setRowSelectionInterval(row, row);
                }
            }
        }
    }

    private class RemoveWordAction
    implements ActionListener {
        private RemoveWordAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GlossaryDialog.this.stopEditing()) {
                int[] rows = GlossaryDialog.this.wordsTable.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    GlossaryWord word = (GlossaryWord)GlossaryDialog.this.selectedWords.get(rows[i]);
                    GlossaryDialog.this.glossary.removeWord(word);
                    GlossaryDialog.this.selectedWords.remove(word);
                }
                GlossaryDialog.this.wordsTable.updateUI();
                GlossaryDialog.this.removeButton.setEnabled(false);
                if (GlossaryDialog.this.selectedWords.size() > 0) {
                    GlossaryDialog.this.wordsTable.removeRowSelectionInterval(0, GlossaryDialog.this.selectedWords.size() - 1);
                }
            }
        }
    }

    private class AddWordAction
    implements ActionListener {
        private AddWordAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GlossaryDialog.this.stopEditing()) {
                GlossaryWord word = GlossaryDialog.this.glossary.createGlossaryWordWithID();
                GlossaryDialog.this.selectedWords.add(word);
                GlossaryDialog.this.wordsTable.updateUI();
                Rectangle rect = GlossaryDialog.this.wordsTable.getCellRect(GlossaryDialog.this.selectedWords.size() - 1, 0, true);
                GlossaryDialog.this.wordsTable.scrollRectToVisible(rect);
                if (GlossaryDialog.this.wordsTable.getSelectedRow() > -1) {
                    GlossaryDialog.this.removeButton.setEnabled(true);
                }
                int row = GlossaryDialog.this.selectedWords.size() - 1;
                boolean success = GlossaryDialog.this.wordsTable.editCellAt(row, 0);
                if (success) {
                    GlossaryDialog.this.wordsTable.changeSelection(row, 0, false, false);
                    GlossaryDialog.this.wordsTable.getEditorComponent().requestFocusInWindow();
                }
            }
        }
    }

    class NameCellEditor
    extends DefaultCellEditor {
        JTextField textField;
        int row;

        public NameCellEditor(JTextField textField) {
            super(textField);
            this.row = -1;
            this.textField = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.textField.setText((String)value);
            this.row = row;
            this.textField.setBorder(null);
            return this.textField;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.row > -1 && this.row < GlossaryDialog.this.selectedWords.size()) {
                String name = this.textField.getText();
                GlossaryWord edword = (GlossaryWord)GlossaryDialog.this.selectedWords.get(this.row);
                GlossaryWord word = GlossaryDialog.this.glossary.getDifferentWordByName(name, edword);
                if (word != null && word != edword) {
                    GlossaryDialog.this.badWordName = true;
                    ((GlossaryDialog)GlossaryDialog.this).wordsTable.badName = true;
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this.textField), Messages.getString("GlossaryDialog.ThereIsWordWithTheSameName"), Messages.getString("GlossaryDialog.DuplicatedName"), 0);
                    return false;
                }
            }
            GlossaryDialog.this.badWordName = false;
            ((GlossaryDialog)GlossaryDialog.this).wordsTable.badName = false;
            return super.stopCellEditing();
        }
    }

    class TextCellEditor
    extends DefaultCellEditor {
        JTextField textField;

        public TextCellEditor(JTextField textField) {
            super(textField);
            this.textField = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.textField.setText((String)value);
            this.textField.setBorder(null);
            return this.textField;
        }
    }

    public class WordsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public int getRowCount() {
            return GlossaryDialog.this.selectedWords.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("GlossaryDialog.Name");
            }
            if (column == 1) {
                return Messages.getString("GlossaryDialog.Plural");
            }
            if (column == 2) {
                return Messages.getString("GlossaryDialog.Abbreviation");
            }
            if (column == 3) {
                return Messages.getString("GlossaryDialog.AltAbbreviation");
            }
            if (column == 4) {
                return Messages.getString("GlossaryDialog.Primary");
            }
            if (column == 5) {
                return Messages.getString("GlossaryDialog.Class");
            }
            if (column == 6) {
                return Messages.getString("GlossaryDialog.Modifier");
            }
            if (column == 7) {
                return Messages.getString("GlossaryDialog.Qualifier");
            }
            if (column == 8) {
                return Messages.getString("GlossaryDialog.ShortDescription");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return !GlossaryDialog.this.badWordName;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            GlossaryWord word = (GlossaryWord)GlossaryDialog.this.selectedWords.get(row);
            if (col == 0) {
                return word.getName();
            }
            if (col == 1) {
                return word.getPlural();
            }
            if (col == 2) {
                return word.getAbbreviation();
            }
            if (col == 3) {
                return word.getAltAbbrevation();
            }
            if (col == 4) {
                return word.isPrimaryWord();
            }
            if (col == 5) {
                return word.isClassWord();
            }
            if (col == 6) {
                return word.isModifier();
            }
            if (col == 7) {
                return word.isQualifier();
            }
            if (col == 8) {
                return word.getShortDescription();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            GlossaryWord word = (GlossaryWord)GlossaryDialog.this.selectedWords.get(row);
            String value = String.valueOf(aValue);
            if (col == 0) {
                word.setName(value);
            } else if (col == 1) {
                word.setPlural(value);
            } else if (col == 2) {
                word.setAbbreviation(value);
            } else if (col == 3) {
                word.setAltAbbrevation(value);
            } else if (col == 4) {
                if (aValue instanceof Boolean) {
                    word.setPrimaryWord((Boolean)aValue);
                }
            } else if (col == 5) {
                if (aValue instanceof Boolean) {
                    word.setClassWord((Boolean)aValue);
                }
            } else if (col == 6) {
                if (aValue instanceof Boolean) {
                    word.setModifier((Boolean)aValue);
                }
            } else if (col == 7) {
                if (aValue instanceof Boolean) {
                    word.setQualifier((Boolean)aValue);
                }
            } else if (col == 8) {
                word.setShortDescription(value);
            }
        }
    }
}

