/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;

public class HTMLReportSingleFile {
    private StringBuffer buffer = new StringBuffer();
    private List objects;
    private File htmlFile;
    private ByteArrayOutputStream htmlStream;
    private String SVGDiagrams;
    private Settings settings;
    private List diagramsNamesList;
    private boolean isRepositoryReport;
    private static final Logger LOGGER = new Logger(HTMLReportSingleFile.class);

    public HTMLReportSingleFile(File htmlFile, ByteArrayOutputStream htmlStream, List objects, String SVGDiagrams, Settings settings, List diagramsNamesList, boolean isRepositoryReport) {
        this.objects = objects;
        this.htmlFile = htmlFile;
        this.htmlStream = htmlStream;
        this.SVGDiagrams = SVGDiagrams;
        this.settings = settings;
        this.diagramsNamesList = diagramsNamesList;
        this.isRepositoryReport = isRepositoryReport;
    }

    public void createReport() {
        this.createHEAD();
        this.createBODY();
        if (this.htmlFile != null) {
            this.writeToFile();
        }
    }

    private void createHEAD() {
        this.buffer.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        this.buffer.append("\n");
        this.buffer.append("\t").append("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        this.buffer.append("\n");
        this.buffer.append("\t\t").append("<link rel=\"stylesheet\" type=\"text/css\" href=\"./css/osddm_main.css\">");
        this.buffer.append("\n");
        this.buffer.append("\t\t").append("<link rel=\"stylesheet\" type=\"text/css\" href=\"./css/osddm_vs.css\">");
        this.buffer.append("\n");
        this.buffer.append("\t\t").append("<link rel=\"stylesheet\" type=\"text/css\" href=\"./css/osddm_toc_tree.css\">");
        this.buffer.append("\n");
        this.buffer.append("\t\t").append("<script src=\"./js/toc_filter.js\"></script>");
        this.buffer.append("\n");
        this.buffer.append("\t").append("</head>");
    }

    private void createBODY() {
        this.buffer.append("\n");
        this.buffer.append("\t").append("<body>");
        this.buffer.append("\n");
        this.buffer.append("\t\t").append("<div class=\"flex\">");
        this.buffer.append("\n");
        if (this.objects != null && this.objects.size() > 1) {
            this.buffer.append("\t\t\t").append("<div class=\"toc\" id=\"toc_list\">");
            this.buffer.append("\n");
            this.buffer.append("\t\t\t\t").append("<table id=\"toc_table\" width=\"100%\" style=\"empty-cells:show; font-family:Tahoma; font-size:small; text-align:left; vertical-align:top; word-wrap:break-word;\">");
            this.buffer.append("\n");
            this.buffer.append("\t\t\t\t\t").append("<tr><td style=\"font-style:italic; font-weight:bold;\"><input type=\"text\" style=\"width: 180px; margin-top: 5px;\" onkeyup=\"$d_Find('toc_list',this.value,'a')\"/></td></tr>");
            this.buffer.append("\n");
            this.buffer.append("\t\t\t\t\t").append("<tr><td>&nbsp;</td></tr>");
            this.buffer.append("\n");
            this.buffer.append("\t\t\t\t").append("</table>");
            this.buffer.append("\n");
            this.buffer.append("\t\t\t\t").append("<div class=\"t_item\">");
            this.buffer.append("\n");
            if (this.settings.isGroupBySchemaNameInReports()) {
                Object o;
                ArrayList noSchemaObjects;
                List oList;
                HashMap schemasMap = new HashMap();
                schemasMap.put("NoSchemaObjects", new ArrayList());
                if (this.objects.get(0) instanceof String) {
                    for (String objLongName : this.objects) {
                        if (objLongName.contains(".")) {
                            String schemaName = objLongName.substring(0, objLongName.indexOf("."));
                            final String objectName = objLongName.substring(objLongName.indexOf(".") + 1, objLongName.length());
                            oList = (List)schemasMap.get(schemaName);
                            if (oList != null) {
                                oList.add(objectName);
                                continue;
                            }
                            schemasMap.put(schemaName, new ArrayList(){
                                {
                                    this.add(objectName);
                                }
                            });
                            continue;
                        }
                        ((List)schemasMap.get("NoSchemaObjects")).add(objLongName);
                    }
                    if (schemasMap.size() > 0) {
                        this.buffer.append("\t\t\t\t<div>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t<ol class=\"tree\">");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t<li>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t\t<label for=\"objects\">Objects</label>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"objects\"/>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t\t<ol>");
                        noSchemaObjects = new ArrayList();
                        for (Map.Entry pair : schemasMap.entrySet()) {
                            oList = (List)pair.getValue();
                            o = pair.getKey();
                            if (!o.equals("NoSchemaObjects")) {
                                String schemaName = (String)o;
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t<li>");
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t<label for=\"" + schemaName + "\">" + schemaName + "</label>");
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"" + schemaName + "\"/>");
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t<ol>");
                                for (String objName : oList) {
                                    this.buffer.append("\n");
                                    this.buffer.append("\t\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"" + this.htmlFile.getName() + "#" + schemaName + "." + objName + "\" target=\"_self\">" + objName + "</a></li>");
                                }
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t</ol>");
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t</li>");
                                continue;
                            }
                            noSchemaObjects.addAll(oList);
                        }
                        for (String objName : noSchemaObjects) {
                            this.buffer.append("\n");
                            this.buffer.append("\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"" + this.htmlFile.getName() + "#" + objName + "\" target=\"_self\">" + objName + "</a></li>");
                        }
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t\t</ol>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t</li>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t</ol>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t</div>");
                        this.buffer.append("\n");
                    } else {
                        for (String objName : this.objects) {
                            this.buffer.append("\n");
                            this.buffer.append("\t\t\t\t").append("<div><a href=\"" + this.htmlFile.getName() + "#" + objName + "\" target=\"_self\">" + objName + "</a></div>");
                        }
                    }
                } else {
                    for (DesignObject dObj : this.objects) {
                        if (dObj instanceof Table || dObj instanceof TableView) {
                            final ContainerObject co = (ContainerObject)dObj;
                            SchemaObject so = co.getSchemaObject();
                            if (so != null) {
                                oList = (List)schemasMap.get(so);
                                if (oList != null) {
                                    oList.add(co);
                                    continue;
                                }
                                schemasMap.put(so, new ArrayList(){
                                    {
                                        this.add(co);
                                    }
                                });
                                continue;
                            }
                            ((List)schemasMap.get("NoSchemaObjects")).add(co);
                            continue;
                        }
                        ((List)schemasMap.get("NoSchemaObjects")).add(dObj);
                    }
                    if (this.settings.isGroupBySchemaNameInReports() && schemasMap.size() > 0) {
                        this.buffer.append("\t\t\t\t<div>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t<ol class=\"tree\">");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t<li>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t\t<label for=\"objects\">Objects</label>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"objects\"/>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t\t<ol>");
                        noSchemaObjects = new ArrayList();
                        for (Map.Entry pair : schemasMap.entrySet()) {
                            oList = (List)pair.getValue();
                            o = pair.getKey();
                            if (o instanceof SchemaObject) {
                                SchemaObject so = (SchemaObject)o;
                                String schemaName = so.getName();
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t<li>");
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t<label for=\"" + schemaName + "\">" + schemaName + "</label>");
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"" + schemaName + "\"/>");
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t<ol>");
                                for (ContainerObject co : oList) {
                                    this.buffer.append("\n");
                                    this.buffer.append("\t\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"#" + co.getLongName() + "\" target=\"_self\">" + co.getName() + "</a></li>");
                                }
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t</ol>");
                                this.buffer.append("\n");
                                this.buffer.append("\t\t\t\t\t\t\t\t</li>");
                                continue;
                            }
                            noSchemaObjects.addAll(oList);
                        }
                        for (DesignObject dObj : noSchemaObjects) {
                            this.buffer.append("\n");
                            this.buffer.append("\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"#" + dObj.getLongName() + "\" target=\"_self\">" + dObj.getName() + "</a></li>");
                        }
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t\t</ol>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t\t</li>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t\t</ol>");
                        this.buffer.append("\n");
                        this.buffer.append("\t\t\t\t</div>");
                        this.buffer.append("\n");
                    }
                }
            } else if (this.objects.get(0) instanceof String) {
                for (String objName : this.objects) {
                    this.buffer.append("\n");
                    this.buffer.append("\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"" + this.htmlFile.getName() + "#" + objName + "\" target=\"_self\">" + objName + "</a></li>");
                }
            } else {
                for (DesignObject dObj : this.objects) {
                    this.buffer.append("\n");
                    this.buffer.append("\t\t\t\t").append("<div><a href=\"#" + dObj.getLongName() + "\" target=\"_self\">" + dObj.getLongName() + "</a></div>");
                }
            }
            if (this.settings.isEmbedDiagramsInReports() && this.diagramsNamesList.size() > 0) {
                this.buffer.append("\n");
                this.buffer.append("\t\t\t\t<div>");
                this.buffer.append("\n");
                this.buffer.append("\t\t\t\t\t<ol class=\"tree\">");
                this.buffer.append("\n");
                this.buffer.append("\t\t\t\t\t\t<li>");
                this.buffer.append("\n");
                this.buffer.append("\t\t\t\t\t\t\t<label for=\"diagrams\">Diagrams</label>");
                this.buffer.append("\n");
                this.buffer.append("\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"diagrams\"/>");
                this.buffer.append("\n");
                this.buffer.append("\t\t\t\t\t\t\t<ol>");
                for (String diagramName : this.diagramsNamesList) {
                    if (this.isRepositoryReport) {
                        diagramName = diagramName.substring(diagramName.indexOf("/") + 1, diagramName.lastIndexOf("."));
                    }
                    this.buffer.append("\n");
                    this.buffer.append("\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"#" + diagramName + "\" target=\"_self\">" + diagramName + "</a></li>");
                }
                this.buffer.append("\n");
                this.buffer.append("\t\t\t\t\t\t\t</ol>");
                this.buffer.append("\n");
                this.buffer.append("\t\t\t\t\t\t</li>");
                this.buffer.append("\n");
                this.buffer.append("\t\t\t\t\t</ol>");
                this.buffer.append("\n");
                this.buffer.append("\t\t\t\t</div>");
                this.buffer.append("\n");
            }
            this.buffer.append("\t\t\t\t").append("</div>");
            this.buffer.append("\n");
            this.buffer.append("\t\t\t").append("</div>");
            this.buffer.append("\n");
        }
        this.buffer.append("\t\t\t").append("<div class=\"details\">");
        this.buffer.append("\n");
        this.buffer.append(this.getHTMLContents());
        this.buffer.append("\n");
        if (this.settings.isEmbedDiagramsInReports()) {
            if (this.isRepositoryReport) {
                if (this.diagramsNamesList.size() > 0) {
                    for (String diagramName : this.diagramsNamesList) {
                        this.buffer.append("\n");
                        String dName = diagramName.substring(diagramName.indexOf("/") + 1, diagramName.lastIndexOf("."));
                        this.buffer.append("<p><a name=" + dName + ">" + dName + "</a></p>");
                        this.buffer.append("\n");
                        this.buffer.append("<object data=\"" + diagramName + "\" type=\"application/pdf\" width=\"900\" height=\"500\">");
                        this.buffer.append("alt : <a href=\"" + diagramName + "\">" + diagramName + "</a>");
                        this.buffer.append("</object>");
                    }
                }
            } else {
                this.buffer.append(this.SVGDiagrams);
                this.buffer.append("\n");
            }
        }
        this.buffer.append("\t\t\t").append("</div>");
        this.buffer.append("\n");
        this.buffer.append("\t\t").append("</div>");
        this.buffer.append("\n");
        this.buffer.append("\t").append("</body>");
        this.buffer.append("\n");
        this.buffer.append("</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getHTMLContents() {
        if (this.htmlFile != null) {
            StringBuffer contents = new StringBuffer((int)this.htmlFile.length());
            try (Scanner sc = null;){
                sc = new Scanner(this.htmlFile, "UTF-8");
                String lineSeparator = System.getProperty("line.separator");
                while (sc.hasNextLine()) {
                    if (this.isRepositoryReport && this.settings.isEmbedDiagramsInReports()) {
                        String line = sc.nextLine().toString();
                        if (this.diagramsNamesList.size() > 0) {
                            for (String diagramName : this.diagramsNamesList) {
                                String dName = diagramName.substring(diagramName.indexOf("/") + 1, diagramName.lastIndexOf("."));
                                line = line.replaceAll(diagramName, this.htmlFile.getName() + "#" + dName);
                            }
                        }
                        contents.append(line + lineSeparator);
                        continue;
                    }
                    contents.append(sc.nextLine() + lineSeparator);
                }
                sc.close();
                StringBuffer stringBuffer = contents;
                return stringBuffer;
            }
        }
        StringBuffer contents = new StringBuffer();
        try {
            contents.append(this.htmlStream.toByteArray());
            return contents;
        }
        catch (Exception e) {
            LOGGER.error("HTMLSingleFileReport.getHTMLContents(): ", e);
            return new StringBuffer();
        }
    }

    private void writeToFile() {
        OutputStreamWriter osw = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.htmlFile);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(this.buffer.toString());
            osw.close();
        }
        catch (Exception e) {
            LOGGER.error("HTMLSingleFileReport. Unable to write to file: ", e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    LOGGER.error("HTMLSingleFileReport. Unable to write to file: ", e);
                }
            }
        }
    }

    public StringBuffer getContents() {
        return this.buffer;
    }
}

