/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.PDFReportEditor;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.util.logging.Logger;

public class RenderPDFReport
implements Runnable {
    private String vmOptions;
    private String xsltFile;
    private String reportsPath;
    private String reportFileName;
    private String rawXMLFileName;
    private String saxonPath;
    private boolean embedDiagrams;
    private List objectsList;
    private List diagramNamesList;
    private List schemaNamesList;
    private ApplicationView appView;
    private boolean groupBySchemaName;
    private static final Logger LOGGER = new Logger(RenderPDFReport.class);

    public RenderPDFReport(ApplicationView appView, HashMap extraParams) {
        this.appView = appView;
        this.vmOptions = (String)extraParams.get("vm_options");
        this.xsltFile = (String)extraParams.get("xsltFile");
        this.reportFileName = (String)extraParams.get("reportFileName");
        this.saxonPath = appView.getSettings().getDefaultSaxonPath();
        this.reportsPath = ReportUtils.getReportsPath(appView);
        this.embedDiagrams = appView.getSettings().isEmbedDiagramsInReports();
        this.objectsList = (List)extraParams.get("objectsList");
        this.diagramNamesList = (List)extraParams.get("diagramsList");
        this.schemaNamesList = (List)extraParams.get("schemaNamesList");
        this.groupBySchemaName = (Boolean)extraParams.get("groupBySchemaName");
        boolean isLD = (Boolean)extraParams.get("loaded_designs");
        this.rawXMLFileName = isLD ? "report_data.xml" : "report_data_rs.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int exitValue;
        ProcessBuilder pb;
        InputStreamReader esr;
        String javaPath = new File(System.getProperty("java.home"), "/bin/java").getAbsolutePath();
        Process process = null;
        ArrayList<String> ll = new ArrayList<String>();
        boolean createPDF = false;
        if (this.saxonPath != null && !this.saxonPath.equals("")) {
            LOGGER.info("Using XSLT 2.0");
            esr = null;
            BufferedReader br = null;
            try {
                String line;
                boolean addMsg = false;
                ll.add(javaPath);
                ll.add("-jar");
                ll.add(this.vmOptions.trim());
                ll.add(new File(this.saxonPath).getAbsolutePath());
                ll.add("-s:" + new File(this.reportsPath, this.rawXMLFileName).getAbsolutePath());
                ll.add("-xsl:" + this.xsltFile);
                ll.add("-o:" + new File(this.reportsPath, "report_data.fo").getAbsolutePath());
                pb = new ProcessBuilder(ll);
                process = pb.start();
                esr = new InputStreamReader(process.getErrorStream());
                br = new BufferedReader(esr);
                while ((line = br.readLine()) != null) {
                    LOGGER.error("XSLT-FO file generation message: " + line);
                    addMsg = true;
                }
                esr.close();
                br.close();
                if (addMsg) {
                    LOGGER.error("PDF report generation FOP message: If the above line is something like 'Unable to access jarfile' that usually means that JVM parameter entered in JVM Options text box is not according to specifications.");
                }
                if ((exitValue = process.waitFor()) == 0) {
                    createPDF = true;
                } else {
                    ApplicationView.log(Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"));
                }
                ll.clear();
                ll.add(javaPath);
                ll.add("-jar");
                ll.add(this.vmOptions.trim());
                ll.add(new File(ApplicationView.basePath, "lib/fop.jar").getAbsolutePath());
                ll.add("-c");
                ll.add(new File(ApplicationView.basePath + "/reports/fop.xconf").getAbsolutePath());
                ll.add("-fo");
                ll.add(new File(this.reportsPath, "report_data.fo").getAbsolutePath());
                ll.add("-pdf");
                ll.add(new File(this.reportsPath, this.reportFileName).getAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.error("Exception during XSLT-FO file generation " + e);
            }
            catch (Exception e) {
                LOGGER.error("Exception during XSLT-FO file generation " + e);
            }
            finally {
                try {
                    if (process != null) {
                        process.getInputStream().close();
                        process.getOutputStream().close();
                        process.getErrorStream().close();
                    }
                    if (esr != null) {
                        esr.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Could not close Input/Output/Error streams of XSLT-FO file generation! " + e);
                }
            }
        } else {
            LOGGER.info("Using XSLT 1.0");
            ll.clear();
            ll.add(javaPath);
            ll.add("-jar");
            ll.add(this.vmOptions.trim());
            ll.add(new File(ApplicationView.basePath, "lib/fop.jar").getAbsolutePath());
            ll.add("-c");
            ll.add(new File(ApplicationView.basePath + "/reports/fop.xconf").getAbsolutePath());
            ll.add("-xml");
            ll.add(new File(this.reportsPath, this.rawXMLFileName).getAbsolutePath());
            ll.add("-xsl");
            ll.add(this.xsltFile);
            ll.add("-pdf");
            ll.add(new File(this.reportsPath, this.reportFileName).getAbsolutePath());
            createPDF = true;
        }
        if (createPDF) {
            esr = null;
            BufferedReader ebr = null;
            try {
                String eLine;
                boolean addMsg = false;
                pb = new ProcessBuilder(ll);
                process = pb.start();
                esr = new InputStreamReader(process.getErrorStream());
                ebr = new BufferedReader(esr);
                while ((eLine = ebr.readLine()) != null) {
                    LOGGER.error("PDF report generation FOP message: " + eLine);
                    addMsg = true;
                }
                esr.close();
                ebr.close();
                if (addMsg) {
                    LOGGER.error("PDF report generation FOP message: If the above line is something like 'Unable to access jarfile' that usually means that JVM parameter entered in JVM Options text box is not according to specifications.");
                }
                if ((exitValue = process.waitFor()) == 0) {
                    ArrayList<String> objectsNamesList = new ArrayList<String>();
                    Iterator it = this.objectsList.iterator();
                    String name = "";
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (obj instanceof ModelIDObject) {
                            ModelIDObject mObj = (ModelIDObject)obj;
                            if (this.groupBySchemaName) {
                                objectsNamesList.add(mObj.getName());
                                continue;
                            }
                            objectsNamesList.add(mObj.getLongName());
                            continue;
                        }
                        if (!(obj instanceof String)) continue;
                        objectsNamesList.add((String)obj);
                    }
                    PDFReportEditor editor = new PDFReportEditor(this.appView, this.reportFileName, objectsNamesList, this.diagramNamesList, this.schemaNamesList);
                    if (this.embedDiagrams) {
                        editor.createDiagramsHyperlinks();
                    } else {
                        editor.arrangeObjects(true, false, false);
                    }
                    boolean openReport = false;
                    if (Desktop.isDesktopSupported()) {
                        ApplicationView.log(MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV1"), this.reportFileName, this.reportsPath));
                        openReport = true;
                    } else {
                        ApplicationView.log(MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV2"), this.reportFileName, this.reportsPath));
                    }
                    if (openReport) {
                        Desktop.getDesktop().open(new File(this.reportsPath, this.reportFileName));
                    }
                } else {
                    ApplicationView.log(Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"));
                }
            }
            catch (IOException e) {
                LOGGER.error("Exception during PDF report generation. RenderPDFReport " + e);
            }
            catch (Exception e) {
                LOGGER.error("Exception during PDF report generation. RenderPDFReport " + e);
            }
            finally {
                try {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    process.getErrorStream().close();
                    if (esr != null) {
                        esr.close();
                    }
                    if (ebr != null) {
                        ebr.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Could not close Input/Output/Error streams of PDF report generation! " + e);
                }
            }
        }
    }
}

