/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.dbtools.crest.util.gui.swing.DefaultLabelColorScheme;
import oracle.dbtools.crest.util.gui.swing.LabelColorScheme;

public class JSelectableLabel
extends JLabel {
    protected boolean _hasFocus;
    protected boolean _isSelected;
    protected LabelColorScheme _colorScheme;
    private int _heightAdj;

    public JSelectableLabel() {
        this("");
    }

    public JSelectableLabel(String text) {
        this(text, new DefaultLabelColorScheme());
    }

    public JSelectableLabel(String text, LabelColorScheme colorScheme) {
        super(text);
        this._colorScheme = colorScheme;
        this.setHasFocus(false);
        this.setSelected(false);
        this.setBorder(new EmptyBorder(0, 3, 0, 3));
    }

    public boolean getHasFocus() {
        return this._hasFocus;
    }

    public void setHasFocus(boolean b) {
        this._hasFocus = b;
    }

    public void setHeightAdjustment(int heightAdj) {
        this._heightAdj = heightAdj;
        this.setVerticalAlignment(heightAdj == 0 ? 0 : 3);
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void setSelected(boolean b) {
        this._isSelected = b;
        this._updateColors();
    }

    protected void _updateColors() {
        if (this.isSelected()) {
            this.setForeground(this._colorScheme.getTextSelectionColor());
            this.setBackground(this._colorScheme.getBackgroundSelectionColor());
        } else if (!this.isEnabled()) {
            this.setForeground(Color.gray);
            this.setBackground(this._colorScheme.getBackgroundNonSelectionColor());
        } else {
            this.setForeground(this._colorScheme.getTextNonSelectionColor());
            this.setBackground(this._colorScheme.getBackgroundNonSelectionColor());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height += this._heightAdj;
        return d;
    }

    @Override
    public void paint(Graphics g) {
        int imageOffset = this.getLabelStart();
        boolean enabled = this.isEnabled();
        if (this._isSelected) {
            g.setColor(this.getBackground());
            g.fillRect(imageOffset, this._heightAdj, this.getWidth() - 1 - imageOffset, this.getHeight() - this._heightAdj);
        }
        if (this._hasFocus) {
            Border b = UIManager.getBorder("Tree.focusBorder");
            if (b != null) {
                g.setColor(this.getForeground());
                b.paintBorder(this, g, imageOffset, this._heightAdj, this.getWidth() - imageOffset, this.getHeight() - this._heightAdj);
            } else {
                if (!enabled) {
                    g.setColor(this._colorScheme.getBackgroundSelectionColor());
                } else {
                    g.setColor(this._colorScheme.getBorderSelectionColor());
                }
                g.drawRect(imageOffset, this._heightAdj, this.getWidth() - 1 - imageOffset, this.getHeight() - 1 - this._heightAdj);
            }
        }
        super.paint(g);
    }

    private int getLabelStart() {
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            return currentI.getIconWidth() + Math.max(8, this.getIconTextGap() - 1) - 1;
        }
        return 0;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._updateColors();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._colorScheme != null) {
            this._colorScheme.updateUI();
        }
    }
}

