/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.properties;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.properties.ManifestBlockRenderer;
import oracle.javatools.editor.language.properties.ManifestLanguageSupport;
import oracle.javatools.editor.language.properties.PropertiesStyles;
import oracle.javatools.resource.BundleHelper;

public class ManifestLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"MF"};

    @Override
    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("PROPERTIES_MODULE_NAME");
    }

    @Override
    public String[] getStyleNames() {
        return PropertiesStyles.STYLE_NAMES;
    }

    @Override
    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# OSGi Bundle Configuration \n").append("Bundle-SymbolicName: oracle.ide.spellchecker\n").append("Bundle-Name: Spellchecker Extension \n").append("Require-Bundle: oracle.ide\n").append("Export-Package: oracle.ide.spellchecker\n").append("Bundle-ManifestVersion: 2\n").append("Bundle-Version: 1.0.0\n");
        return buffer.toString();
    }

    @Override
    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    @Override
    public void registerStyles(StyleRegistry registry) {
        new PropertiesStyles(registry);
    }

    @Override
    public LanguageSupport createLanguageSupport() {
        return new ManifestLanguageSupport();
    }

    @Override
    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new ManifestBlockRenderer(buffer);
    }
}

