/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.CustomConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;
import oracle.jdevimpl.db.model.ConnectionSelector;
import oracle.jdevimpl.db.panels.ConnectionEditorPanel;
import oracle.jdevimpl.db.resource.ConnBundle;

public class DefaultConnectionEditorLauncher
extends DatabaseConnectionEditorLauncher {
    protected Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    protected DatabaseConnections getConnections() {
        return DatabaseConnectionStores.getInstance().getCurrentStore(this.getContext());
    }

    protected String getDefaultSubtype() {
        String[] subtypes;
        String type;
        Properties defaultProps;
        String retval = null;
        if (this.isAllowedSubType("oraJDBC")) {
            retval = "oraJDBC";
        }
        if ((defaultProps = this.getDefaultProperties()) != null && ModelUtil.hasLength((String)(type = defaultProps.getProperty("subtype"))) && this.isAllowedSubType(type)) {
            retval = type;
        }
        if (retval == null && (subtypes = this.getAllowedSubTypes()) != null && subtypes.length > 0) {
            retval = subtypes[0];
        }
        return retval == null ? null : "oraJDBC";
    }

    protected Traversable createPanel() {
        return new ConnectionEditorPanel();
    }

    protected Component getDefaultFocusComponent(Traversable panel) {
        return ((ConnectionEditorPanel)panel).getDefaultFocusComponent();
    }

    protected String getTitle(boolean edit) {
        return edit ? ConnBundle.get("DB_CONN_ED_TITLE") : ConnBundle.get("DB_CONN_CREATE_TITLE");
    }

    protected String getHeaderText(boolean edit) {
        return edit ? ConnBundle.get("DB_CONN_ED_HEADER_TEXT") : ConnBundle.get("DB_CONN_CREATE_HEADER_TEXT");
    }

    protected Icon getHeaderIcon(boolean edit) {
        return null;
    }

    protected void setupNamespace(Namespace data) {
    }

    private Properties newConnectionProperties() {
        Properties props = new Properties();
        props.put("subtype", this.getDefaultSubtype());
        Properties defaultProps = this.getDefaultProperties();
        if (defaultProps != null) {
            for (String prop : defaultProps.stringPropertyNames()) {
                props.setProperty(prop, defaultProps.getProperty(prop));
            }
        }
        return props;
    }

    @Override
    public final ConnectionInfo launchEditor(DatabaseConnections conns, String connName) {
        Traversable panel = this.createPanel();
        Component parent = DBMessageDialog.getDialogParent();
        Component defaultComp = this.getDefaultFocusComponent(panel);
        if (conns == null) {
            conns = this.getConnections();
        }
        if (conns == null) {
            throw new IllegalStateException("No DatabaseConnections to create a connection in.");
        }
        Properties props = null;
        DatabaseProvider referenceable = null;
        if (ModelUtil.hasLength((String)connName)) {
            try {
                referenceable = conns.getReferenceable(connName);
                props = referenceable.getProperties();
            }
            catch (ConnectionException ce) {
                MessageDialog.error((Component)parent, (Object)ce.getMessage(), (String)this.getTitle(true), null);
                return null;
            }
        }
        boolean edit = props != null;
        String originalName = edit ? connName : null;
        boolean newConn = false;
        if (props == null) {
            newConn = true;
            props = this.newConnectionProperties();
            if (!ModelUtil.hasLength((String)connName)) {
                connName = DBUtil.getUniqueName(conns.listConnections(), (String)this.getConnectionBaseName());
            }
        } else {
            String subtype = props.getProperty("subtype");
            boolean found = false;
            if (subtype != null) {
                for (DatabaseConnectionHook.ConnectionType type : DatabaseConnectionHook.getHook().getConnectionTypes()) {
                    if (!subtype.equals(type.getSubtype())) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                props = this.convertInvalidSubtype(subtype, referenceable);
            } else if (!this.isAllowedSubType(subtype)) {
                throw new IllegalStateException(subtype + " is not supported by this launcher.");
            }
        }
        Namespace data = new Namespace();
        data.put(DatabaseConnections.class.getName(), (Object)conns);
        data.put("ConnectionNameKey", (Object)connName);
        data.put("ConnectionOrigNameKey", (Object)originalName);
        data.put("NewObject", (Object)props);
        data.put(DatabaseConnectionEditorLauncher.class.getName(), (Object)this);
        data.put(Context.class.getName(), (Object)this.getContext());
        this.setupNamespace(data);
        TDialogLauncher launcher = new TDialogLauncher(parent, this.getTitle(edit), panel, data);
        Icon headerIcon = this.getHeaderIcon(edit);
        String headerText = this.getHeaderText(edit);
        DialogHeader header = headerIcon == null ? DefaultConnectionEditorLauncher.createDialogHeader(headerText) : DefaultConnectionEditorLauncher.createDialogHeader(headerText, headerIcon);
        launcher.setDialogHeader(header);
        launcher.setPackDialog(true);
        JEWTDialog dialog = launcher.initDialog();
        dialog.setInitialFocus(defaultComp);
        dialog.addVetoableChangeListener((VetoableChangeListener)new CommitListener(data));
        dialog.setName(newConn ? "CreateDatabaseConnectionDialog" : "EditDatabaseConnectionDialog");
        ConnectionInfo retval = null;
        if (launcher.showDialog()) {
            ConnectionInfo selected;
            String name = (String)data.get("ConnectionNameKey");
            DatabaseConnections store = (DatabaseConnections)data.get(DatabaseConnections.class);
            try {
                store.saveConnections();
            }
            catch (ConnectionException e) {
                this.getLogger().warning("Couldn't save connection: " + e.getMessage());
            }
            retval = selected = new ConnectionInfo(store == null ? null : store.getStoreName(), name);
            if (!edit && this.getEnsureVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionSelector.selectConnection(selected, DefaultConnectionEditorLauncher.this.getContext(), false);
                    }
                });
            }
        }
        return retval;
    }

    protected Properties convertInvalidSubtype(String subtype, DatabaseProvider referenceable) {
        if (!this.isAllowedSubType("thirdParty")) {
            throw new IllegalStateException("Unknown subtype" + subtype);
        }
        this.getLogger().severe(subtype + " is not recognized");
        Properties retval = new Properties();
        for (String prop : new CustomConnectionCreator().listAllowedProperties()) {
            String val = referenceable.getProperty(prop);
            if (val == null) continue;
            retval.setProperty(prop, val);
        }
        retval.setProperty("subtype", "thirdParty");
        try {
            retval.setProperty("customUrl", referenceable.getConnectionURL());
        }
        catch (SQLException sqe) {
            this.getLogger().warning(sqe.getMessage());
        }
        try {
            retval.setProperty("driver", referenceable.getDriverClassName());
        }
        catch (SQLException sqe) {
            this.getLogger().warning(sqe.getMessage());
        }
        return retval;
    }

    protected void doCommit(DatabaseConnections conns, String originalName, String newName, Properties props, Namespace data) throws ConnectionException {
        if (originalName != null) {
            conns.updateConnection(originalName, newName, props);
        } else {
            boolean ensureVisible = this.getEnsureVisible();
            if (ensureVisible) {
                ConnectionInfo info = new ConnectionInfo(conns.getStoreName(), null);
                ConnectionSelector.selectConnection(info, this.getContext(), false);
            }
            conns.addConnection(newName, props);
        }
    }

    public static DialogHeader createDialogHeader(String text) {
        return DefaultConnectionEditorLauncher.createDialogHeader(text, OracleIcons.getIcon((String)"header/dbconn_lg_qualifier.png"));
    }

    private static DialogHeader createDialogHeader(String text, Icon icon) {
        return new DialogHeader(text, OracleIcons.toImage((Icon)icon));
    }

    private class CommitListener
    implements VetoableChangeListener {
        private Namespace data;

        private CommitListener(Namespace d) {
            this.data = d;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                String newName = (String)this.data.get("ConnectionNameKey");
                Properties props = (Properties)this.data.get("NewObject");
                DatabaseConnections conns = (DatabaseConnections)this.data.get(DatabaseConnections.class);
                String originalName = (String)this.data.get("ConnectionOrigNameKey");
                try {
                    DefaultConnectionEditorLauncher.this.doCommit(conns, originalName, newName, props, this.data);
                }
                catch (ConnectionException ce) {
                    MessageDialog.error((Component)DBMessageDialog.getDialogParent(), (Object)ce.getMessage(), (String)DefaultConnectionEditorLauncher.this.getTitle(originalName != null), null);
                    throw new PropertyVetoException(ce.getMessage(), evt);
                }
            }
        }
    }
}

