/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.migration;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Referenceable;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.db.adapter.CMHelper;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class CMConnectionsReader
extends DefaultHandler
implements LexicalHandler {
    public static final String DEFAULT_FILE = "connections.xml";
    public static final String DEFAULT_PROPERTIES_FILE = "connections.properties";
    public static final String CONNECTION_TAG = "connection";
    private static final String PWD_PROP = "PWD";
    private static final String ORMI_PWD_PROP = "ORMI-PWD";
    public static final String PASSWORD = "password";
    public static final String ORMI_PASSWD = "ormi-password";
    public static final String CONNECTION_NAME = "ConnectionName";
    public static final String CONNECTION_TYPE = "ConnectionType";
    private final String m_fName;
    private final boolean m_isAbsolutePath;
    private List<Properties> m_list = null;
    private Properties m_curDesc = null;
    private String m_curKey;
    private StringBuffer m_curValue;
    private String m_cdata;

    public CMConnectionsReader() {
        this("/connections.xml", false);
    }

    public CMConnectionsReader(String fName, boolean isAbsolutePath) {
        this.m_fName = fName;
        this.m_isAbsolutePath = isAbsolutePath;
    }

    private final Logger getLogger() {
        return DBLog.getAndInitialiseLogger((String)"oracle.jdeveloper.db.migration");
    }

    private void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ioe) {
                this.getLogger().fine("Failed to close file: " + ioe.getMessage());
            }
        }
    }

    public final Map<String, Referenceable> getMigratedConnections() {
        HashMap<String, Referenceable> map = new HashMap<String, Referenceable>();
        try {
            List<Properties> list = this.read();
            if (list != null) {
                for (Properties toMigrate : list) {
                    String name;
                    if (toMigrate == null || !ModelUtil.hasLength((String)(name = toMigrate.getProperty(CONNECTION_NAME)))) continue;
                    try {
                        Referenceable ref = CMHelper.createReferenceFromDescriptor((Properties)toMigrate);
                        if (ref == null) continue;
                        map.put(name, ref);
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.WARNING, "Couldn't migrate connection " + name, e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Couldn't migrate connections.", e);
        }
        return map;
    }

    public final List<Properties> read() {
        return this.read(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Properties> read(boolean dbOnly) {
        this.m_list = null;
        InputStream is = null;
        try {
            InputStream inputStream = is = this.m_isAbsolutePath ? new FileInputStream(this.m_fName) : CMConnectionsReader.getInputStream(this.getClass(), this.m_fName);
            if (is != null) {
                SAXParser parser = null;
                try {
                    parser = new SAXParser();
                    parser.setContentHandler((ContentHandler)this);
                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)this);
                    parser.parse(is);
                }
                catch (SAXException sAXException) {
                }
                finally {
                    if (parser != null) {
                        parser.reset();
                        parser = null;
                    }
                }
            }
            this.close(is);
        }
        catch (IOException ioe) {
            try {
                this.getLogger().fine("Failed to read " + this.m_fName + " : " + ioe.getMessage());
                this.close(is);
            }
            catch (Throwable throwable) {
                this.close(is);
                throw throwable;
            }
        }
        if (this.m_list == null || this.m_list.size() == 0) {
            this.m_list = this.readPCS();
        } else {
            Iterator<Properties> iterPCS;
            List<Properties> listPCS = this.readPCS();
            Iterator<Properties> iterator = iterPCS = listPCS != null ? listPCS.iterator() : Collections.EMPTY_LIST.iterator();
            while (iterPCS.hasNext()) {
                Properties cDesc = iterPCS.next();
                if (this.listContains(cDesc.getProperty(CONNECTION_NAME))) continue;
                this.m_list.add(cDesc);
            }
        }
        if (dbOnly && this.m_list != null) {
            List<String> allowedTypes = Arrays.asList("JDBC", "OTHER_JDBC", "JDBC_ODBC", "ORACLE_LITE");
            Iterator<Properties> props = this.m_list.iterator();
            while (props.hasNext()) {
                String connType = props.next().getProperty(CONNECTION_TYPE);
                if (allowedTypes.contains(connType)) continue;
                props.remove();
            }
        }
        return this.m_list;
    }

    private static InputStream getInputStream(Class clazz, String fName) {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = is = cl != null ? cl.getResourceAsStream(fName) : null;
        if (is == null) {
            is = clazz.getResourceAsStream(fName);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Properties> readPCS() {
        List<Properties> list = null;
        InputStream is = null;
        try {
            InputStream inputStream = is = this.m_isAbsolutePath ? new FileInputStream(this.m_fName) : CMConnectionsReader.getInputStream(this.getClass(), this.m_fName);
            if (is != null) {
                Properties p = new Properties();
                p.load(is);
                list = this.loadConnectionDescriptorsFromProperties(p);
            }
            this.close(is);
        }
        catch (FileNotFoundException p) {
            this.close(is);
        }
        catch (IOException ioe) {
            try {
                this.getLogger().fine("Failed to read " + this.m_fName + " : " + ioe.getMessage());
                this.close(is);
            }
            catch (Throwable throwable) {
                this.close(is);
                throw throwable;
            }
        }
        if (!(list != null && list.size() != 0 || this.m_isAbsolutePath)) {
            InputStream is2 = null;
            try {
                is2 = CMConnectionsReader.getInputStream(this.getClass(), "/connections.properties");
                if (is2 != null) {
                    Properties p = new Properties();
                    p.load(is2);
                    list = this.loadConnectionDescriptorsFromProperties(p);
                }
            }
            catch (IOException ioEx) {
                list = null;
                this.getLogger().fine("Failed to read connections.properties : " + ioEx.getMessage());
            }
            finally {
                this.close(is2);
            }
        }
        return list;
    }

    private final List<Properties> loadConnectionDescriptorsFromProperties(Properties p) throws IOException {
        ArrayList<Properties> list = null;
        String numConn = p.getProperty("CM_NumConnections");
        if (null != numConn) {
            int numConnections = Integer.parseInt(numConn);
            list = new ArrayList<Properties>(numConnections);
            for (int i = 1; i <= numConnections; ++i) {
                String pVal = p.getProperty("CM_Connection" + i);
                ByteArrayInputStream pStream = new ByteArrayInputStream(pVal.replace(',', '\n').getBytes());
                Properties cDesc = new Properties();
                cDesc.load(pStream);
                list.add(cDesc);
            }
        }
        return list;
    }

    private final boolean listContains(String connName) {
        for (Properties c : this.m_list) {
            if (!c.getProperty(CONNECTION_NAME).equals(connName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startDocument() {
        if (this.m_list == null) {
            this.m_list = new ArrayList<Properties>(10);
        } else {
            this.m_list.clear();
        }
    }

    @Override
    public void endDocument() {
        this.m_curKey = null;
        this.m_curValue = null;
        this.m_curDesc = null;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (name.equals(CONNECTION_TAG)) {
            this.m_curDesc = new Properties();
            this.m_curKey = null;
            this.m_curValue = null;
            this.m_cdata = null;
        } else if (this.m_curDesc != null) {
            this.m_curKey = name;
            this.m_curValue = new StringBuffer();
            this.m_cdata = null;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (name.equals(CONNECTION_TAG)) {
            if (this.m_curDesc != null && this.m_curDesc.getProperty(CONNECTION_NAME) != null) {
                this.m_list.add(this.m_curDesc);
            }
            this.m_curDesc = null;
        } else if (this.m_curDesc != null && this.m_curKey != null) {
            String value = this.m_curValue.toString();
            if (CONNECTION_TYPE.equals(this.m_curKey) && "IAS".equals(this.m_curValue.toString())) {
                value = "OC4J";
            } else if ("IAS_HOME".equals(this.m_curKey)) {
                this.m_curKey = "OC4J_HOME";
            } else if ("PASSWORD".equals(this.m_curKey)) {
                if (this.m_curDesc.getProperty(PASSWORD) != null) {
                    this.m_curKey = null;
                }
            } else if (PWD_PROP.equals(this.m_curKey) || ORMI_PWD_PROP.equals(this.m_curKey)) {
                value = null;
                String string = this.m_curKey = PWD_PROP.equals(this.m_curKey) ? PASSWORD : ORMI_PASSWD;
                if (this.m_cdata != null) {
                    try {
                        value = DatabaseProviderHelper.comingIn((String)this.m_cdata);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.m_curKey != null) {
                this.m_curDesc.put(this.m_curKey, value);
            }
        }
        this.m_curKey = null;
        this.m_curValue = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_curKey != null) {
            this.m_curValue.append(ch, start, length);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_cdata = this.m_curValue.toString();
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_curValue.setLength(0);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }
}

