/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import oracle.ide.Context;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.panels.AbstractConnectionPanelUI;
import oracle.jdevimpl.db.controls.GlobalConnectionPicker;
import oracle.jdevimpl.db.resource.ConnBundle;

public class GlobalConnectionPanelUI
extends AbstractConnectionPanelUI {
    private GlobalConnectionPicker m_picker;

    public GlobalConnectionPanelUI() {
        this((String[])null, true);
    }

    public GlobalConnectionPanelUI(boolean oracleOnly) {
        String[] stringArray;
        if (oracleOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = GlobalConnectionPanelUI.getOracleSubType();
        } else {
            stringArray = null;
        }
        this(stringArray);
    }

    public GlobalConnectionPanelUI(String[] subTypes) {
        this(subTypes, true);
    }

    public GlobalConnectionPanelUI(String[] subTypes, boolean showDetails) {
        super(subTypes, showDetails);
        this.initialise();
        this.resetConnections();
    }

    @Override
    protected String getComponentNamePrefix() {
        return "GlobalConnectionPanelUI";
    }

    @Override
    public final ConnectionInfo getConnectionInfo() {
        return this.getPicker().getConnectionInfo();
    }

    @Override
    public final void setConnectionInfo(ConnectionInfo info) {
        this.getPicker().setConnectionInfo(info);
    }

    @Override
    public final void setContext(Context ideContext) {
        super.setContext(ideContext);
        this.getPicker().setContext(ideContext);
    }

    public final GlobalConnectionPicker getPicker() {
        if (this.m_picker == null) {
            this.m_picker = new GlobalConnectionPicker(this.getSubTypes());
        }
        return this.m_picker;
    }

    @Override
    protected final void launchConnectionDialog(boolean edit) {
        ConnectionInfo info = this.m_picker.getConnectionInfo();
        String storeName = info.getStoreName();
        boolean allStores = this.m_picker.listStores().size() > 2;
        ConnectionInfo launchInfo = edit ? info : new ConnectionInfo(storeName, null);
        DatabaseConnectionEditorLauncher launcher = DatabaseConnectionEditor.createLauncher();
        launcher.setContext(this.m_picker.getContext());
        launcher.setStoreChoice(allStores ? DatabaseConnectionEditorLauncher.StoreChoice.ALL : DatabaseConnectionEditorLauncher.StoreChoice.CONTEXT);
        launcher.setAllowedSubTypes(this.getSubTypes());
        ConnectionInfo created = launcher.launchEditor(launchInfo);
        if (created != null && created.isValid()) {
            this.clearLastShownInfo();
            this.resetConnections();
            this.setConnectionInfo(created);
        }
    }

    @Override
    public int resetConnections() {
        int retval = this.getPicker().resetConnections();
        if (!this.getConnectionInfo().isValid() && this.getNoConnectionString() == null) {
            this.fireSelectionChanged();
        }
        return retval;
    }

    @Override
    public void setNoConnectionString(String noConn) {
        if (ModelUtil.areDifferent((Object)this.getNoConnectionString(), (Object)noConn)) {
            super.setNoConnectionString(noConn);
            this.getPicker().setNoConnectionString(noConn);
        }
    }

    @Deprecated
    public static ConnectionInfo getConnection(String title, String prompt, String storeName, String connName) {
        return GlobalConnectionPanelUI.getConnection(title, prompt, new ConnectionInfo(storeName, connName), false, null);
    }

    @Deprecated
    public static ConnectionInfo getConnection(String title, String prompt, String storeName, String connName, boolean oraOnly) {
        return GlobalConnectionPanelUI.getConnection(title, prompt, new ConnectionInfo(storeName, connName), oraOnly, null);
    }

    public static ConnectionInfo getConnection(ConnectionInfo connInfo) {
        return GlobalConnectionPanelUI.getConnection(connInfo, false, null);
    }

    public static ConnectionInfo getConnection(ConnectionInfo connInfo, boolean oraOnly, Context context) {
        return GlobalConnectionPanelUI.getConnection(ConnBundle.get("CHOOSE_CONNECTION_TITLE"), ConnBundle.get("MESSAGE_CONNECTION_PROMPT"), connInfo, oraOnly, context);
    }

    public static ConnectionInfo getConnection(String title, String prompt, ConnectionInfo connInfo, boolean oraOnly, Context ideContext) {
        if (connInfo == null) {
            connInfo = new ConnectionInfo(null, null);
        }
        if (ideContext == null) {
            ideContext = Context.newIdeContext();
        }
        GlobalConnectionPanelUI panel = new GlobalConnectionPanelUI(oraOnly);
        panel.setConnectionPrompt(prompt);
        panel.setConnectionInfo(connInfo);
        panel.setContext(ideContext);
        return GlobalConnectionPanelUI.getConnection(panel, title, connInfo);
    }

    @Deprecated
    public static class ChosenConnection
    extends ConnectionInfo {
        public ChosenConnection(String storeName, String connName) {
            super(storeName, connName);
        }
    }
}

