/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdevimpl.db.panels.AbstractConnectionDetailsPanel;
import oracle.jdevimpl.db.resource.ConnBundle;

public final class OraclePanel
extends AbstractConnectionDetailsPanel {
    private final String[] ORA_DRIVER_TYPES = new String[]{"thin", "oci8"};
    private final JComboBox m_cmbDriver = new JComboBox();
    private final JTextField m_fldHost = new JTextField();
    private final NumberTextField m_fldPort = OraclePanel.newPortField();
    private final JTextField m_fldSid = new JTextField();
    private final JTextField m_fldServiceName = new JTextField();
    private final JRadioButton m_rdbSidSelector = new JRadioButton();
    private final JRadioButton m_rdbServiceNameSelector = new JRadioButton();
    private final ButtonGroup m_rbgSelectorGroup = new ButtonGroup();

    public OraclePanel() {
        super("oraJDBC", "OraclePanel");
    }

    @Override
    protected JPanel createDetailsPanel(DBUIResourceHelper resHelp) {
        JLabel lblDriver = new JLabel();
        JLabel lblHost = new JLabel();
        JLabel lblJdbcPort = new JLabel();
        JLabel lblSid = new JLabel();
        lblSid.setVisible(false);
        JLabel lblServiceName = new JLabel();
        lblServiceName.setVisible(false);
        resHelp.resLabel(lblDriver, (Component)this.m_cmbDriver, this.getPropertyLabelText("oraDriverType"), "Driver");
        this.registerTextComponent("hostname", lblHost, this.m_fldHost, "Host");
        this.registerTextComponent("port", lblJdbcPort, (JTextComponent)this.m_fldPort, "Port");
        resHelp.resLabel(lblSid, (Component)this.m_fldSid, ConnBundle.get("OTP_SID_VALUE"), "SIDValue");
        resHelp.resLabel(lblServiceName, (Component)this.m_fldServiceName, ConnBundle.get("OTP_SERVICENAME_VALUE"), "ServiceNameValue");
        this.m_rdbSidSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OraclePanel.this.enableControls();
                OraclePanel.this.m_fldSid.requestFocus();
            }
        });
        resHelp.resButton((AbstractButton)this.m_rdbSidSelector, this.getPropertyLabelText("sid"), "SID");
        this.m_rdbSidSelector.setSelected(true);
        resHelp.resButton((AbstractButton)this.m_rdbServiceNameSelector, this.getPropertyLabelText("serviceName"), "ServiceName");
        this.m_rdbServiceNameSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OraclePanel.this.enableControls();
                OraclePanel.this.m_fldServiceName.requestFocus();
            }
        });
        this.m_rbgSelectorGroup.add(this.m_rdbSidSelector);
        this.m_rbgSelectorGroup.add(this.m_rdbServiceNameSelector);
        DefaultComboBoxModel<String> driverModel = new DefaultComboBoxModel<String>();
        driverModel.addElement(this.ORA_DRIVER_TYPES[0]);
        driverModel.addElement(this.ORA_DRIVER_TYPES[1]);
        this.m_cmbDriver.setModel(driverModel);
        JPanel detailsPanel = new JPanel();
        DBUILayoutHelper layout = new DBUILayoutHelper(detailsPanel);
        layout.add((Component)lblDriver, 2, 1);
        layout.add((Component)this.m_cmbDriver);
        layout.nextRow();
        layout.add((Component)lblHost, 2, 1);
        layout.add((Component)this.m_fldHost);
        layout.add((Component)lblJdbcPort);
        layout.add((Component)this.m_fldPort, 1, 1, false, false);
        layout.nextRow();
        layout.add((Component)this.m_rdbSidSelector);
        layout.add((Component)lblSid);
        layout.add((Component)this.m_fldSid);
        layout.nextRow();
        layout.add((Component)this.m_rdbServiceNameSelector);
        layout.add((Component)lblServiceName);
        layout.add((Component)this.m_fldServiceName);
        layout.nextRow();
        layout.pushUp();
        layout.layout();
        this.enableControls();
        return detailsPanel;
    }

    @Override
    protected String getDefaultValue(String property) {
        String retval = "port".equals(property) ? "1521" : super.getDefaultValue(property);
        return retval;
    }

    @Override
    protected void populateConnectionDetails(Properties connectionProps) {
        super.populateConnectionDetails(connectionProps);
        String sid = connectionProps.getProperty("sid");
        String serviceName = connectionProps.getProperty("serviceName");
        if (serviceName != null && sid == null) {
            this.m_rdbServiceNameSelector.setSelected(true);
        } else {
            this.m_rdbSidSelector.setSelected(true);
        }
        if (sid == null && serviceName == null) {
            sid = "XE";
            serviceName = "XE";
        }
        this.m_fldSid.setText(sid);
        this.m_fldServiceName.setText(serviceName);
        String dt = connectionProps.getProperty("oraDriverType");
        if (dt == null) {
            dt = this.ORA_DRIVER_TYPES[0];
        }
        this.m_cmbDriver.setSelectedItem(dt);
        this.enableControls();
    }

    @Override
    protected void commitConnectionDetails(Properties connectionProps, boolean isCustom) {
        super.commitConnectionDetails(connectionProps, isCustom);
        connectionProps.remove("oraDriverType");
        connectionProps.remove("sid");
        connectionProps.remove("serviceName");
        if (!isCustom) {
            int driverIndex = this.m_cmbDriver.getSelectedIndex();
            if (driverIndex < 0) {
                driverIndex = 0;
            }
            connectionProps.setProperty("oraDriverType", this.ORA_DRIVER_TYPES[driverIndex]);
            if (this.m_rdbSidSelector.isSelected()) {
                this.setProperty(connectionProps, "sid", this.getTrimmedText(this.m_fldSid));
            } else {
                this.setProperty(connectionProps, "serviceName", this.getTrimmedText(this.m_fldServiceName));
            }
        }
    }

    @Override
    protected void validateConnectionDetails(Properties connectionProps, boolean isCustom) throws TraversalException {
        super.validateConnectionDetails(connectionProps, isCustom);
        if (!isCustom) {
            if (this.m_rdbSidSelector.isSelected()) {
                MissingDBConnValueException.check(connectionProps.getProperty("sid"), this.m_rdbSidSelector);
            } else {
                MissingDBConnValueException.check(connectionProps.getProperty("serviceName"), this.m_rdbServiceNameSelector);
            }
        }
    }

    private void enableControls() {
        if (this.m_rdbSidSelector.isSelected()) {
            this.m_fldSid.setEnabled(true);
            this.m_fldServiceName.setEnabled(false);
        } else {
            this.m_fldSid.setEnabled(false);
            this.m_fldServiceName.setEnabled(true);
        }
    }
}

