/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.List;
import oracle.dbtools.common.immutables.ImmutableList;
import oracle.dbtools.common.immutables.impl.CollectionFactory;
import oracle.dbtools.common.immutables.impl.ListImpl;
import oracle.dbtools.common.util.Iterables;

class ListBuilder<V>
implements ImmutableList.Builder<V> {
    private final List<V> elements;

    private ListBuilder(int size) {
        this.elements = CollectionFactory.list(size);
    }

    @Override
    public ListBuilder<V> add(Iterable<V> values) {
        Iterables.add(this.elements, values);
        return this;
    }

    @Override
    public ListBuilder<V> add(V value) {
        this.elements.add(value);
        return this;
    }

    @Override
    public ImmutableList<V> build() {
        return ListImpl.newInstance(this.elements);
    }

    @Override
    public ListBuilder<V> clear() {
        this.elements.clear();
        return this;
    }

    public boolean equals(Object obj) {
        return this.elements.equals(obj);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public ListBuilder<V> remove(int index) {
        this.elements.remove(index);
        return this;
    }

    @Override
    public ListBuilder<V> remove(Iterable<V> values) {
        for (V value : values) {
            this.remove(value);
        }
        return this;
    }

    @Override
    public ListBuilder<V> remove(Object o) {
        this.elements.remove(o);
        return this;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public String toString() {
        return this.elements.toString();
    }

    static <V> ListBuilder<V> newInstance(int size) {
        size = size == 0 ? 10 : (size *= 2);
        ListBuilder<V> builder = new ListBuilder<V>(size);
        return builder;
    }

    static <V> ListBuilder<V> newInstance(Iterable<V> elements) {
        int size = Iterables.size(elements);
        ListBuilder<V> builder = ListBuilder.newInstance(size);
        return builder.add((Iterable)elements);
    }
}

