/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.locale;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.common.locale.LocalePreference;
import oracle.dbtools.common.locale.LocalePreferencesProvider;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Pair;

class LocalePreferenceImpl
implements LocalePreference {
    protected final List<Locale> locales = new ArrayList<Locale>();

    LocalePreferenceImpl(Iterable<Locale> locales) {
        Iterables.add(this.locales, locales);
    }

    public Locale firstPreference() {
        return Iterables.first(this.locales);
    }

    @Override
    public URI choose(URI root) {
        Pair<URI, LocalePreferenceImpl> choice = Pair.pair(root, this);
        return LocalePreferencesProvider.BEST_MATCHES.apply(choice);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalePreference other = (LocalePreference)obj;
        return Iterables.equals(this, other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locales == null ? 0 : this.locales.hashCode());
        return result;
    }

    public Iterator<Locale> iterator() {
        return this.locales.iterator();
    }

    public String toString() {
        return Iterables.join(this.locales, ", ");
    }
}

