/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.reflect;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;

public class Constructors {
    private final LoadingCache<Constructor<?>, Type[]> genericParameterTypes;
    private final LoadingCache<Constructor<?>, Annotation[][]> parameterAnnotations = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new ParameterAnnotationsLoader());

    public Constructors() {
        this.genericParameterTypes = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new GenericParameterTypesLoader());
    }

    public Type[] getGenericParameterTypes(Constructor<?> ctor) {
        return (Type[])this.genericParameterTypes.getUnchecked(ctor);
    }

    public Annotation[][] getParameterAnnotations(Constructor<?> ctor) {
        return (Annotation[][])this.parameterAnnotations.getUnchecked(ctor);
    }

    private static final class ParameterAnnotationsLoader
    extends CacheLoader<Constructor<?>, Annotation[][]> {
        private ParameterAnnotationsLoader() {
        }

        public Annotation[][] load(Constructor<?> key) throws Exception {
            return key.getParameterAnnotations();
        }
    }

    private static final class GenericParameterTypesLoader
    extends CacheLoader<Constructor<?>, Type[]> {
        private GenericParameterTypesLoader() {
        }

        public Type[] load(Constructor<?> key) throws Exception {
            return key.getGenericParameterTypes();
        }
    }
}

