/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.util.Transform;

public class Substitution
implements Transform<CharSequence, String> {
    private final Pattern pattern;
    private final String replacementPattern;

    public Substitution(Pattern pattern, String replacementPattern) {
        this.pattern = pattern;
        this.replacementPattern = replacementPattern;
    }

    public Substitution(String pattern, int flags, String replacementPattern) {
        this(Pattern.compile(pattern, flags), replacementPattern);
    }

    public Substitution(String caseInsenstivePattern, String replacementPattern) {
        this(caseInsenstivePattern, 106, replacementPattern);
    }

    @Override
    public String apply(CharSequence text) {
        Matcher m = this.pattern.matcher(text);
        return m.replaceAll(this.replacementPattern);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.pattern);
        builder.append(" -> ");
        builder.append(this.replacementPattern);
        builder.append("]");
        return builder.toString();
    }
}

