/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.dbtools.common.util.AnonymousPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.M2NIterator;
import oracle.dbtools.common.util.NullOrEmpty;

public class CompoundPrincipal
implements Principal,
Iterable<Principal>,
Serializable {
    private final Collection<Principal> principals = new ArrayList<Principal>();
    private static final long serialVersionUID = 4016656333208147432L;

    private CompoundPrincipal(Iterable<Principal> principals) {
        for (Principal principal : principals) {
            if (principal == null) {
                throw new IllegalArgumentException();
            }
            if (principal instanceof CompoundPrincipal) {
                throw new IllegalArgumentException();
            }
            if (principal instanceof Serializable) continue;
            throw new IllegalArgumentException();
        }
        Iterables.add(this.principals, principals);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CompoundPrincipal) {
            return Iterables.equals(this, (CompoundPrincipal)obj);
        }
        return false;
    }

    @Override
    public String getName() {
        return this.primary().getName();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.principals == null ? 0 : this.principals.hashCode());
        return result;
    }

    public CompoundPrincipal identifiedAs(Iterable<Principal> principals) {
        if (NullOrEmpty.nullOrEmpty(principals)) {
            return this;
        }
        Iterable<Principal> nonPrimary = Iterables.subsequent(this);
        Iterable<Principal> merged = Iterables.merge(principals, nonPrimary);
        return new CompoundPrincipal(merged);
    }

    @Override
    public Iterator<Principal> iterator() {
        if (this.principals.isEmpty()) {
            return Iterators.iterator(AnonymousPrincipal.ANONYMOUS);
        }
        return this.principals.iterator();
    }

    public Principal primary() {
        return Iterables.first(this.principals);
    }

    public <T extends Principal> T principal(Class<T> type) {
        return (T)((Principal)Iterators.nextOrNull(this.principals(type)));
    }

    public <T extends Principal> Iterator<T> principals(Class<T> type) {
        return new IsAssignableFrom(this.iterator(), type);
    }

    public CompoundPrincipal replace(Class<? extends Principal> typesOf, Principal newPrincipal) {
        if (newPrincipal == null) {
            return this;
        }
        Collection<Principal> existingPrincipals = this.principals;
        boolean replaced = false;
        LinkedHashSet<Principal> mergedPrincipals = new LinkedHashSet<Principal>(existingPrincipals.size() + 1);
        for (Principal existing : existingPrincipals) {
            boolean matched = typesOf.isAssignableFrom(existing.getClass());
            if (matched) {
                replaced = true;
                mergedPrincipals.add(newPrincipal);
                continue;
            }
            mergedPrincipals.add(existing);
        }
        if (!replaced) {
            mergedPrincipals.add(newPrincipal);
        }
        return CompoundPrincipal.compound(mergedPrincipals);
    }

    @Override
    public String toString() {
        return Iterables.asString(this);
    }

    public static CompoundPrincipal anonymous() {
        return CompoundPrincipal.external(AnonymousPrincipal.ANONYMOUS);
    }

    public static CompoundPrincipal compound(Iterable<Principal> principals) {
        if (NullOrEmpty.nullOrEmpty(principals)) {
            return null;
        }
        if (principals instanceof CompoundPrincipal) {
            return (CompoundPrincipal)principals;
        }
        return new CompoundPrincipal(principals);
    }

    public static CompoundPrincipal compound(Principal ... principals) {
        return CompoundPrincipal.compound(Iterables.iterable(principals));
    }

    public static CompoundPrincipal external(Principal external) {
        return CompoundPrincipal.compound(Iterables.iterable(external));
    }

    private static final class IsAssignableFrom<T>
    extends M2NIterator<Principal, T> {
        private final Class<T> type;

        private IsAssignableFrom(Iterator<Principal> principals, Class<T> type) {
            super(principals);
            this.type = type;
        }

        @Override
        protected void process(Principal item) {
            if (this.type.isAssignableFrom(item.getClass())) {
                this.add(this.type.cast(item));
            }
        }
    }
}

