/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V>
implements Serializable {
    private final int _maxEntries;
    private static final int DEFAULT_MAX_ENTRIES = 100;
    private static final long serialVersionUID = 45L;

    public LRUCache() {
        super(101, 0.75f, true);
        this._maxEntries = 100;
    }

    public LRUCache(int maxEntries) {
        super(maxEntries + 1, 0.75f, true);
        this._maxEntries = maxEntries;
    }

    public LRUCache(int maxEntries, float loadFactor) {
        super(maxEntries + 1, loadFactor, true);
        this._maxEntries = maxEntries;
    }

    protected int getMaxEntries() {
        return this._maxEntries;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this._maxEntries;
    }
}

