/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.lang.reflect.Method;
import java.net.URL;
import java.text.CollationKey;
import java.text.Collator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.FileModelAdapter;
import oracle.jdeveloper.audit.model.Located;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.LockPolicy;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.service.AuditLogger;

public abstract class ModelAdapter
implements Comparable<ModelAdapter>,
Located {
    static final int ORDINAL_INTERVAL = 16;
    private final ModelFactory factory;
    private final ModelType type;
    private final Element element;
    private final ContainerModelAdapter workspaceModel;
    private final ContainerModelAdapter projectModel;
    private final ContainerModelAdapter directoryModel;
    private final URL url;
    private final CollationKey primaryKey;
    private CollationKey secondaryKey;
    int ordinal = 0;
    private Location location;
    private Map<Object, Object> attributes;
    private volatile ReadWriteLock nodeLock;
    private volatile Context ideContext;
    private static Method lockMethod;
    private static final Log LOG;

    protected ModelAdapter(ModelFactory factory, ModelType type, Workspaces workspaces, URL url) {
        this.factory = factory;
        this.type = type;
        this.element = workspaces;
        this.workspaceModel = null;
        this.projectModel = null;
        this.directoryModel = null;
        this.url = url;
        this.primaryKey = Collator.getInstance().getCollationKey(this.element.getShortLabel());
        this.location = this.getLocation(0, Integer.MAX_VALUE);
    }

    protected ModelAdapter(ModelFactory factory, ModelType type, Workspace workspace, URL url) {
        this.factory = factory;
        this.type = type;
        this.element = workspace;
        this.workspaceModel = (ContainerModelAdapter)this;
        this.projectModel = null;
        this.directoryModel = null;
        this.url = url;
        this.primaryKey = Collator.getInstance().getCollationKey(workspace.getShortLabel());
        this.location = this.getLocation(0, Integer.MAX_VALUE);
    }

    protected ModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, Project project, URL url) {
        this.factory = factory;
        this.type = type;
        this.element = project;
        this.workspaceModel = workspace;
        this.projectModel = (ContainerModelAdapter)this;
        this.directoryModel = null;
        this.url = url;
        this.primaryKey = Collator.getInstance().getCollationKey(project.getShortLabel());
        this.location = this.getLocation(0, Integer.MAX_VALUE);
    }

    protected ModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, ContentDirectory element, URL url) {
        this.factory = factory;
        this.type = type;
        this.element = element;
        this.workspaceModel = workspace;
        this.projectModel = project;
        this.directoryModel = (ContainerModelAdapter)this;
        this.url = url;
        this.primaryKey = Collator.getInstance().getCollationKey(element.getShortLabel());
        this.location = this.getLocation(0, Integer.MAX_VALUE);
    }

    protected ModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, Node node, URL url) {
        this(factory, type, workspace, project, directory, node, url, URLFileSystem.getFileName((URL)url));
    }

    protected ModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, Node node, URL url, String primaryCollationString) {
        this.factory = factory;
        this.type = type;
        this.element = node;
        this.workspaceModel = workspace;
        this.projectModel = project;
        this.directoryModel = directory;
        this.url = url;
        this.primaryKey = Collator.getInstance().getCollationKey(primaryCollationString);
    }

    public ContentDirectory getDirectory() {
        return this.directoryModel != null ? this.directoryModel.getDirectory() : null;
    }

    public Element getElement() {
        return this.element;
    }

    public Location getEndLocation() {
        return this.getLocation(Integer.MAX_VALUE, 0);
    }

    public final ModelFactory getFactory() {
        return this.factory;
    }

    public Context getIdeContext() {
        if (this.ideContext == null) {
            Workspace workspace = this.getWorkspace();
            Project project = this.getProject();
            Node node = this.getNode();
            if (node == workspace) {
                project = null;
                workspace = null;
            } else if (node == project) {
                project = null;
            }
            Context context = new Context(workspace, project);
            context.setNode(node);
            context.setBoolean("Context.INTENTIONAL_NULL", true);
            this.ideContext = context;
        }
        return this.ideContext;
    }

    public int getInitialLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final Location getLocation() {
        if (this.location == null) {
            this.location = this.getLocation(0, Integer.MAX_VALUE);
        }
        return this.location;
    }

    public Location getLocation(int offset, int length) {
        if (offset <= Short.MAX_VALUE && length <= Short.MAX_VALUE) {
            return new LocationShort(this, (short)offset, (short)length);
        }
        return new LocationInt(this, offset, length);
    }

    public Node getNode() {
        return this.element instanceof Node ? (Node)this.element : null;
    }

    public Project getProject() {
        return this.projectModel != null ? this.projectModel.getProject() : null;
    }

    public String getShortLabel() {
        return this.primaryKey.getSourceString();
    }

    public String getSimpleName() {
        return URLFileSystem.getFileName((URL)this.getUrl());
    }

    public final ModelType getType() {
        return this.type;
    }

    public URL getUrl() {
        return this.url;
    }

    public final URL getURL() {
        return this.getUrl();
    }

    public Workspace getWorkspace() {
        return this.workspaceModel.getWorkspace();
    }

    public abstract boolean isFile();

    public boolean isModifiable() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isModified(Location location) {
        return false;
    }

    public final void beginRead() throws InterruptedException {
        this.beginRead(LockPolicy.DEFAULT);
    }

    public final void beginRead(LockPolicy policy) throws InterruptedException {
        LOG.trace("begin read on {0}", (Object)this);
        this.verifyModelAccess();
        this.acquireReadLock(policy);
        this.beginReadHook();
    }

    public final void endRead() {
        this.endRead(LockPolicy.DEFAULT);
    }

    public final void endRead(LockPolicy policy) {
        LOG.trace("end read on {0}", (Object)this);
        this.endReadHook();
        this.releaseReadLock(policy.getLockListener());
    }

    public void cancelRead() {
    }

    protected void acquireReadLock(LockPolicy policy) throws InterruptedException {
        this.acquireReadLock(policy.getLockListener(), policy.isRetryPreferred());
    }

    protected void acquireReadLock(WriteLockRequestListener listener, boolean retryPreferred) throws InterruptedException {
        this.acquireReadLock(listener);
    }

    protected void acquireReadLock(WriteLockRequestListener listener) throws InterruptedException {
    }

    protected void releaseReadLock(LockPolicy policy) {
        this.releaseReadLock(policy.getLockListener());
    }

    protected void releaseReadLock(WriteLockRequestListener listener) {
    }

    protected void beginReadHook() throws InterruptedException {
    }

    protected void endReadHook() {
    }

    protected synchronized ReadWriteLock getLock() {
        if (this.nodeLock == null) {
            Node node = this.getNode();
            if (node != null) {
                try {
                    if (lockMethod == null) {
                        lockMethod = Node.class.getDeclaredMethod("nodeLock", null);
                        lockMethod.setAccessible(true);
                    }
                    this.nodeLock = (ReadWriteLock)lockMethod.invoke((Object)node, (Object[])null);
                }
                catch (Throwable e) {
                    throw new UnexpectedExceptionError(e);
                }
            } else {
                this.nodeLock = new ReadWriteLock(this.primaryKey.getSourceString());
            }
        }
        return this.nodeLock;
    }

    protected boolean isReadLockHeld() {
        return this.nodeLock != null && this.nodeLock.isReadLockHeld();
    }

    protected boolean isWriteLockHeld() {
        return this.nodeLock != null && this.nodeLock.isWriteLockHeld();
    }

    public void verifyReadTransaction() {
    }

    public boolean isAccessible() {
        return !(this.element instanceof Node) || NodeFactory.find((URL)this.url) == this.element;
    }

    public void verifyModelAccess() {
        if (!this.isAccessible()) {
            throw this.createModelAccessError();
        }
    }

    public final ModelAccessError createModelAccessError() {
        return new ModelAccessError(this);
    }

    public final ModelAccessError createModelAccessError(Throwable cause) {
        return new ModelAccessError(this, cause);
    }

    public final ModelAccessError createModelAccessError(AuditContext context) {
        return new ModelAccessError(this, context);
    }

    public boolean isNavigable(Location location) {
        return this.getNavigationPoint(location) != null;
    }

    public NavigationPoint getNavigationPoint(Location location) {
        if (location.getModel() != this) {
            throw new IllegalArgumentException("location.getModel() != this");
        }
        return null;
    }

    public boolean edit(Location location) {
        NavigationPoint point = this.getNavigationPoint(location);
        if (point == null) {
            return false;
        }
        try {
            NavigationManager manager = NavigationManager.getNavigationManager();
            if (manager != null) {
                int status = manager.navigateTo(point);
                return status == 0;
            }
            return false;
        }
        catch (Exception e) {
            AuditLogger.log(Level.SEVERE, e, "Navigation to {0} failed: {1}", location, e);
            return false;
        }
    }

    public char getCharacter(int offset) {
        return '\u0000';
    }

    public int getColumnOffset(int offset) {
        return offset;
    }

    public Object getConstruct(Location location) {
        LOG.trace("getting construct for {0}", (Object)location);
        assert (this == location.getModel());
        if (location.isRoot()) {
            return this.getRoot();
        }
        Object containingConstruct = this.getRoot();
        block0: while (true) {
            Iterator i = this.getContainedConstructs(containingConstruct);
            while (i.hasNext()) {
                Object construct = i.next();
                if (!this.contains(construct, location)) continue;
                containingConstruct = construct;
                continue block0;
            }
            break;
        }
        return containingConstruct;
    }

    public Object getConstruct(Location location, Object parentConstruct) {
        LOG.trace("getting construct for {0} relative to {1}", (Object)location, parentConstruct);
        assert (this.contains(parentConstruct, location));
        Iterator i = this.getContainedConstructs(parentConstruct);
        while (i.hasNext()) {
            Object childConstruct = i.next();
            if (!this.contains(childConstruct, location)) continue;
            return childConstruct;
        }
        return null;
    }

    public abstract Iterator getContainedConstructs(Object var1);

    public Dependency getDependency() {
        return new NullDependency();
    }

    public abstract Location[] getElementLocations(Element var1);

    public Location getFocusLocation(Object construct, Location location) {
        assert (location != null);
        assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + this + " - " + location;
        assert (this == location.getModel());
        assert (location.isRoot() || location.equals(this.getLocation(construct))) : "location " + location + "; construct location " + this.getLocation(construct) + "; construct " + construct;
        this.verifyReadTransaction();
        return location;
    }

    public Location getFocusLocation(Location location) {
        return location;
    }

    public String getLine(int offset) {
        return null;
    }

    public int getLineOffset(int offset) {
        return 0;
    }

    public abstract Location getLocation(Object var1);

    public Object getRoot() {
        this.verifyReadTransaction();
        this.verifyModelAccess();
        try {
            Object root = this.getRootHook();
            if (root != null) {
                return root;
            }
            throw this.createModelAccessError();
        }
        catch (ExpiredTextBufferException e) {
            throw e;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (ModelAccessError e) {
            throw e;
        }
        catch (Exception e) {
            throw this.createModelAccessError(e);
        }
    }

    public abstract Object getRootHook() throws Exception;

    public String getText(int offset, int length) {
        return null;
    }

    public URL getUrl(Location location) {
        return this.getUrl();
    }

    public abstract Object getLabel(Object var1);

    public abstract Object getSummary(Object var1);

    public abstract Icon getIcon(Object var1);

    public Object getLabel(Location location) {
        return this.getLabel(location.getModel().getConstruct(location));
    }

    public Object getSummary(Location location) {
        return this.getSummary(location.getModel().getConstruct(location));
    }

    public Icon getIcon(Location location) {
        return this.getIcon(location.getModel().getConstruct(location));
    }

    public boolean equals(Object object) {
        assert (!(object instanceof ModelAdapter) || this.getFactory() == ((ModelAdapter)object).getFactory()) : "generation mismatch: " + this + " - " + object;
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public abstract int compareTo(ModelAdapter var1);

    protected static int compareSiblings(ModelAdapter d1, ModelAdapter d2) {
        int comparison;
        if (d1 == d2) {
            return 0;
        }
        if (d1 == null) {
            return -1;
        }
        if (d2 == null) {
            return 1;
        }
        assert (d1.getContainingAdapter() == d2.getContainingAdapter());
        if (d1.ordinal > 0 && d2.ordinal > 0) {
            comparison = d1.ordinal - d2.ordinal;
            if (comparison != 0) {
                return comparison;
            }
        } else {
            comparison = d1.getPrimaryCollationKey().compareTo(d2.getPrimaryCollationKey());
            if (comparison != 0) {
                return comparison;
            }
            comparison = d1.getSecondaryCollationKey().compareTo(d2.getSecondaryCollationKey());
        }
        if (comparison != 0) {
            return comparison;
        }
        comparison = d1.getClass().getName().compareTo(d2.getClass().getName());
        if (comparison != 0) {
            return comparison;
        }
        comparison = d1.hashCode() - d2.hashCode();
        return comparison;
    }

    public boolean contains(Location location) {
        ModelAdapter model = location.getModel();
        return this.contains(model);
    }

    public abstract boolean contains(ModelAdapter var1);

    public boolean contains(Object construct, Location location) {
        assert (location != null);
        assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + this + " - " + location;
        assert (this == location.getModel());
        this.verifyReadTransaction();
        return construct == this || this.getLocation(construct).contains(location);
    }

    protected static final boolean contains(int offset1, int length1, Location location2) {
        int offset2 = location2.getOffset();
        int length2 = location2.getLength();
        if (length1 <= 0 || length2 > 0 || location2.length() > 0) {
            return offset1 <= offset2 && offset1 + length1 >= offset2 + length2;
        }
        return offset1 < offset2 && offset1 + length1 > offset2;
    }

    protected String getSecondaryCollationString() {
        return URLFileSystem.getPlatformPathName((URL)this.getUrl());
    }

    public String toString() {
        return this.primaryKey.getSourceString();
    }

    protected final CollationKey getPrimaryCollationKey() {
        return this.primaryKey;
    }

    protected CollationKey getSecondaryCollationKey() {
        if (this.secondaryKey == null) {
            this.secondaryKey = Collator.getInstance().getCollationKey(this.getSecondaryCollationString());
        }
        return this.secondaryKey;
    }

    public ContainerModelAdapter getWorkspaceAdapter() {
        return this.workspaceModel;
    }

    public ContainerModelAdapter getProjectAdapter() {
        return this.projectModel;
    }

    public ContainerModelAdapter getDirectoryAdapter() {
        return this.directoryModel;
    }

    public FileModelAdapter getFileAdapter() {
        return null;
    }

    public abstract ContainerModelAdapter getContainingAdapter();

    public void setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public void release() {
    }

    public String contextDescription(Location location) {
        return location.toString();
    }

    public void enter(AuditContext context) {
    }

    public void exit(AuditContext context) {
    }

    static {
        LOG = new Log("node");
    }

    private class NullDependency
    extends Dependency {
        private NullDependency() {
        }

        @Override
        protected void attach() {
        }

        @Override
        protected void detach() {
        }

        @Override
        protected String getShortDescription() {
            return ModelAdapter.this.getShortLabel();
        }

        @Override
        protected String getLongDescription() {
            return ModelAdapter.this.getSecondaryCollationString();
        }
    }

    static class LocationShort
    extends Location {
        private final short offset;
        private final short length;

        LocationShort(ModelAdapter model, short offset, short length) {
            super(model);
            this.offset = offset;
            this.length = length;
        }

        @Override
        int offset() {
            return this.offset;
        }

        @Override
        int length() {
            return this.length;
        }
    }

    static class LocationInt
    extends Location {
        private final int offset;
        private final int length;

        LocationInt(ModelAdapter model, int offset, int length) {
            super(model);
            assert (offset == 0 || length < Integer.MAX_VALUE);
            this.offset = offset;
            this.length = length;
        }

        @Override
        int offset() {
            return this.offset;
        }

        @Override
        int length() {
            return this.length;
        }
    }
}

