/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdevimpl.audit.profile.ProfileBundle;

public class ProfileMigrator
implements Migrator,
URLFilter {
    private static final int AUDIT_PROFILE = 0;
    private boolean selected;

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        return "Audit Profiles";
    }

    public boolean isSelected(int category) {
        return category == 0 && this.selected;
    }

    public void setSelected(int category, boolean selected) {
        if (category == 0) {
            this.selected = selected;
        }
    }

    public boolean canMigrate(int category, File sourceSystemFile) {
        return category == 0 && URLFileSystem.exists((URL)this.sourceProfilesDirectory(sourceSystemFile));
    }

    private URL sourceProfilesDirectory(File sourceDirectory) {
        URL system = URLFactory.newDirURL((File)sourceDirectory.getParentFile());
        return URLFactory.newDirURL((URL)system, (String)"o.jdeveloper/audit/profiles");
    }

    public String[] migrate(File sourceSystemFile, File targetSystemFile) {
        if (!this.selected) {
            return new String[0];
        }
        URL sourceDirectory = this.sourceProfilesDirectory(sourceSystemFile);
        URL[] sourceProfiles = URLFileSystem.list((URL)sourceDirectory, (URLFilter)this);
        if (sourceProfiles == null || sourceProfiles.length == 0) {
            return new String[0];
        }
        URL targetDirectory = ProfileRepository.defaultIdeProfileDirectory();
        if (URLFileSystem.exists((URL)targetDirectory) || !URLFileSystem.mkdirs((URL)targetDirectory)) {
            return new String[0];
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (URL sourceProfile : sourceProfiles) {
            URL targetProfile = URLFactory.newURL((URL)targetDirectory, (String)URLFileSystem.getFileName((URL)sourceProfile));
            try {
                URLFileSystem.copy((URL)sourceProfile, (URL)targetProfile);
            }
            catch (IOException e) {
                String message = ProfileBundle.format("migrator.exception.message", URLFileSystem.getPlatformPathName((URL)sourceProfile), URLFileSystem.getPlatformPathName((URL)targetProfile), e.getMessage());
                errors.add(message);
            }
        }
        return errors.toArray(new String[errors.size()]);
    }

    public boolean accept(URL url) {
        return ".xml".equals(URLFileSystem.getSuffix((URL)url));
    }
}

