/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.treetable.AbstractTreeTableModel;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.debugger.support.DebuggerWindowColumnOptions;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.BaseElement;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerClassesWindowOptions;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ClassesWindowSettings;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.Utils;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

final class ClassesWindow
extends DebuggerWindow
implements TreeExpansionListener,
DragGestureListener,
DragSourceListener,
Controller,
ContextMenuListener,
ColumnMenuListener {
    private ClassTreeTableModel model;
    private JFastTreeTable treeTable;
    private JScrollPane scrollPane;
    private String title;
    private boolean skippedUpdate = true;
    private DebuggingProcess skippedUpdateDebuggingProcess;
    private DebugVirtualMachine skippedUpdateVirtualMachine;
    private DebuggingProcess debuggingProcess;
    private DebugVirtualMachine vm;
    private DebugClassLoaderInfo[] allClassLoaders;
    private PackageInfo[] allPackages;
    private ClassInfo[] allClasses;
    private boolean canCountObjects;
    private boolean canCountMemory;
    private List tracingIncludeList;
    private List tracingExcludeList;
    private ClassesWindowSettings classesSettings;
    private int preferredVisibleRowCount = 10;
    private static IdeAction actionGoTo;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionShowInHeap;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionFind;
    private static IdeAction actionFindNext;
    private static IdeAction actionExpandAll;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemGoTo;
    private static JMenuItem menuitemViewAnnotations;
    private static JMenuItem menuitemShowInHeap;
    private static JMenuItem menuitemWatchClassLoader;
    private static JMenuItem menuitemInspectClassLoader;
    private static JMenuItem menuitemFind;
    private static JMenuItem menuitemFindNext;
    private static JMenuItem menuitemExpandAll;
    private static JMenuItem menuitemCollapseAll;
    private static JMenuItem menuitemSave;
    private static JMenuItem menuitemSettings;
    private static int GOTO_CMD_ID;
    private static int VIEW_ANNOTATIONS_CMD_ID;
    private static int SHOW_IN_HEAP_CMD_ID;
    private static int WATCH_CLASSLOADER_CMD_ID;
    private static int INSPECT_CLASSLOADER_CMD_ID;
    private static int FIND_CMD_ID;
    private static int FIND_NEXT_CMD_ID;
    private static int EXPAND_ALL_CMD_ID;
    private static int COLLAPSE_ALL_CMD_ID;
    private static int SAVE_CMD_ID;
    private static int SETTINGS_CMD_ID;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_COUNT = 1;
    static final int COLUMN_MEMORY = 2;
    static final int COLUMN_FILENAME = 3;
    static final int NUMBER_OF_COLUMNS = 4;
    private DebuggerWindowOptions windowOptions;
    private TableColumn[] column = new TableColumn[4];
    private int[] columnDefaultWidth = new int[4];
    private boolean[] columnShowing = new boolean[4];
    private boolean[] columnNumeric = new boolean[4];
    private static DataFlavor classFlavor;
    private static DataFlavor interfaceFlavor;
    private static DataFlavor arrayFlavor;
    static final String CLASSES_WINDOW_ID = "Debugger.ClassesWindow";
    private static Icon packageIconGray;
    private static Icon classIconGray;
    private static Icon interfaceIconGray;
    private static Icon arrayIconGray;
    private static Icon classLoaderIcon;
    private static Icon arrowUpIcon;
    private static Icon arrowDownIcon;
    private static final String NOT_AVAILABLE = "";
    private boolean adjustColumnsAlreadyDone = false;

    ClassesWindow() {
        super(CLASSES_WINDOW_ID);
        this.title = DbgArb.getString(504);
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.EAST;
    }

    @Override
    public void refresh() {
        this.everythingChanged();
    }

    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.setNewVm(null);
    }

    private void setNewVm(DebugVirtualMachine newVM) {
        List<String> columnNames;
        String vmID;
        if (this.vm != null) {
            this.storeVmSettings(this.vm);
        }
        this.vm = newVM;
        if (this.classesSettings == null) {
            this.classesSettings = ClassesWindowSettings.getInstance();
        }
        this.windowOptions = null;
        if (newVM != null) {
            this.windowOptions = newVM.getDebuggerWindowOptions(DebuggerWindowOptions.WindowId.ClassesWindow);
            if (this.windowOptions == DebuggerWindowOptions.DEFAULT) {
                this.windowOptions = new DebuggerClassesWindowOptions(this.classesSettings);
            }
        }
        HashStructure hash = this.classesSettings.getHash();
        boolean forceWriteToSettings = false;
        if (newVM != null && (forceWriteToSettings || !WindowSettingsColumnManager.getVMNames(hash).contains(newVM.getID()))) {
            vmID = newVM.getID();
            WindowSettingsColumnManager.addVMName(hash, vmID);
            columnNames = new ArrayList<String>();
            ArrayList<String> columnNamesInPreferences = new ArrayList<String>();
            boolean alteredColumnOrder = false;
            ArrayList<Object> orderedColumns = new ArrayList<Object>();
            for (int i = 0; i < this.windowOptions.getNumberOfColumns(); ++i) {
                DebuggerWindowColumnOptions column = this.windowOptions.getColumnInfo(i);
                WindowSettingsColumnManager.setColumnVisible(hash, vmID, i, column.isVisibleByDefault());
                WindowSettingsColumnManager.setColumnNumeric(hash, vmID, i, column.isNumeric());
                columnNames.add(column.getColumnName());
                columnNamesInPreferences.add(column.getColumnNameInPrefencePane());
                if (column.getOrderInTable() != -1) {
                    alteredColumnOrder = true;
                    orderedColumns.set(column.getOrderInTable(), column);
                    continue;
                }
                orderedColumns.add(column);
            }
            WindowSettingsColumnManager.setColumnNames(hash, vmID, columnNames);
            WindowSettingsColumnManager.setColumnNamesInPreferences(hash, vmID, columnNamesInPreferences);
            if (alteredColumnOrder) {
                StringBuilder sb = new StringBuilder();
                for (DebuggerWindowColumnOptions debuggerWindowColumnOptions : orderedColumns) {
                    sb.append(debuggerWindowColumnOptions.getColumnName());
                    sb.append(",");
                }
                WindowSettingsColumnManager.setColumnOrder(hash, vmID, sb.toString());
            }
        }
        if (newVM != null) {
            int i;
            vmID = newVM.getID();
            columnNames = WindowSettingsColumnManager.getColumnNames(hash, vmID);
            for (i = 0; i < 4; ++i) {
                String columnName = columnNames.get(i);
                this.columnNumeric[i] = columnName != null ? WindowSettingsColumnManager.getColumnNumeric(hash, vmID, i) : false;
            }
            WindowSettingsColumnManager.setColumnNames(hash, vmID, columnNames);
            for (i = 0; i < columnNames.size(); ++i) {
                String columnName = columnNames.get(i);
                columnNames.set(i, StringUtils.stripMnemonic((String)columnName));
            }
            for (i = 0; i < this.windowOptions.getNumberOfColumns(); ++i) {
                this.column[i].setHeaderValue(columnNames.get(i));
            }
            this.treeTable.getTableHeader().repaint();
            this.classesWindowSettingsChanged(false);
            for (i = 0; i < this.windowOptions.getNumberOfColumns(); ++i) {
                int width = WindowSettingsColumnManager.getColumnWidth(hash, vmID, i);
                if (width > 0) {
                    this.adjustColumnsAlreadyDone = true;
                    this.column[i].setPreferredWidth(width);
                    continue;
                }
                this.column[i].setPreferredWidth(this.columnNumeric[i] ? 37 : 75);
            }
            TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
            String order = WindowSettingsColumnManager.getColumnOrder(hash, vmID);
            if (order != null) {
                for (int i2 = 0; i2 < this.windowOptions.getNumberOfColumns(); ++i2) {
                    String identifier;
                    int comma = order.indexOf(44);
                    if (comma != -1) {
                        identifier = order.substring(0, comma);
                        order = order.substring(comma + 1);
                    } else {
                        identifier = order;
                    }
                    if (identifier.length() == 0) break;
                    try {
                        int n = tableColumnModel.getColumnIndex(identifier);
                        if (n == i2) continue;
                        this.treeTable.moveColumn(n, i2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void storeVmSettings(DebugVirtualMachine vm) {
        HashStructure hash = this.classesSettings.getHash();
        for (int i = 0; i < 4; ++i) {
            WindowSettingsColumnManager.setColumnWidth(hash, vm.getID(), i, this.column[i].getWidth());
            WindowSettingsColumnManager.setColumnVisible(hash, vm.getID(), i, this.columnShowing[i]);
            WindowSettingsColumnManager.setColumnNumeric(hash, vm.getID(), i, this.columnNumeric[i]);
        }
        TableColumnModel tcModel = this.treeTable.getColumnModel();
        StringBuilder buf = new StringBuilder();
        Enumeration<TableColumn> e = tcModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            buf.append(column.getIdentifier());
            buf.append(',');
        }
        WindowSettingsColumnManager.setColumnOrder(hash, vm.getID(), buf.toString());
    }

    private boolean hasTreeStructure() {
        return this.classesSettings.isShowClassLoaders() || this.classesSettings.isShowPackages();
    }

    private void classesWindowSettingsChanged(boolean changed) {
        if (this.treeTable == null) {
            return;
        }
        this.treeTable.getTree().setShowsRootHandles(this.hasTreeStructure());
        if (this.vm != null) {
            for (int i = 0; i < 4; ++i) {
                boolean show = WindowSettingsColumnManager.getColumnVisible(this.classesSettings.getHash(), this.vm.getID(), i);
                if (this.columnShowing[i] == show) continue;
                this.columnShowing[i] = show;
                if (show) {
                    this.treeTable.addColumn(this.column[i]);
                    continue;
                }
                this.treeTable.removeColumn(this.column[i]);
            }
        }
        if (changed && this.treeTable.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassesWindow.this.everythingChanged();
                }
            });
        }
        Dimension d = this.treeTable.getPreferredSize();
        d.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(d);
    }

    private void fixSort() {
        if (this.classesSettings.getSortColumn() == 1 && !this.canCountObjects || this.classesSettings.getSortColumn() == 2 && !this.canCountMemory || !WindowSettingsColumnManager.getColumnVisible(this.classesSettings.getHash(), this.vm.getID(), this.classesSettings.getSortColumn())) {
            this.classesSettings.setSortColumn(0);
            this.classesSettings.setSortAscending(true);
        }
    }

    void tracingChanged() {
        if (this.debuggingProcess != null) {
            DebugConfiguration debugConfiguration = this.debuggingProcess.getDebugConfiguration();
            this.tracingIncludeList = debugConfiguration.getTracingIncludeList();
            this.tracingExcludeList = debugConfiguration.getTracingExcludeList();
            if (this.model != null) {
                this.model.resetIcons();
            }
        }
    }

    public Component getGUI() {
        if (this.scrollPane == null) {
            GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesGoTo");
            VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesViewAnnotations");
            SHOW_IN_HEAP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesShowInHeap");
            WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesWatchClassLoader");
            INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesInspectClassLoader");
            FIND_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesFind");
            FIND_NEXT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesFindNext");
            EXPAND_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesExpandAll");
            COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesCollapseAll");
            SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesSave");
            SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesSettings");
            ClassesWindow.makeActions();
            this.setControllerForActions();
            this.classesSettings = ClassesWindowSettings.getInstance();
            this.createGUI();
            DebuggingProcess currentDP = JDebugger.getInstance().getActiveDebuggingProcess();
            this.setNewVm(currentDP == null ? null : currentDP.getVM());
            this.tracingChanged();
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.classesSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    if (Utils.structureReallyChanged(e)) {
                        ClassesWindow.this.classesWindowSettingsChanged(true);
                    }
                }
            });
            JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        }
        return this.scrollPane;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_classwindow_html");
    }

    public Controller getController() {
        return this;
    }

    public Context getContext(EventObject event) {
        Object info;
        ClassTreeTableModel.ClassItem classItem = this.model != null ? this.model.getSelectedClassItem() : null;
        JDIInformationProvider jdiInformationProvider = null;
        if (classItem != null && (info = classItem.getInfo()) instanceof JDIInformationProvider) {
            jdiInformationProvider = (JDIInformationProvider)info;
        }
        return ContextBuilder.buildContext((Element)classItem, (View)this, event, this.debuggingProcess, jdiInformationProvider);
    }

    public int getDefaultVisibility(Layout layout) {
        if (this.windowOptions != null && this.windowOptions.isInitiallyVisible()) {
            return 1;
        }
        return 0;
    }

    public String getTabName() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTabName();
        }
        return this.title;
    }

    public Icon getTabIcon() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTabIcon();
        }
        return OracleIcons.getIcon((String)"class.png");
    }

    public String getTitleName() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTitleName();
        }
        return this.title;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.model.branchExpanded(event.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.model.branchCollapsed(event.getPath());
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point pt;
        ClassTreeTableModel.ClassItem classItem;
        if (e.getDragAction() == 1 && (classItem = this.model.getClassItemAtPoint(pt = e.getDragOrigin())).canDrag()) {
            try {
                BufferedImage dragImage = new BufferedImage(1, 1, 6);
                dragImage.setRGB(0, 0, -16777216);
                Point imageOffset = new Point(0, 0);
                e.startDrag(null, dragImage, imageOffset, classItem, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == GOTO_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.showSource();
            }
            return true;
        }
        if (cmdId == VIEW_ANNOTATIONS_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.viewAnnotations();
            }
            return true;
        }
        if (cmdId == SHOW_IN_HEAP_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.showInHeap();
            }
            return true;
        }
        if (cmdId == WATCH_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.watchClassLoader();
            }
            return true;
        }
        if (cmdId == INSPECT_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.inspectClassLoader();
            }
            return true;
        }
        if (cmdId == FIND_CMD_ID) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), "Not Implemented Yet", "Find", 1);
            return true;
        }
        if (cmdId == FIND_NEXT_CMD_ID) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), "Not Implemented Yet", "Find Next", 1);
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(621), DbgArb.getString(698)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        if (cmdId == EXPAND_ALL_CMD_ID) {
            this.model.expandAll();
            return true;
        }
        if (cmdId == COLLAPSE_ALL_CMD_ID) {
            this.model.collapseAll();
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null && (column = this.treeTable.getSelectedColumn()) != -1 && (o = this.model.getValueAt(classItem, column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == GOTO_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                action.setEnabled(classItem.canShowSource());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == VIEW_ANNOTATIONS_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                action.setEnabled(classItem.canViewAnnotations());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == SHOW_IN_HEAP_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                action.setEnabled(classItem.canShowInHeap());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == WATCH_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                action.setEnabled(classItem.canWatchInspectClassLoader());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == INSPECT_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                action.setEnabled(classItem.canWatchInspectClassLoader());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == FIND_CMD_ID) {
            action.setEnabled(false);
            return true;
        }
        if (cmdId == FIND_NEXT_CMD_ID) {
            action.setEnabled(false);
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == EXPAND_ALL_CMD_ID || cmdId == COLLAPSE_ALL_CMD_ID) {
            action.setEnabled(this.hasTreeStructure());
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            int column = this.treeTable.getSelectedColumn();
            action.setEnabled(classItem != null && column != -1);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.treeTable != null && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                this.addPopupMenuItemsForClassItem(popup, context);
            }
            this.addPopupMenuItemsForClasses(popup, context);
            this.addPopupMenuItemsForTreeTable(popup, context);
            this.addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private Comparator<DebugClassLoaderInfo> getComparatorForClassLoaders() {
        this.fixSort();
        return new Comparator<DebugClassLoaderInfo>(){

            @Override
            public int compare(DebugClassLoaderInfo classLoader1, DebugClassLoaderInfo classLoader2) {
                int sortColumn = ClassesWindow.this.classesSettings.getSortColumn();
                boolean sortAscending = ClassesWindow.this.classesSettings.isSortAscending();
                if (ModelUtil.areEqual((Object)classLoader1.getClassName(), (Object)classLoader2.getClassName())) {
                    int id1 = classLoader1.getId();
                    int id2 = classLoader2.getId();
                    if (sortColumn != 0 || sortAscending) {
                        return id1 - id2;
                    }
                    return id2 - id1;
                }
                String name1 = ClassesWindow.makeClassLoaderName(classLoader1);
                String name2 = ClassesWindow.makeClassLoaderName(classLoader2);
                if (sortColumn != 0 || sortAscending) {
                    return name1.compareToIgnoreCase(name2);
                }
                return name2.compareToIgnoreCase(name1);
            }
        };
    }

    private Comparator<PackageInfo> getComparatorForPackages() {
        this.fixSort();
        return new Comparator<PackageInfo>(){

            @Override
            public int compare(PackageInfo pi1, PackageInfo pi2) {
                int sortColumn = ClassesWindow.this.classesSettings.getSortColumn();
                boolean sortAscending = ClassesWindow.this.classesSettings.isSortAscending();
                String name1 = pi1.pkg;
                String name2 = pi2.pkg;
                if (sortColumn != 0 || sortAscending) {
                    return name1.compareToIgnoreCase(name2);
                }
                return name2.compareToIgnoreCase(name1);
            }
        };
    }

    private Comparator<ClassInfo> getComparatorForClasses() {
        this.fixSort();
        return new Comparator<ClassInfo>(){

            @Override
            public int compare(ClassInfo class1, ClassInfo class2) {
                int sortColumn = ClassesWindow.this.classesSettings.getSortColumn();
                boolean sortAscending = ClassesWindow.this.classesSettings.isSortAscending();
                switch (sortColumn) {
                    default: {
                        String name1 = class1.getCourtesyClassName(true);
                        String name2 = class2.getCourtesyClassName(true);
                        if (sortAscending) {
                            return name1.compareToIgnoreCase(name2);
                        }
                        return name2.compareToIgnoreCase(name1);
                    }
                    case 1: {
                        if (sortAscending) {
                            return new Long(class1.objectCount - class2.objectCount).intValue();
                        }
                        return new Long(class2.objectCount - class1.objectCount).intValue();
                    }
                    case 2: {
                        if (sortAscending) {
                            return class1.getMemory() - class2.getMemory();
                        }
                        return class2.getMemory() - class1.getMemory();
                    }
                    case 3: 
                }
                if (sortAscending) {
                    return class1.getPrimarySourceFilename().compareToIgnoreCase(class2.getPrimarySourceFilename());
                }
                return class2.getPrimarySourceFilename().compareToIgnoreCase(class1.getPrimarySourceFilename());
            }
        };
    }

    @Override
    public void showColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = true;
            if (this.classesSettings != null) {
                WindowSettingsColumnManager.setColumnVisible(this.classesSettings.getHash(), this.vm.getID(), index, true);
            }
            this.treeTable.addColumn(this.column[index]);
        }
    }

    @Override
    public void hideColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = false;
            if (this.classesSettings != null) {
                WindowSettingsColumnManager.setColumnVisible(this.classesSettings.getHash(), this.vm.getID(), index, true);
                this.fixSort();
            }
            this.treeTable.getTableHeader().setDraggedColumn(null);
            this.treeTable.removeColumn(this.column[index]);
        }
    }

    private void createGUI() {
        List<ClassTreeTableModel.ClassItem> modelRoot = Collections.synchronizedList(new ArrayList());
        this.model = new ClassTreeTableModel(modelRoot);
        this.treeTable = new JFastTreeTable((TreeTableModel)this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.getTitleName());
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, emptySet);
        this.treeTable.setFocusTraversalKeys(1, emptySet);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        for (int i = 0; i < 4; ++i) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
        }
        boolean[] showColumnInMenu = new boolean[4];
        Arrays.fill(showColumnInMenu, true);
        showColumnInMenu[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, showColumnInMenu);
        ListSelectionModel listSelectionModel = this.treeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JTree tree = this.treeTable.getTree();
        tree.setRootVisible(false);
        TreeSelectionModel treeSelectionModel = tree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        tree.addTreeExpansionListener(this);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof ClassTreeTableModel.ClassItem) {
                    String accessibleDescription;
                    ClassTreeTableModel.ClassItem classItem = (ClassTreeTableModel.ClassItem)value;
                    this.setIcon(classItem.getIcon());
                    String tooltip = classItem.getNameToolTip();
                    if (tooltip != null) {
                        this.setToolTipText(tooltip);
                    }
                    AccessibleContext ac = this.getAccessibleContext();
                    String accessibleName = ClassesWindow.this.model.getAccessibleNameAt(classItem, 0);
                    if (classItem.mayHaveChildren()) {
                        accessibleName = JDebugger.fixTreeCellAccessibleName(accessibleName, expanded);
                    }
                    if (accessibleName != null) {
                        ac.setAccessibleName(accessibleName);
                    }
                    if ((accessibleDescription = tooltip) != null) {
                        ac.setAccessibleDescription(accessibleDescription);
                    }
                } else {
                    this.setIcon(null);
                    this.setToolTipText(null);
                }
                return this;
            }
        });
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String accessibleDescription;
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                int modelColumn = table.convertColumnIndexToModel(column);
                int horizontalAlignment = 2;
                if (modelColumn == 1 || modelColumn == 2) {
                    horizontalAlignment = 4;
                }
                this.setHorizontalAlignment(horizontalAlignment);
                String tooltip = value instanceof String ? (String)value : null;
                this.setToolTipText(tooltip);
                ClassTreeTableModel.ClassItem classItem = ClassesWindow.this.model.getClassItemForTreePath(ClassesWindow.this.treeTable.getTree().getPathForRow(row));
                AccessibleContext ac = this.getAccessibleContext();
                String accessibleName = ClassesWindow.this.model.getAccessibleNameAt(classItem, modelColumn);
                if (accessibleName != null) {
                    ac.setAccessibleName(accessibleName);
                }
                if ((accessibleDescription = tooltip) != null) {
                    ac.setAccessibleDescription(accessibleDescription);
                }
                return this;
            }
        });
        JTableHeader tableHeader = this.treeTable.getTableHeader();
        final TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (headerRenderer instanceof DefaultTableCellRenderer) {
                    DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)headerRenderer;
                    int modelColumn = table.convertColumnIndexToModel(column);
                    int horizontalAlignment = 2;
                    if (modelColumn == 1 || modelColumn == 2) {
                        horizontalAlignment = 4;
                    }
                    defaultTableCellRenderer.setHorizontalAlignment(horizontalAlignment);
                    Icon icon = null;
                    if (modelColumn == ClassesWindow.this.classesSettings.getSortColumn()) {
                        icon = ClassesWindow.this.classesSettings.isSortAscending() ? ClassesWindow.getArrowUpIcon() : ClassesWindow.getArrowDownIcon();
                    }
                    defaultTableCellRenderer.setIcon(icon);
                }
                return headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ClassesWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ClassesWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ClassesWindow.this.debuggingProcess == null || !ClassesWindow.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(309, ClassesWindow.this.getTitleName()));
                }
                if (JDebugger.isDoubleClickInTreeTable(ClassesWindow.this.treeTable, e)) {
                    Context context = ClassesWindow.this.getContext(e);
                    ClassesWindow.this.update(actionGoTo, context);
                    if (actionGoTo.isEnabled()) {
                        ClassesWindow.this.handleEvent(actionGoTo, context);
                    }
                }
            }
        });
        this.treeTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 10: {
                        Context context = ClassesWindow.this.getContext(e);
                        ClassesWindow.this.update(actionGoTo, context);
                        if (!actionGoTo.isEnabled()) break;
                        ClassesWindow.this.handleEvent(actionGoTo, context);
                        e.consume();
                    }
                }
            }
        });
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color background = this.treeTable.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ClassesWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ClassesWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ClassesWindow.this.debuggingProcess == null || !ClassesWindow.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(309, ClassesWindow.this.getTitleName()));
                }
            }
        });
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ClassesWindow.this.adjustColumnsAfterResize();
            }
        });
        this.treeTable.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ClassesWindow.this.treeTable.isShowing()) {
                    ClassesWindow.this.nowShown();
                }
            }
        });
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.treeTable, 1, this);
        tableHeader.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                if (ClassesWindow.this.debuggingProcess == null || !ClassesWindow.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(309, ClassesWindow.this.getTitleName()));
                }
                if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 1) {
                    int columnAtX = ClassesWindow.this.treeTable.getColumnModel().getColumnIndexAtX(e.getX());
                    int column = ClassesWindow.this.treeTable.convertColumnIndexToModel(columnAtX);
                    if (column != -1) {
                        if (ClassesWindow.this.classesSettings.getSortColumn() == column) {
                            ClassesWindow.this.classesSettings.toggleSortAscending();
                        } else {
                            ClassesWindow.this.classesSettings.setSortColumn(column);
                            if (column == 0) {
                                ClassesWindow.this.classesSettings.setSortAscending(true);
                            } else {
                                ClassesWindow.this.classesSettings.setSortAscending(false);
                            }
                        }
                        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
                        wc.show();
                        try {
                            ClassesWindow.this.everythingChanged();
                        }
                        finally {
                            wc.hide();
                        }
                    }
                }
            }
        });
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.findOrCreate((int)GOTO_CMD_ID, null, (String)DbgArb.getString(525), null, (Integer)DbgArb.getInteger(526), null, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionViewAnnotations = IdeAction.findOrCreate((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(527), null, (Integer)DbgArb.getInteger(528), null, null, (boolean)false);
            actionViewAnnotations.setEnabled(false);
            actionShowInHeap = IdeAction.findOrCreate((int)SHOW_IN_HEAP_CMD_ID, null, (String)DbgArb.getString(533), null, (Integer)DbgArb.getInteger(534), null, null, (boolean)false);
            actionShowInHeap.setEnabled(false);
            actionWatchClassLoader = IdeAction.findOrCreate((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(535), null, (Integer)DbgArb.getInteger(536), null, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.findOrCreate((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(537), null, (Integer)DbgArb.getInteger(538), null, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionFind = IdeAction.findOrCreate((int)FIND_CMD_ID, null, (String)DbgArb.getString(529), null, (Integer)DbgArb.getInteger(530), null, null, (boolean)false);
            actionFind.setEnabled(false);
            actionFindNext = IdeAction.findOrCreate((int)FIND_NEXT_CMD_ID, null, (String)DbgArb.getString(531), null, (Integer)DbgArb.getInteger(532), null, null, (boolean)false);
            actionFindNext.setEnabled(false);
            actionSettings = IdeAction.findOrCreate((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), null, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionExpandAll = IdeAction.findOrCreate((int)EXPAND_ALL_CMD_ID, null, (String)RunMgrArb.getString(92), null, (Integer)RunMgrArb.getInteger(93), null, null, (boolean)false);
            actionExpandAll.setEnabled(false);
            actionCollapseAll = IdeAction.findOrCreate((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(94), null, (Integer)RunMgrArb.getInteger(95), null, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.findOrCreate((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), null, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionGoTo, actionViewAnnotations, actionShowInHeap, actionWatchClassLoader, actionInspectClassLoader, actionFind, actionFindNext, actionSettings, actionExpandAll, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this);
    }

    private void addPopupMenuItemsForClassItem(ContextMenu popup, Context context) {
        this.update(actionGoTo, context);
        if (actionGoTo.isEnabled()) {
            if (menuitemGoTo == null) {
                menuitemGoTo = popup.createMenuItem((ToggleAction)actionGoTo);
            }
            popup.add((Component)menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(actionViewAnnotations, context);
        if (actionViewAnnotations.isEnabled()) {
            if (menuitemViewAnnotations == null) {
                menuitemViewAnnotations = popup.createMenuItem((ToggleAction)actionViewAnnotations);
            }
            popup.add((Component)menuitemViewAnnotations, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionShowInHeap, context);
        if (actionShowInHeap.isEnabled()) {
            if (menuitemShowInHeap == null) {
                menuitemShowInHeap = popup.createMenuItem((ToggleAction)actionShowInHeap);
            }
            popup.add((Component)menuitemShowInHeap, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionWatchClassLoader, context);
        if (actionWatchClassLoader.isEnabled()) {
            if (menuitemWatchClassLoader == null) {
                menuitemWatchClassLoader = popup.createMenuItem((ToggleAction)actionWatchClassLoader);
            }
            popup.add((Component)menuitemWatchClassLoader, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionInspectClassLoader, context);
        if (actionInspectClassLoader.isEnabled()) {
            if (menuitemInspectClassLoader == null) {
                menuitemInspectClassLoader = popup.createMenuItem((ToggleAction)actionInspectClassLoader);
            }
            popup.add((Component)menuitemInspectClassLoader, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForClasses(ContextMenu popup, Context context) {
        this.update(actionFind, context);
        if (actionFind.isEnabled()) {
            if (menuitemFind == null) {
                menuitemFind = popup.createMenuItem((ToggleAction)actionFind);
            }
            popup.add((Component)menuitemFind, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(actionFindNext, context);
        if (actionFindNext.isEnabled()) {
            if (menuitemFindNext == null) {
                menuitemFindNext = popup.createMenuItem((ToggleAction)actionFindNext);
            }
            popup.add((Component)menuitemFindNext, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_SPECIFIC_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
        this.update(actionExpandAll, context);
        if (actionExpandAll.isEnabled()) {
            if (menuitemExpandAll == null) {
                menuitemExpandAll = popup.createMenuItem((ToggleAction)actionExpandAll);
            }
            popup.add((Component)menuitemExpandAll, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_TREE_CTXT_MENU);
        }
        this.update(actionCollapseAll, context);
        if (actionCollapseAll.isEnabled()) {
            if (menuitemCollapseAll == null) {
                menuitemCollapseAll = popup.createMenuItem((ToggleAction)actionCollapseAll);
            }
            popup.add((Component)menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_TREE_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(actionSave, context);
        if (actionSave.isEnabled()) {
            if (menuitemSave == null) {
                menuitemSave = popup.createMenuItem((ToggleAction)actionSave);
            }
            popup.add((Component)menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_COMMON_CTXT_MENU);
        }
        this.update(actionSettings, context);
        if (actionSettings.isEnabled()) {
            if (menuitemSettings == null) {
                menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
            }
            popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_COMMON_CTXT_MENU);
        }
    }

    void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, (DockableWindow)this, this.treeTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        URL url;
        String dlgTitle = RunMgrArb.format(100, this.getTitleName());
        URLChooser chooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        chooser.setHelpID("f1_deb_exportdialog_html");
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
            wc.show();
            Exception exceptionOccurred = null;
            try {
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter out = html ? JDebugger.printHtmlHeader(url, this.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                this.model.save(out, html);
                if (html) {
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            finally {
                wc.hide();
            }
            if (exceptionOccurred != null) {
                String message = DbgArb.format(771, this.getTitleName(), URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
            }
        }
    }

    private void nowShown() {
        if (this.skippedUpdate && this.treeTable.isEnabled()) {
            this.updateClasses(this.skippedUpdateDebuggingProcess, this.skippedUpdateVirtualMachine);
        }
    }

    void everythingChanged() {
        if (this.model != null) {
            this.model.updateClasses();
        }
    }

    void updateClasses(DebuggingProcess debuggingProcess, DebugVirtualMachine vm) {
        boolean showing;
        if (this.treeTable != null) {
            this.treeTable.setEnabled(true);
        }
        boolean bl = showing = this.treeTable != null && this.treeTable.isShowing();
        if (!showing) {
            this.skippedUpdate = true;
            this.skippedUpdateDebuggingProcess = debuggingProcess;
            this.skippedUpdateVirtualMachine = vm;
            return;
        }
        this.debuggingProcess = debuggingProcess;
        if (debuggingProcess != null) {
            DebugConfiguration debugConfiguration = debuggingProcess.getDebugConfiguration();
            this.tracingIncludeList = debugConfiguration.getTracingIncludeList();
            this.tracingExcludeList = debugConfiguration.getTracingExcludeList();
        }
        if (this.treeTable != null) {
            this.setNewVm(vm);
        }
        if (vm != null) {
            DebugCapabilities capabilities = vm.getCapabilities();
            this.canCountObjects = capabilities.canCountObjectsOfClass();
            this.canCountMemory = capabilities.canCountMemoryOfClass();
        } else {
            this.canCountObjects = false;
            this.canCountMemory = false;
        }
        if (this.treeTable != null) {
            this.treeTable.setEnabled(true);
            this.everythingChanged();
        }
    }

    static String makeClassLoaderName(DebugClassLoaderInfo classLoader) {
        String clName = classLoader.getClassName();
        clName = clName != null ? DbgArb.format(513, clName, Integer.toString(classLoader.getId())) : DbgArb.getString(514);
        return clName;
    }

    void clearClasses() {
        if (this.treeTable == null) {
            return;
        }
        this.treeTable.setEnabled(false);
        this.model.clearClasses();
        this.setNewVm(null);
        this.allClassLoaders = null;
        this.allPackages = null;
        this.allClasses = null;
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.model != null) {
            this.model.processFinished(debuggingProcess);
        }
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.vm = null;
            this.allClassLoaders = null;
            this.allPackages = null;
            this.allClasses = null;
            if (this.treeTable != null) {
                this.treeTable.setEnabled(true);
                this.everythingChanged();
            }
        }
    }

    private static Icon getClassLoaderIcon() {
        if (classLoaderIcon == null) {
            classLoaderIcon = OracleIcons.getIcon((String)"debugger/staticfolder.gif");
        }
        return classLoaderIcon;
    }

    private static Icon getPackageIcon() {
        return OracleIcons.getIcon((String)"package.png");
    }

    private static Icon getPackageIconGray() {
        if (packageIconGray == null) {
            packageIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getPackageIcon());
        }
        return packageIconGray;
    }

    static Icon getClassIcon() {
        return OracleIcons.getIcon((String)"class.png");
    }

    private static Icon getClassIconGray() {
        if (classIconGray == null) {
            classIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getClassIcon());
        }
        return classIconGray;
    }

    private static Icon getClassObfuscatedIcon() {
        return OracleIcons.getIcon((String)"debugger/classobf.png");
    }

    static Icon getInterfaceIcon() {
        return OracleIcons.getIcon((String)"interface.png");
    }

    private static Icon getInterfaceIconGray() {
        if (interfaceIconGray == null) {
            interfaceIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getInterfaceIcon());
        }
        return interfaceIconGray;
    }

    private static Icon getArrayIcon() {
        return OracleIcons.getIcon((String)"debugger/array.gif");
    }

    private static Icon getArrayIconGray() {
        if (arrayIconGray == null) {
            arrayIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getArrayIcon());
        }
        return arrayIconGray;
    }

    private static Icon getArrowUpIcon() {
        if (arrowUpIcon == null) {
            arrowUpIcon = Helpers.getUpArrowIcon();
        }
        return arrowUpIcon;
    }

    private static Icon getArrowDownIcon() {
        if (arrowDownIcon == null) {
            arrowDownIcon = Helpers.getDownArrowIcon();
        }
        return arrowDownIcon;
    }

    static DataFlavor getClassFlavor() {
        if (classFlavor == null) {
            classFlavor = new DataFlavor(ClassFlavorData.class, "ClassFlavor");
        }
        return classFlavor;
    }

    static DataFlavor getInterfaceFlavor() {
        if (interfaceFlavor == null) {
            interfaceFlavor = new DataFlavor(InterfaceFlavorData.class, "InterfaceFlavor");
        }
        return interfaceFlavor;
    }

    static DataFlavor getArrayFlavor() {
        if (arrayFlavor == null) {
            arrayFlavor = new DataFlavor(ArrayFlavorData.class, "ArrayFlavor");
        }
        return arrayFlavor;
    }

    static /* synthetic */ DebugClassLoaderInfo[] access$1802(ClassesWindow x0, DebugClassLoaderInfo[] x1) {
        x0.allClassLoaders = x1;
        return x1;
    }

    static /* synthetic */ PackageInfo[] access$1902(ClassesWindow x0, PackageInfo[] x1) {
        x0.allPackages = x1;
        return x1;
    }

    static /* synthetic */ ClassInfo[] access$2002(ClassesWindow x0, ClassInfo[] x1) {
        x0.allClasses = x1;
        return x1;
    }

    static {
        classFlavor = null;
        interfaceFlavor = null;
        arrayFlavor = null;
        packageIconGray = null;
        classIconGray = null;
        interfaceIconGray = null;
        arrayIconGray = null;
        classLoaderIcon = null;
        arrowUpIcon = null;
        arrowDownIcon = null;
    }

    static class ClassInfo {
        DebugClassInfo debugClassInfo;
        private long objectCount;
        private String courtesyClassNameWithPackage;
        private String courtesyClassNameNoPackage;
        private int memory;

        ClassInfo(DebugClassInfo debugClassInfo) {
            this.debugClassInfo = debugClassInfo;
            this.memory = Integer.MAX_VALUE;
        }

        String getCourtesyClassName(boolean showPackage) {
            if (showPackage) {
                if (this.courtesyClassNameWithPackage == null) {
                    this.courtesyClassNameWithPackage = DebugShared.makeCourtesyClassName(this.debugClassInfo, true);
                }
                return this.courtesyClassNameWithPackage;
            }
            if (this.courtesyClassNameNoPackage == null) {
                this.courtesyClassNameNoPackage = DebugShared.makeCourtesyClassName(this.debugClassInfo, false);
            }
            return this.courtesyClassNameNoPackage;
        }

        int getMemory() {
            if (this.memory == Integer.MAX_VALUE) {
                this.memory = this.debugClassInfo.isInterface() ? 0 : this.debugClassInfo.countMemoryOfClass();
            }
            return this.memory;
        }

        String getPrimarySourceFilename() {
            return this.debugClassInfo.getPrimarySourceFilename();
        }

        long getCount() {
            return this.objectCount;
        }

        void setCount(long count) {
            this.objectCount = count;
        }

        int countAnnotations() {
            if (this.debugClassInfo instanceof DebugHasAnnotations) {
                return ((DebugHasAnnotations)((Object)this.debugClassInfo)).countAnnotations();
            }
            return 0;
        }

        DebugAnnotationInfo[] getAnnotations() {
            if (this.debugClassInfo instanceof DebugHasAnnotations) {
                return ((DebugHasAnnotations)((Object)this.debugClassInfo)).getAnnotations();
            }
            return null;
        }

        boolean isObject() {
            return this.debugClassInfo.isObject();
        }

        boolean isArray() {
            return this.debugClassInfo.isArray();
        }

        String getName() {
            return this.debugClassInfo.getName();
        }

        boolean isInterface() {
            return this.debugClassInfo.isInterface();
        }

        DebugClassLoaderInfo getClassLoader() {
            return this.debugClassInfo.getClassLoader();
        }
    }

    class PackageInfo {
        final String pkg;
        final DebugClassLoaderInfo classLoader;
        private int hashCode;

        PackageInfo(ClassInfo clazz) {
            this(DebugShared.makeCourtesyPackage(clazz.debugClassInfo), this$0.classesSettings.isShowClassLoaders() ? clazz.getClassLoader() : null);
        }

        PackageInfo(String pkg, DebugClassLoaderInfo classLoader) {
            this.pkg = pkg;
            this.classLoader = classLoader;
        }

        PackageInfo getParentPackageInfo() {
            int lastDot = this.pkg.lastIndexOf(46);
            if (lastDot != -1) {
                String parentPkg = this.pkg.substring(0, lastDot);
                return new PackageInfo(parentPkg, this.classLoader);
            }
            return null;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode += this.pkg.hashCode();
                if (this.classLoader != null) {
                    this.hashCode += this.classLoader.hashCode();
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof PackageInfo) {
                PackageInfo other = (PackageInfo)o;
                return this.pkg.equals(other.pkg) && this.classLoader == other.classLoader;
            }
            return false;
        }
    }

    private static class ArrayFlavorData
    extends ClassFlavorData {
        private ArrayFlavorData(Object info) {
            super(info);
        }
    }

    private static class InterfaceFlavorData
    extends ClassFlavorData {
        private InterfaceFlavorData(Object info) {
            super(info);
        }
    }

    static class ClassFlavorData {
        private String name;

        private ClassFlavorData(Object info) {
            this.name = info instanceof ClassInfo ? ((ClassInfo)info).getName() : info.toString();
        }

        String getName() {
            return this.name;
        }
    }

    private final class ClassInfoPath {
        private final DebuggingProcess debuggingProcess;
        private final Object[] classInfoArray;

        ClassInfoPath(DebuggingProcess debuggingProcess, Object[] classInfoArray) {
            this.debuggingProcess = debuggingProcess;
            this.classInfoArray = classInfoArray;
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        int size() {
            return this.classInfoArray.length;
        }

        Object getClassInfo(int index) {
            return this.classInfoArray[index];
        }

        ClassInfoPath updateClassInfoPath() {
            ArrayList<Object> temp = new ArrayList<Object>();
            int size = this.classInfoArray.length;
            if (size > 0) {
                boolean showClassLoaders = ClassesWindow.this.classesSettings.isShowClassLoaders();
                boolean showClassLoadersAsTree = ClassesWindow.this.classesSettings.isShowClassLoadersAsTree();
                boolean showPackages = ClassesWindow.this.classesSettings.isShowPackages();
                boolean showPackagesAsTree = ClassesWindow.this.classesSettings.isShowPackagesAsTree();
                Object info = this.classInfoArray[size - 1];
                while (info != null) {
                    PackageInfo piParent;
                    if (info instanceof DebugClassLoaderInfo && showClassLoaders || info instanceof PackageInfo && showPackages || info instanceof ClassInfo) {
                        temp.add(0, info);
                    }
                    Object parent = null;
                    if (info instanceof DebugClassLoaderInfo) {
                        parent = showClassLoadersAsTree ? ((DebugClassLoaderInfo)info).getParent() : null;
                    } else if (info instanceof PackageInfo) {
                        if (showPackagesAsTree) {
                            piParent = ((PackageInfo)info).getParentPackageInfo();
                            if (piParent != null) {
                                parent = piParent;
                            } else if (showClassLoaders) {
                                parent = ((PackageInfo)info).classLoader;
                            }
                        } else if (showClassLoaders) {
                            parent = ((PackageInfo)info).classLoader;
                        }
                    } else if (info instanceof ClassInfo) {
                        if (showPackages) {
                            piParent = new PackageInfo((ClassInfo)info);
                            if (piParent.pkg.length() != 0) {
                                parent = piParent;
                            } else if (showClassLoaders) {
                                parent = ((ClassInfo)info).getClassLoader();
                            }
                        } else if (showClassLoaders) {
                            parent = ((ClassInfo)info).getClassLoader();
                        }
                    }
                    info = parent;
                }
            }
            temp.add(0, null);
            Object[] array = temp.toArray(new Object[temp.size()]);
            return new ClassInfoPath(this.debuggingProcess, array);
        }

        public int hashCode() {
            return this.debuggingProcess.hashCode() + this.classInfoArray.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ClassInfoPath) {
                ClassInfoPath other = (ClassInfoPath)o;
                return this.debuggingProcess == other.debuggingProcess && Arrays.equals(this.classInfoArray, other.classInfoArray);
            }
            return false;
        }
    }

    private final class ClassTreeTableModel
    extends AbstractTreeTableModel {
        private List<ClassItem> root;
        private List<ClassInfoPath> expanded;
        private ClassInfoPath savedHighlight;

        ClassTreeTableModel(List<ClassItem> root) {
            super(root);
            this.root = root;
            this.expanded = Collections.synchronizedList(new ArrayList());
        }

        void updateClasses() {
            this.saveHighlight();
            ClassesWindow.access$1802(ClassesWindow.this, null);
            ClassesWindow.access$1902(ClassesWindow.this, null);
            ClassesWindow.access$2002(ClassesWindow.this, null);
            this.root.clear();
            if (ClassesWindow.this.treeTable != null && ClassesWindow.this.treeTable.isShowing()) {
                ClassesWindow.this.skippedUpdate = false;
                if (ClassesWindow.this.debuggingProcess != null && ClassesWindow.this.vm != null) {
                    this.addClassItems();
                }
            } else {
                ClassesWindow.this.skippedUpdate = true;
            }
            this.fireChanged();
            this.restoreHighlight(true);
        }

        private DebugClassLoaderInfo[] makeClassLoadersArray(DebugClassLoaderInfo[] classLoaders) {
            ArrayList<DebugClassLoaderInfo> list = new ArrayList<DebugClassLoaderInfo>();
            for (int i = 0; i < classLoaders.length; ++i) {
                DebugClassLoaderInfo classLoader = classLoaders[i];
                String clName = classLoader.getClassName();
                if (clName != null && clName.equals("sun.reflect.DelegatingClassLoader")) continue;
                list.add(classLoader);
            }
            return list.toArray(new DebugClassLoaderInfo[list.size()]);
        }

        private ClassInfo[] makeClassesArray(DebugClassInfo[] classes) {
            ArrayList<ClassInfo> list = new ArrayList<ClassInfo>();
            for (int i = 0; i < classes.length; ++i) {
                DebugClassInfo clazz = classes[i];
                if (clazz.isPrimitive() || clazz.getName().startsWith("sun.reflect.Generated")) continue;
                list.add(new ClassInfo(clazz));
            }
            return list.toArray(new ClassInfo[list.size()]);
        }

        private PackageInfo[] makePackagesArray(ClassInfo[] classes) {
            LinkedHashSet<PackageInfo> packageSet = new LinkedHashSet<PackageInfo>();
            boolean showClassLoaders = ClassesWindow.this.classesSettings.isShowClassLoaders();
            boolean asTree = ClassesWindow.this.classesSettings.isShowPackagesAsTree();
            for (int i = 0; i < classes.length; ++i) {
                int lastDot;
                PackageInfo pi = new PackageInfo(classes[i]);
                if (!showClassLoaders) {
                    pi = new PackageInfo(pi.pkg, null);
                }
                if (pi.pkg.length() == 0 || packageSet.contains(pi)) continue;
                packageSet.add(pi);
                if (!asTree) continue;
                String pkg = pi.pkg;
                DebugClassLoaderInfo classLoader = pi.classLoader;
                while ((lastDot = pkg.lastIndexOf(46)) != -1 && !packageSet.contains(pi = new PackageInfo(pkg = pkg.substring(0, lastDot), classLoader))) {
                    packageSet.add(pi);
                }
            }
            return packageSet.toArray(new PackageInfo[packageSet.size()]);
        }

        void addClassItems() {
            ClassesWindow.access$1902(ClassesWindow.this, new PackageInfo[0]);
            ClassesWindow.access$1802(ClassesWindow.this, new DebugClassLoaderInfo[0]);
            ClassesWindow.access$2002(ClassesWindow.this, this.makeClassesArray(ClassesWindow.this.vm.listClasses()));
            ClassesWindow.this.fixSort();
            if (ClassesWindow.this.classesSettings.isShowClassLoaders()) {
                ClassesWindow.access$1802(ClassesWindow.this, this.makeClassLoadersArray(ClassesWindow.this.vm.listClassLoaders()));
                ArrayList<DebugClassLoaderInfo> classLoaders = new ArrayList<DebugClassLoaderInfo>();
                this.addClassLoaders(null, classLoaders);
                this.root.addAll(this.makeChildNodes(classLoaders, null, null));
            } else if (ClassesWindow.this.classesSettings.isShowPackages()) {
                ClassesWindow.access$1902(ClassesWindow.this, this.makePackagesArray(ClassesWindow.this.allClasses));
                ArrayList<PackageInfo> packages = new ArrayList<PackageInfo>();
                this.addPackages(null, null, packages);
                ArrayList<ClassInfo> classes = new ArrayList<ClassInfo>();
                this.addClasses(null, ClassesWindow.NOT_AVAILABLE, classes);
                this.root.addAll(this.makeChildNodes(null, packages, classes));
            } else {
                ArrayList<ClassInfo> classes = new ArrayList<ClassInfo>();
                this.addClasses(null, null, classes);
                this.root.addAll(this.makeChildNodes(null, null, classes));
            }
        }

        private void addClassLoaders(DebugClassLoaderInfo parentClassLoader, List<DebugClassLoaderInfo> classLoaders) {
            boolean asTree = ClassesWindow.this.classesSettings.isShowClassLoadersAsTree();
            if (!asTree && parentClassLoader != null) {
                return;
            }
            for (int i = 0; i < ClassesWindow.this.allClassLoaders.length; ++i) {
                DebugClassLoaderInfo classLoader = ClassesWindow.this.allClassLoaders[i];
                boolean add = false;
                if (!asTree) {
                    add = true;
                } else if (parentClassLoader == classLoader.getParent()) {
                    add = true;
                }
                if (!add) continue;
                classLoaders.add(classLoader);
            }
        }

        private void addPackages(DebugClassLoaderInfo parentClassLoader, String parentPackage, List<PackageInfo> packages) {
            boolean asTree = ClassesWindow.this.classesSettings.isShowPackagesAsTree();
            if (!asTree && parentPackage != null) {
                return;
            }
            String pkgDot = null;
            int pkgDotLength = 0;
            if (parentPackage != null) {
                pkgDot = parentPackage + ".";
                pkgDotLength = pkgDot.length();
            }
            for (int i = 0; i < ClassesWindow.this.allPackages.length; ++i) {
                PackageInfo pi = ClassesWindow.this.allPackages[i];
                if (parentClassLoader != null && parentClassLoader != pi.classLoader) continue;
                boolean add = false;
                if (!asTree) {
                    add = true;
                } else if ((pkgDot == null || pi.pkg.startsWith(pkgDot)) && pi.pkg.indexOf(46, pkgDotLength) == -1) {
                    add = true;
                }
                if (!add) continue;
                packages.add(pi);
            }
        }

        private void addClasses(DebugClassLoaderInfo parentClassLoader, String parentPackage, List<ClassInfo> classes) {
            for (int i = 0; i < ClassesWindow.this.allClasses.length; ++i) {
                ClassInfo clazz = ClassesWindow.this.allClasses[i];
                if (parentClassLoader != null && parentClassLoader != clazz.getClassLoader() || parentPackage != null && !parentPackage.equals(DebugShared.makeCourtesyPackage(clazz.debugClassInfo))) continue;
                classes.add(ClassesWindow.this.allClasses[i]);
            }
        }

        private List<ClassItem> makeChildNodes(List<DebugClassLoaderInfo> classLoaders, List<PackageInfo> packages, List<ClassInfo> classes) {
            ArrayList<ClassItem> list = new ArrayList<ClassItem>();
            if (classLoaders != null) {
                Collections.sort(classLoaders, ClassesWindow.this.getComparatorForClassLoaders());
                for (DebugClassLoaderInfo classLoader : classLoaders) {
                    list.add(new ClassItem(classLoader));
                }
            }
            if (packages != null) {
                Collections.sort(packages, ClassesWindow.this.getComparatorForPackages());
                for (PackageInfo pi : packages) {
                    list.add(new ClassItem(pi));
                }
            }
            if (classes != null) {
                if (ClassesWindow.this.canCountObjects && WindowSettingsColumnManager.getColumnVisible(ClassesWindow.this.classesSettings.getHash(), ClassesWindow.this.vm.getID(), 1)) {
                    DebugClassInfo[] debugClassInfos = new DebugClassInfo[classes.size()];
                    for (int i = 0; i < debugClassInfos.length; ++i) {
                        debugClassInfos[i] = classes.get((int)i).debugClassInfo;
                    }
                    long[] counts = ClassesWindow.this.vm.countObjectsOfClasses(debugClassInfos);
                    if (counts != null && counts.length == classes.size()) {
                        for (int i = 0; i < counts.length; ++i) {
                            classes.get(i).setCount(counts[i]);
                        }
                    }
                }
                Collections.sort(classes, ClassesWindow.this.getComparatorForClasses());
                for (ClassInfo clazz : classes) {
                    list.add(new ClassItem(clazz));
                }
            }
            return list;
        }

        void fireChanged() {
            TreePath rootTreePath = new TreePath(this.root);
            this.fireTreeStructureChanged((Object)this, rootTreePath.getPath(), null, null);
            this.restoreExpanded(rootTreePath);
        }

        void clearClasses() {
            this.saveHighlight();
            this.clearAll();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            ArrayList<ClassInfoPath> remove = new ArrayList<ClassInfoPath>();
            for (ClassInfoPath classInfoPath : this.expanded) {
                if (classInfoPath.getDebuggingProcess() != debuggingProcess) continue;
                remove.add(classInfoPath);
            }
            for (ClassInfoPath classInfoPath : remove) {
                this.expanded.remove(classInfoPath);
            }
            if (this.savedHighlight != null && this.savedHighlight.getDebuggingProcess() == debuggingProcess) {
                this.savedHighlight = null;
            }
        }

        private void clearAll() {
            this.clearAll(ClassesWindow.this.treeTable.getTree(), new TreePath(this.root));
        }

        private void clearAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ClassItem) {
                ((ClassItem)node).clearClass();
            }
            int count = this.getChildCountLazy(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChildLazy(node, i);
                if (child == null) continue;
                this.clearAll(tree, treePath.pathByAddingChild(child));
            }
        }

        private void restoreExpanded(TreePath treePath) {
            JTree tree = ClassesWindow.this.treeTable.getTree();
            if (tree.isExpanded(treePath)) {
                Object node = treePath.getLastPathComponent();
                Iterator itChildren = this.getChildren(node);
                while (itChildren.hasNext()) {
                    Object child = itChildren.next();
                    TreePath childTreePath = treePath.pathByAddingChild(child);
                    ClassInfoPath classInfoPath = this.convertTreePathToClassInfoPath(childTreePath);
                    if (!this.expanded.contains(classInfoPath)) continue;
                    tree.expandPath(childTreePath);
                }
            }
        }

        private void branchExpanded(TreePath treePath) {
            ClassInfoPath classInfoPath = this.convertTreePathToClassInfoPath(treePath);
            if (classInfoPath != null) {
                int i = this.expanded.indexOf(classInfoPath);
                if (i != -1) {
                    this.expanded.remove(i);
                }
                this.expanded.add(classInfoPath);
                this.restoreExpanded(treePath);
            }
        }

        private void branchCollapsed(TreePath treePath) {
            ClassInfoPath classInfoPath = this.convertTreePathToClassInfoPath(treePath);
            if (classInfoPath != null) {
                this.expanded.remove(classInfoPath);
            }
        }

        private void saveHighlight() {
            ClassInfoPath savedHighlight = this.getCurrentHighlight();
            if (savedHighlight != null) {
                this.savedHighlight = savedHighlight;
            }
        }

        private void restoreHighlight(boolean scrollToVisible) {
            if (this.savedHighlight != null) {
                this.savedHighlight = this.savedHighlight.updateClassInfoPath();
                TreePath treePath = this.makeVisible(this.savedHighlight);
                JDebugger.getInstance().selectTreeTablePath(ClassesWindow.this.treeTable, treePath, scrollToVisible);
            }
        }

        TreePath makeVisible(ClassInfoPath classInfoPath) {
            TreePath treePath = this.convertClassInfoPathToTreePath(classInfoPath);
            if (treePath != null) {
                ClassesWindow.this.treeTable.getTree().makeVisible(treePath);
            }
            return treePath;
        }

        ClassInfoPath getCurrentHighlight() {
            TreePath treePath = ClassesWindow.this.treeTable.getTree().getSelectionPath();
            if (treePath != null) {
                return this.convertTreePathToClassInfoPath(treePath);
            }
            return null;
        }

        ClassItem getClassItemAtPoint(Point pt) {
            int row = ClassesWindow.this.treeTable.rowAtPoint(pt);
            TreePath treePath = ClassesWindow.this.treeTable.getTree().getPathForRow(row);
            return this.getClassItemForTreePath(treePath);
        }

        ClassItem getClassItemForTreePath(TreePath treePath) {
            Object node;
            if (treePath != null && (node = treePath.getLastPathComponent()) instanceof ClassItem) {
                return (ClassItem)node;
            }
            return null;
        }

        ClassInfoPath convertTreePathToClassInfoPath(TreePath treePath) {
            boolean foundOneClassInfo = false;
            Object[] path = treePath.getPath();
            int length = path.length;
            Object[] classInfoArray = new Object[length];
            for (int i = 0; i < length; ++i) {
                Object node = path[i];
                if (!(node instanceof ClassItem)) continue;
                classInfoArray[i] = ((ClassItem)node).getInfo();
                if (classInfoArray[i] == null) continue;
                foundOneClassInfo = true;
            }
            if (foundOneClassInfo) {
                return new ClassInfoPath(ClassesWindow.this.debuggingProcess, classInfoArray);
            }
            return null;
        }

        TreePath convertClassInfoPathToTreePath(ClassInfoPath classInfoPath) {
            int classInfoPathSize = classInfoPath.size();
            if (classInfoPathSize == 0) {
                return null;
            }
            List<ClassItem> node = this.root;
            TreePath treePath = new TreePath(node);
            for (int i = 1; i < classInfoPathSize; ++i) {
                Object classInfo = classInfoPath.getClassInfo(i);
                Object nextNode = null;
                Iterator itChildren = this.getChildren(node);
                while (itChildren.hasNext()) {
                    Object nextClassInfo;
                    Object child = itChildren.next();
                    if (!(child instanceof ClassItem) || !((nextClassInfo = ((ClassItem)child).getInfo()) == null ? classInfo == null : nextClassInfo.equals(classInfo))) continue;
                    nextNode = child;
                    break;
                }
                if (nextNode == null) {
                    return null;
                }
                node = nextNode;
                treePath = treePath.pathByAddingChild(node);
            }
            return treePath;
        }

        ClassItem getSelectedClassItem() {
            TreePath treePath = ClassesWindow.this.treeTable.getTree().getSelectionPath();
            return this.getClassItemForTreePath(treePath);
        }

        private void resetIcons() {
            this.resetIconsRecurse(new TreePath(this.root));
            ClassesWindow.this.treeTable.repaint(ClassesWindow.this.treeTable.getVisibleRect());
        }

        private void resetIconsRecurse(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ClassItem) {
                ((ClassItem)node).setIconAppropriately();
            }
            int count = this.getChildCountLazy(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChildLazy(node, i);
                if (child == null) continue;
                this.resetIconsRecurse(treePath.pathByAddingChild(child));
            }
        }

        private void expandAll() {
            WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
            wc.show();
            try {
                this.expandAll(ClassesWindow.this.treeTable.getTree(), new TreePath(this.root));
            }
            finally {
                wc.hide();
            }
        }

        private void expandAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            tree.expandPath(treePath);
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                this.expandAll(tree, treePath.pathByAddingChild(child));
            }
        }

        private void collapseAll() {
            WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
            wc.show();
            try {
                this.collapseAll(ClassesWindow.this.treeTable.getTree(), new TreePath(this.root));
            }
            finally {
                wc.hide();
            }
            this.expanded.clear();
        }

        private void collapseAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            int count = this.getChildCountLazy(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChildLazy(node, i);
                if (child == null) continue;
                this.collapseAll(tree, treePath.pathByAddingChild(child));
            }
            if (!node.equals(this.root)) {
                tree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter out, boolean html) {
            if (html) {
                out.println("<table border=\"1\">");
            }
            this.saveHeader(out, html);
            this.save(ClassesWindow.this.treeTable.getTree(), new TreePath(this.root), out, html, ClassesWindow.NOT_AVAILABLE);
            if (html) {
                out.println("</table>");
            }
        }

        private void saveHeader(PrintWriter out, boolean html) {
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            if (html) {
                sb.append("<tr>");
            }
            TableColumnModel tableColumnModel = ClassesWindow.this.treeTable.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int i = column.getModelIndex();
                String columnName = this.getColumnName(i);
                if (html) {
                    sb.append("<th>");
                    columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                    sb.append(columnName);
                    sb.append("</th>");
                    continue;
                }
                sb.append(columnName);
                for (int ii = columnName.length(); ii >= 0; --ii) {
                    sb2.append('-');
                }
                if (!e.hasMoreElements()) continue;
                sb.append('\t');
                sb2.append('\t');
            }
            if (html) {
                sb.append("</tr>");
            }
            out.println(sb.toString());
            if (!html) {
                out.println(sb2.toString());
            }
        }

        private void save(JTree tree, TreePath treePath, PrintWriter out, boolean html, String indent) {
            if (tree.isVisible(treePath)) {
                Object node = treePath.getLastPathComponent();
                if (node instanceof ClassItem) {
                    ClassItem classItem = (ClassItem)node;
                    StringBuffer sb = new StringBuffer();
                    if (html) {
                        sb.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = ClassesWindow.this.treeTable.getColumnModel();
                    Enumeration<TableColumn> e = tableColumnModel.getColumns();
                    while (e.hasMoreElements()) {
                        String iconLabel;
                        TableColumn column = e.nextElement();
                        int i = column.getModelIndex();
                        Object columnValue = this.getValueAt(node, i);
                        if (html) {
                            String iconLabel2;
                            String columnValueString;
                            sb.append("<td>");
                            if (i == 0) {
                                sb.append("<tt>");
                                if (indent != null) {
                                    sb.append(indent);
                                }
                                if (tree.isExpanded(treePath)) {
                                    sb.append("-&nbsp;");
                                } else if (classItem.mayHaveChildren()) {
                                    sb.append("+&nbsp;");
                                } else {
                                    sb.append("&nbsp;&nbsp;");
                                }
                                sb.append("</tt>");
                            }
                            if ((columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue.toString())).length() > 0) {
                                sb.append(columnValueString);
                            } else {
                                sb.append("&nbsp;");
                            }
                            if (i == 0 && (iconLabel2 = classItem.getIconLabel(" (", ")")) != null && iconLabel2.length() > 0) {
                                sb.append(iconLabel2);
                            }
                            sb.append("</td>");
                            continue;
                        }
                        if (i == 0) {
                            if (indent != null) {
                                sb.append(indent);
                            }
                            if (tree.isExpanded(treePath)) {
                                sb.append("- ");
                            } else if (classItem.mayHaveChildren()) {
                                sb.append("+ ");
                            } else {
                                sb.append("  ");
                            }
                        }
                        sb.append(columnValue);
                        if (i == 0 && (iconLabel = classItem.getIconLabel(" (", ")")) != null && iconLabel.length() > 0) {
                            sb.append(iconLabel);
                        }
                        if (!e.hasMoreElements()) continue;
                        sb.append('\t');
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                }
                if (node != this.root) {
                    indent = html ? indent + "&nbsp;&nbsp;&nbsp;&nbsp;" : indent + "    ";
                }
                int count = this.getChildCountLazy(node);
                for (int i = 0; i < count; ++i) {
                    Object child = this.getChildLazy(node, i);
                    if (child == null) continue;
                    this.save(tree, treePath.pathByAddingChild(child), out, html, indent);
                }
            }
        }

        public boolean isLeaf(Object node) {
            try {
                if (node == this.root) {
                    return false;
                }
                ClassItem classItem = (ClassItem)node;
                return !classItem.mayHaveChildren();
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        Iterator getChildren(Object parent) {
            if (parent == this.root) {
                return this.root.iterator();
            }
            ClassItem classItem = (ClassItem)parent;
            return classItem.getChildren();
        }

        private int getChildCountLazy(Object parent) {
            if (parent instanceof List) {
                return ((List)parent).size();
            }
            ClassItem classItem = (ClassItem)parent;
            if (classItem.children != null) {
                return classItem.children.size();
            }
            return 0;
        }

        private Object getChildLazy(Object parent, int index) {
            if (parent instanceof List) {
                return ((List)parent).get(index);
            }
            ClassItem classItem = (ClassItem)parent;
            if (classItem.children != null) {
                return classItem.children.get(index);
            }
            return null;
        }

        public Object getChild(Object parent, int index) {
            try {
                if (parent instanceof List) {
                    return ((List)parent).get(index);
                }
                ClassItem classItem = (ClassItem)parent;
                return classItem.getChildNodes().get(index);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object parent) {
            try {
                if (parent instanceof List) {
                    return ((List)parent).size();
                }
                ClassItem classItem = (ClassItem)parent;
                return classItem.countChildNodes();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return DbgArb.getString(509);
                }
                case 1: {
                    return DbgArb.getString(510);
                }
                case 2: {
                    return DbgArb.getString(511);
                }
                case 3: {
                    return DbgArb.getString(512);
                }
            }
            return ClassesWindow.NOT_AVAILABLE;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        public Object getValueAt(Object node, int column) {
            try {
                if (node instanceof List) {
                    switch (column) {
                        case 0: {
                            return "root";
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            return ClassesWindow.NOT_AVAILABLE;
                        }
                    }
                    return null;
                }
                ClassItem classItem = (ClassItem)node;
                switch (column) {
                    case 0: {
                        return classItem.getName();
                    }
                    case 1: {
                        return classItem.getCount();
                    }
                    case 2: {
                        return classItem.getMemory();
                    }
                    case 3: {
                        return classItem.getFilename();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private String getAccessibleNameAt(ClassItem classItem, int column) {
            int id;
            if (classItem.isPackage()) {
                id = 505;
            } else if (classItem.isClass()) {
                id = 506;
            } else if (classItem.isInterface()) {
                id = 507;
            } else if (classItem.isArrayClass()) {
                id = 508;
            } else {
                return null;
            }
            String columnName = this.getColumnName(column);
            String value = (String)this.getValueAt(classItem, column);
            if (value == null || value.length() == 0) {
                value = DbgArb.getString(797);
            }
            return DbgArb.format(id, columnName, value);
        }

        private final class ClassItem
        extends BaseElement
        implements Transferable {
            private Object info;
            private DataFlavor dragFlavor;
            private List<ClassItem> children;
            private Boolean cachedMayHaveChildren;
            private String cachedName;
            private String cachedCount;
            private String cachedMemory;
            private String cachedFilename;

            ClassItem(DebugClassLoaderInfo classLoader) {
                this.init(classLoader);
            }

            ClassItem(PackageInfo pi) {
                this.init(pi);
            }

            ClassItem(ClassInfo clazz) {
                this.init(clazz);
            }

            private void init(Object info) {
                this.info = info;
                this.setDragFlavorAppropriately();
                this.setIconAppropriately();
            }

            private void setDragFlavorAppropriately() {
                if (this.info instanceof ClassInfo) {
                    ClassInfo clazz = (ClassInfo)this.info;
                    if (clazz.isObject()) {
                        this.dragFlavor = ClassesWindow.getClassFlavor();
                    } else if (clazz.isInterface()) {
                        this.dragFlavor = ClassesWindow.getInterfaceFlavor();
                    } else if (clazz.isArray()) {
                        this.dragFlavor = ClassesWindow.getArrayFlavor();
                    }
                }
            }

            private void setIconAppropriately() {
                if (this.info instanceof DebugClassLoaderInfo) {
                    this.setIcon(ClassesWindow.getClassLoaderIcon());
                } else {
                    Icon icon = null;
                    Icon iconGray = null;
                    if (this.info instanceof PackageInfo) {
                        icon = ClassesWindow.getPackageIcon();
                        iconGray = ClassesWindow.getPackageIconGray();
                    } else if (this.info instanceof ClassInfo) {
                        ClassInfo clazz = (ClassInfo)this.info;
                        if (clazz.isArray()) {
                            icon = ClassesWindow.getArrayIcon();
                            iconGray = ClassesWindow.getArrayIconGray();
                        } else if (clazz.isInterface()) {
                            icon = ClassesWindow.getInterfaceIcon();
                            iconGray = ClassesWindow.getInterfaceIconGray();
                        } else {
                            if (clazz.debugClassInfo.isDebuggable()) {
                                if (clazz.debugClassInfo.isObfuscated()) {
                                    this.setIcon(ClassesWindow.getClassObfuscatedIcon());
                                } else {
                                    this.setIcon(ClassesWindow.getClassIcon());
                                }
                            } else {
                                this.setIcon(ClassesWindow.getClassIconGray());
                            }
                            return;
                        }
                    }
                    if (icon != null && iconGray != null) {
                        String name = this.getRealName();
                        if (DebugShared.isClassOrPackageDebuggable(name, ClassesWindow.this.tracingIncludeList, ClassesWindow.this.tracingExcludeList)) {
                            this.setIcon(icon);
                        } else {
                            this.setIcon(iconGray);
                        }
                    }
                }
            }

            String getIconLabel(String pre, String post) {
                int key = -1;
                Icon icon = this.getIcon();
                if (icon == ClassesWindow.getClassLoaderIcon()) {
                    key = 515;
                } else if (icon == ClassesWindow.getPackageIcon()) {
                    key = 516;
                } else if (icon == ClassesWindow.getPackageIconGray()) {
                    key = 517;
                } else if (icon == ClassesWindow.getClassIcon()) {
                    key = 518;
                } else if (icon == ClassesWindow.getClassIconGray()) {
                    key = 519;
                } else if (icon == ClassesWindow.getClassObfuscatedIcon()) {
                    key = 520;
                } else if (icon == ClassesWindow.getInterfaceIcon()) {
                    key = 521;
                } else if (icon == ClassesWindow.getInterfaceIconGray()) {
                    key = 522;
                } else if (icon == ClassesWindow.getArrayIcon()) {
                    key = 523;
                } else if (icon == ClassesWindow.getArrayIconGray()) {
                    key = 524;
                }
                if (key != -1) {
                    return pre + DbgArb.getString(key) + post;
                }
                return null;
            }

            String getNameToolTip() {
                StringBuffer toolTip = new StringBuffer();
                if (this.info instanceof DebugClassLoaderInfo) {
                    toolTip.append(ClassesWindow.makeClassLoaderName((DebugClassLoaderInfo)this.info));
                } else if (this.info instanceof PackageInfo) {
                    toolTip.append(((PackageInfo)this.info).pkg);
                } else if (this.info instanceof ClassInfo) {
                    toolTip.append(((ClassInfo)this.info).getCourtesyClassName(true));
                } else {
                    return null;
                }
                String iconLabel = this.getIconLabel(" (", ")");
                if (iconLabel != null && iconLabel.length() > 0) {
                    toolTip.append(iconLabel);
                }
                return toolTip.toString();
            }

            boolean isPackage() {
                return this.info instanceof PackageInfo;
            }

            boolean isClass() {
                return this.info instanceof ClassInfo && ((ClassInfo)this.info).isObject();
            }

            boolean isInterface() {
                return this.info instanceof ClassInfo && ((ClassInfo)this.info).isInterface();
            }

            boolean isArrayClass() {
                return this.info instanceof ClassInfo && ((ClassInfo)this.info).isArray();
            }

            void clearClass() {
                this.info = null;
            }

            Object getInfo() {
                return this.info;
            }

            public String getShortLabel() {
                return this.getName();
            }

            public Object getData() {
                return this;
            }

            public boolean mayHaveChildren() {
                if (this.cachedMayHaveChildren == null && ClassesWindow.this.treeTable.isEnabled()) {
                    this.cachedMayHaveChildren = this.info instanceof DebugClassLoaderInfo ? Boolean.TRUE : (this.info instanceof PackageInfo ? Boolean.TRUE : Boolean.FALSE);
                }
                if (this.cachedMayHaveChildren != null) {
                    return this.cachedMayHaveChildren;
                }
                return false;
            }

            public Iterator getChildren() {
                return this.getChildNodes().iterator();
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] transferFlavors = this.dragFlavor != null ? new DataFlavor[]{this.dragFlavor, DataFlavor.stringFlavor} : new DataFlavor[]{DataFlavor.stringFlavor};
                return transferFlavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                if (this.dragFlavor != null && flavor.equals(this.dragFlavor)) {
                    return true;
                }
                return flavor.equals(DataFlavor.stringFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.dragFlavor != null && flavor.equals(this.dragFlavor)) {
                    ClassFlavorData data = null;
                    if (this.dragFlavor == ClassesWindow.getClassFlavor()) {
                        data = new ClassFlavorData(this.info);
                    } else if (this.dragFlavor == ClassesWindow.getInterfaceFlavor()) {
                        data = new InterfaceFlavorData(this.info);
                    } else if (this.dragFlavor == ClassesWindow.getArrayFlavor()) {
                        data = new ArrayFlavorData(this.info);
                    }
                    return data;
                }
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return this.getShortLabel();
                }
                throw new UnsupportedFlavorException(flavor);
            }

            public String getName() {
                if (this.cachedName == null && ClassesWindow.this.treeTable.isEnabled()) {
                    if (this.info instanceof DebugClassLoaderInfo) {
                        this.cachedName = ClassesWindow.makeClassLoaderName((DebugClassLoaderInfo)this.info);
                    } else if (this.info instanceof PackageInfo) {
                        if (ClassesWindow.this.classesSettings.isShowPackagesAsTree()) {
                            String s = ((PackageInfo)this.info).pkg;
                            int i = s.lastIndexOf(46);
                            if (i != -1) {
                                s = s.substring(i + 1);
                            }
                            this.cachedName = s;
                        } else {
                            this.cachedName = ((PackageInfo)this.info).pkg;
                        }
                    } else if (this.info instanceof ClassInfo) {
                        this.cachedName = ClassesWindow.this.classesSettings.isShowPackages() ? ((ClassInfo)this.info).getCourtesyClassName(false) : ((ClassInfo)this.info).getCourtesyClassName(true);
                    }
                }
                if (this.cachedName != null) {
                    return this.cachedName;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            public String getCount() {
                if (this.cachedCount == null && ClassesWindow.this.treeTable.isEnabled()) {
                    long count;
                    this.cachedCount = ClassesWindow.this.canCountObjects && this.info instanceof ClassInfo ? ((count = ((ClassInfo)this.info).getCount()) > 0L ? Long.toString(count) : ClassesWindow.NOT_AVAILABLE) : ClassesWindow.NOT_AVAILABLE;
                }
                if (this.cachedCount != null) {
                    return this.cachedCount;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            public String getMemory() {
                if (this.cachedMemory == null && ClassesWindow.this.treeTable.isEnabled()) {
                    int memory;
                    this.cachedMemory = ClassesWindow.this.canCountMemory && this.info instanceof ClassInfo ? ((memory = ((ClassInfo)this.info).getMemory()) > 0 ? Integer.toString(memory) : ClassesWindow.NOT_AVAILABLE) : ClassesWindow.NOT_AVAILABLE;
                }
                if (this.cachedMemory != null) {
                    return this.cachedMemory;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            public String getFilename() {
                if (this.cachedFilename == null && ClassesWindow.this.treeTable.isEnabled()) {
                    this.cachedFilename = this.info instanceof ClassInfo ? ((ClassInfo)this.info).getPrimarySourceFilename() : ClassesWindow.NOT_AVAILABLE;
                }
                if (this.cachedFilename != null) {
                    return this.cachedFilename;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            private List<ClassItem> makeChildren() {
                ArrayList classLoaders = new ArrayList();
                ArrayList packages = new ArrayList();
                ArrayList classes = new ArrayList();
                if (this.info instanceof DebugClassLoaderInfo) {
                    DebugClassLoaderInfo classLoader = (DebugClassLoaderInfo)this.info;
                    ClassTreeTableModel.this.addClassLoaders(classLoader, classLoaders);
                    if (ClassesWindow.this.classesSettings.isShowPackages()) {
                        ClassTreeTableModel.this.addPackages(classLoader, null, packages);
                        ClassTreeTableModel.this.addClasses(classLoader, ClassesWindow.NOT_AVAILABLE, classes);
                    } else {
                        ClassTreeTableModel.this.addClasses(classLoader, null, classes);
                    }
                } else if (this.info instanceof PackageInfo) {
                    DebugClassLoaderInfo classLoader = null;
                    if (ClassesWindow.this.classesSettings.isShowClassLoaders()) {
                        classLoader = ((PackageInfo)this.info).classLoader;
                    }
                    String parentPackage = ((PackageInfo)this.info).pkg;
                    ClassTreeTableModel.this.addPackages(classLoader, parentPackage, packages);
                    ClassTreeTableModel.this.addClasses(classLoader, parentPackage, classes);
                }
                return ClassTreeTableModel.this.makeChildNodes(classLoaders, packages, classes);
            }

            int countChildNodes() {
                if (this.children == null) {
                    this.children = this.makeChildren();
                }
                if (this.children != null) {
                    return this.children.size();
                }
                return 0;
            }

            List<ClassItem> getChildNodes() {
                if (this.children == null) {
                    this.children = this.makeChildren();
                }
                return this.children;
            }

            String getRealName() {
                if (this.info instanceof DebugClassLoaderInfo) {
                    return null;
                }
                if (this.info instanceof PackageInfo) {
                    return ((PackageInfo)this.info).pkg;
                }
                if (this.info instanceof ClassInfo) {
                    ClassInfo clazz = (ClassInfo)this.info;
                    return clazz.getName();
                }
                return null;
            }

            boolean canShowSource() {
                if (this.info instanceof ClassInfo) {
                    String sourceFilename = ((ClassInfo)this.info).getPrimarySourceFilename();
                    return sourceFilename != null && sourceFilename.length() > 0;
                }
                return false;
            }

            void showSource() {
                if (this.info instanceof ClassInfo) {
                    ClassInfo clazz = (ClassInfo)this.info;
                    ClassesWindow.this.debuggingProcess.showSourceFile(clazz.debugClassInfo);
                }
            }

            boolean canViewAnnotations() {
                return this.info instanceof ClassInfo && ((ClassInfo)this.info).countAnnotations() > 0;
            }

            void viewAnnotations() {
                DebugAnnotationInfo[] annotations;
                if (this.info instanceof ClassInfo && (annotations = ((ClassInfo)this.info).getAnnotations()) != null && annotations.length > 0) {
                    String className = ((ClassInfo)this.info).getName();
                    String dlgTitle = DbgArb.format(814, className);
                    DataController.showAnnotationsDialog(dlgTitle, null, ClassesWindow.this.debuggingProcess, ClassesWindow.this.vm, null, null, annotations);
                }
            }

            boolean canDrag() {
                return this.dragFlavor != null;
            }

            boolean canShowInHeap() {
                if (JDebugger.getInstance().canShowHeapWindow() && this.info instanceof ClassInfo) {
                    ClassInfo clazz = (ClassInfo)this.info;
                    return clazz.isObject() || clazz.isArray();
                }
                return false;
            }

            void showInHeap() {
                ClassInfo clazz;
                if (JDebugger.getInstance().canShowHeapWindow() && this.info instanceof ClassInfo && ((clazz = (ClassInfo)this.info).isObject() || clazz.isArray())) {
                    String className = clazz.getName();
                    JDebugger jdebugger = JDebugger.getInstance();
                    jdebugger.viewHeap();
                    HeapWindow heapWindow = jdebugger.getHeapWindow(true);
                    heapWindow.addHeapClass(className);
                }
            }

            boolean canWatchInspectClassLoader() {
                DebugDataObjectInfo classLoaderObject;
                DebugClassLoaderInfo classLoader = null;
                if (this.info instanceof DebugClassLoaderInfo) {
                    classLoader = (DebugClassLoaderInfo)this.info;
                } else if (this.info instanceof ClassInfo) {
                    classLoader = ((ClassInfo)this.info).getClassLoader();
                }
                return classLoader != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull();
            }

            private EvaluatorItem getEvaluatorItem() {
                DebugDataObjectInfo classLoaderObject;
                DebugClassLoaderInfo classLoader = null;
                if (this.info instanceof DebugClassLoaderInfo) {
                    classLoader = (DebugClassLoaderInfo)this.info;
                } else if (this.info instanceof ClassInfo) {
                    classLoader = ((ClassInfo)this.info).getClassLoader();
                }
                if (classLoader != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull()) {
                    String name = ClassesWindow.makeClassLoaderName(classLoader);
                    return ClassesWindow.this.debuggingProcess.makeTemporaryEvaluatorItem(name, classLoaderObject);
                }
                return null;
            }

            void watchClassLoader() {
                EvaluatorItem ei = this.getEvaluatorItem();
                if (ei != null) {
                    JDebugger.getInstance().addWatch(ei);
                }
            }

            void inspectClassLoader() {
                EvaluatorItem ei = this.getEvaluatorItem();
                if (ei != null) {
                    JDebugger.getInstance().inspect(ei);
                }
            }
        }
    }
}

