/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Context;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.controls.MultiProviderPicker;
import oracle.ide.db.dialogs.DBDialogHeader;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class DBObjectProviderPicker {
    private Collection<PickerListener> m_pickerListeners;
    private PickerValidator m_pickerValidator;
    private boolean m_readOnly = false;

    public abstract Component getComponent();

    public final void setProvider(DBObjectProvider provider) {
        if (provider == null) {
            this.setProvider(null, null);
        } else {
            this.setProvider(provider.getProviderType(), provider.getProviderIdentifier());
        }
    }

    public void setRelatedPicker(DBObjectProviderPicker other) {
    }

    public final void setPickerEnabled(boolean enable) {
        this.setPickerEnabledImpl(!this.m_readOnly && enable);
    }

    protected void setPickerEnabledImpl(boolean enable) {
        this.getComponent().setEnabled(enable);
    }

    public abstract void setProvider(String var1, Object var2);

    public final DBObjectProvider getProvider() throws DBException {
        DBObjectProvider retval = this.getProviderImpl();
        this.validateProvider(retval);
        return retval;
    }

    protected abstract DBObjectProvider getProviderImpl() throws DBException;

    private void validateProvider(DBObjectProvider pro) throws DBException {
        if (this.m_pickerValidator != null) {
            this.m_pickerValidator.validateProvider(pro);
        }
    }

    public abstract DBObjectProviderID getProviderID();

    public boolean hasDBObjectProvider() {
        DBObjectProviderID id = this.getProviderID();
        return id != null && id.isValid();
    }

    protected String getDefaultProviderType(PickerConfiguration config) {
        DBObjectProviderID defProvID = config.getDefaultProviderID();
        String retval = defProvID == null ? null : defProvID.getType();
        return retval;
    }

    protected abstract boolean isAvailable(PickerConfiguration var1);

    protected abstract void init(PickerConfiguration var1);

    protected abstract void addImplementationListener();

    protected abstract void removeImplementationListener();

    void init(PickerConfiguration config, boolean readOnly) {
        this.init(config);
        this.m_readOnly = readOnly;
        this.setPickerEnabled(true);
    }

    public final void addPickerListener(PickerListener pickerListener) {
        if (pickerListener != null) {
            if (this.m_pickerListeners == null) {
                this.m_pickerListeners = new HashSet<PickerListener>();
                this.addImplementationListener();
            }
            this.m_pickerListeners.add(pickerListener);
        }
    }

    public final void removePickerListener(PickerListener pickerListener) {
        if (pickerListener != null && this.m_pickerListeners != null) {
            this.m_pickerListeners.remove(pickerListener);
            if (this.m_pickerListeners.isEmpty()) {
                this.m_pickerListeners = null;
                this.removeImplementationListener();
            }
        }
    }

    protected final void firePickerChanged(DBObjectProviderID providerID) {
        if (this.m_pickerListeners != null) {
            for (PickerListener pickerListener : this.m_pickerListeners) {
                try {
                    pickerListener.providerChanged(providerID);
                }
                catch (Exception e) {
                    DBLog.logStackTrace((String)"PickerListener failed", (Throwable)e);
                }
            }
        }
    }

    public static DBObjectProviderPicker getPicker(PickerConfiguration config) {
        DBObjectProviderPicker retval;
        ArrayList<DatabaseUIExtensionHook.ProviderPickerHash> pickers = new ArrayList<DatabaseUIExtensionHook.ProviderPickerHash>();
        List requestedTypes = config.getProviderTypes() == null ? Collections.emptyList() : Arrays.asList(config.getProviderTypes());
        ArrayList<String> doneTypes = new ArrayList<String>();
        for (DatabaseUIExtensionHook.ProviderPickerHash pp : DatabaseUIExtensionHook.getHook().getDBObjectProviderPickers()) {
            DBObjectProviderPicker picker;
            String providerType = pp.getProviderType();
            if (!requestedTypes.isEmpty() && !requestedTypes.contains(providerType) || doneTypes.contains(providerType) || (picker = pp.getProviderPicker()) == null || !picker.isAvailable(config)) continue;
            pickers.add(pp);
            doneTypes.add(providerType);
        }
        if (pickers.size() == 0) {
            DBLog.logIllegalState((String)"No DBObjectProviderPicker found");
            retval = null;
        } else {
            retval = pickers.size() == 1 ? ((DatabaseUIExtensionHook.ProviderPickerHash)((Object)pickers.get(0))).getProviderPicker() : new MultiProviderPicker(pickers);
        }
        if (retval != null) {
            retval.init(config);
            retval.addPickerListener(config.getPickerListener());
            retval.m_pickerValidator = config.getPickerValidator();
            DBObjectProviderID defaultPro = config.getDefaultProviderID();
            if (defaultPro != null && defaultPro.isValid()) {
                retval.setProvider(defaultPro.getType(), defaultPro.getIdentifier());
            }
        }
        return retval;
    }

    public static DBObjectProvider chooseProvider(PickerConfiguration config, Component parent, String title, String prompt, String helpID) {
        config.setTitle(title);
        config.setPrompt(prompt);
        config.setHelpID(helpID);
        return DBObjectProviderPicker.chooseProvider(config, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBObjectProvider chooseProvider(PickerConfiguration config, Component parent) {
        final Holder retval = new Holder();
        final DBObjectProviderPicker picker = DBObjectProviderPicker.getPicker(config);
        if (picker != null) {
            JPanel panel = new JPanel();
            panel.setName("DBObjectProviderPickerPanel");
            String helpID = config.getHelpID();
            HelpUtils.setHelpID((JComponent)panel, (String)helpID);
            panel.setLayout(new BorderLayout(0, 15));
            String prompt = config.getPrompt();
            if (ModelUtil.hasLength((String)prompt)) {
                JWrappedLabel label = new JWrappedLabel(prompt);
                panel.add((Component)label, "North");
            }
            panel.add(picker.getComponent(), "Center");
            panel.add(Box.createHorizontalStrut(400), "South");
            int buttonMask = 3;
            if (helpID != null) {
                buttonMask |= 4;
            }
            final JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)config.getTitle(), (int)buttonMask);
            dialog.setName("DBObjectProviderPickerDialog");
            dialog.setContent((Component)panel);
            dialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        try {
                            DBObjectProvider pro = picker.getProvider();
                            retval.set((Object)pro);
                        }
                        catch (DBException dbe) {
                            DBExceptionDialog.showErrorDialog((Component)dialog, null, dbe);
                            throw new PropertyVetoException(dbe.getMessage(), evt);
                        }
                    }
                }
            });
            if (ModelUtil.hasLength((String)config.getHeaderText())) {
                DBDialogHeader header = new DBDialogHeader();
                header.setHeaderDescription(config.getHeaderText());
                dialog.setDialogHeader((Component)((Object)header));
            }
            try {
                dialog.runDialog();
            }
            finally {
                dialog.dispose();
            }
        }
        return (DBObjectProvider)retval.get();
    }

    public static abstract class PickerValidator {
        public abstract void validateProvider(DBObjectProvider var1) throws DBException;
    }

    public static class PickerConfiguration {
        private Context m_context;
        private boolean m_forceGlobal;
        private boolean m_showDetails;
        private boolean m_onlyShowProjectDependencies;
        private boolean m_allowCreateProject;
        private boolean m_allowCreate = true;
        private boolean m_allowNull;
        private boolean m_controlEnable;
        private ActionListener m_controlEnableListener;
        private String m_label;
        private String[] m_providerTypes;
        private boolean m_disablePickerForDefault;
        private Map<String, Boolean> m_canBeGlobalProvider;
        private DBObjectProviderID m_defaultProviderID;
        private PickerListener m_pickerListener;
        private DBObjectProvider m_otherProvider;
        private PickerValidator m_pickerValidator;
        private String[] m_databaseTypes;
        private String m_title;
        private String m_headerText;
        private String m_prompt;
        private String m_helpID;

        public Context getContext() {
            if (this.m_context == null) {
                this.m_context = Context.newIdeContext();
            }
            return this.m_context;
        }

        public String getTitle() {
            return this.m_title;
        }

        public void setTitle(String title) {
            this.m_title = title;
        }

        public String getHeaderText() {
            return this.m_headerText;
        }

        public void setHeaderText(String headerText) {
            this.m_headerText = headerText;
        }

        public String getPrompt() {
            return this.m_prompt;
        }

        public void setPrompt(String prompt) {
            this.m_prompt = prompt;
        }

        public String getHelpID() {
            return this.m_helpID;
        }

        public void setHelpID(String helpID) {
            this.m_helpID = helpID;
        }

        public void setContext(Context context) {
            this.m_context = context;
        }

        public boolean getForceGlobal() {
            return this.m_forceGlobal;
        }

        public boolean canBeGlobal(String providerType) {
            boolean retval = this.m_forceGlobal;
            if (!retval && this.m_canBeGlobalProvider != null) {
                retval = Boolean.TRUE.equals(this.m_canBeGlobalProvider.get(providerType));
            }
            return retval;
        }

        public void setForceGlobal(boolean val) {
            this.m_forceGlobal = val;
        }

        public boolean getShowDetails() {
            return this.m_showDetails;
        }

        public void setShowDetails(boolean val) {
            this.m_showDetails = val;
        }

        public void setAllowCreateProject(boolean val) {
            this.m_allowCreateProject = val;
        }

        public boolean getAllowCreateProject() {
            return this.m_allowCreateProject;
        }

        public void setOnlyShowProjectDependencies(boolean val) {
            this.m_onlyShowProjectDependencies = val;
        }

        public boolean getOnlyShowProjectDependencies() {
            return this.m_onlyShowProjectDependencies;
        }

        public boolean getAllowCreate() {
            return this.m_allowCreate;
        }

        public void setAllowCreate(boolean val) {
            this.m_allowCreate = val;
        }

        public boolean getControlEnable() {
            return this.m_controlEnable;
        }

        public void setControlEnable(boolean val) {
            this.m_controlEnable = val;
        }

        public boolean getAllowNull() {
            return this.m_allowNull;
        }

        public void setAllowNull(boolean val) {
            this.m_allowNull = val;
        }

        public String getLabel() {
            return this.m_label;
        }

        public void setLabel(String label) {
            this.m_label = label;
        }

        public String[] getProviderTypes() {
            return this.m_providerTypes;
        }

        public void setProviderTypes(String ... providerTypes) {
            this.m_providerTypes = providerTypes;
        }

        public boolean shouldDisablePickerForDefaultProvider() {
            return this.m_disablePickerForDefault;
        }

        public void setDisablePickerForDefaultProvider(boolean disablePickerForDefault) {
            this.m_disablePickerForDefault = disablePickerForDefault;
        }

        public void setCanBeGlobal(String providerType, boolean value) {
            if (this.m_canBeGlobalProvider == null) {
                this.m_canBeGlobalProvider = new HashMap<String, Boolean>();
            }
            this.m_canBeGlobalProvider.put(providerType, value);
        }

        public DBObjectProviderID getDefaultProviderID() {
            return this.m_defaultProviderID;
        }

        public void setDefaultProviderID(DBObjectProviderID defaultProviderID) {
            this.m_defaultProviderID = defaultProviderID;
        }

        public void setControlEnableListener(ActionListener controlEnableListener) {
            this.m_controlEnableListener = controlEnableListener;
        }

        public ActionListener getControlEnableListener() {
            return this.m_controlEnableListener;
        }

        public PickerListener getPickerListener() {
            return this.m_pickerListener;
        }

        public void setPickerListener(PickerListener pickerListener) {
            this.m_pickerListener = pickerListener;
        }

        public DBObjectProvider getOtherProvider() {
            return this.m_otherProvider;
        }

        public void setOtherProvider(DBObjectProvider otherProvider) {
            this.m_otherProvider = otherProvider;
        }

        public PickerValidator getPickerValidator() {
            return this.m_pickerValidator;
        }

        public void setPickerValidator(PickerValidator pickerValidator) {
            this.m_pickerValidator = pickerValidator;
        }

        public String[] getDatabaseTypes() {
            return this.m_databaseTypes;
        }

        public void setDatabaseTypes(String ... databaseTypes) {
            this.m_databaseTypes = databaseTypes;
        }
    }

    public static interface PickerListener {
        public void providerChanged(DBObjectProviderID var1);
    }
}

