/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.util.ModelUtil;

public final class NameFilterField
extends JTextField {
    private DatabaseDescriptor m_desc;

    public void setDescriptor(DatabaseDescriptor desc) {
        this.m_desc = desc;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1005 && this.m_desc != null) {
            this.processFilter();
        }
        super.processFocusEvent(e);
    }

    private void processFilter() {
        this.setFilter(this.getFilter());
    }

    @Override
    public void setText(String externalFilter) {
        super.setText(externalFilter);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    private DatabaseDescriptor getDescriptor() {
        if (this.m_desc == null) {
            throw new IllegalStateException("Must call setDescriptor before get/setFilter");
        }
        return this.m_desc;
    }

    public String getFilter() {
        DatabaseDescriptor desc;
        String externalFilter = this.getText();
        String text = NameFilterField.isQuoted(externalFilter, desc = this.getDescriptor()) ? externalFilter : externalFilter.replace("*", DBObjectCriteria.LIKE_WILDCARD);
        return this.getDescriptor().getInternalName(text, null);
    }

    public void setFilter(String filter) {
        this.setText(NameFilterField.externaliseFilter(filter, this.getDescriptor()));
    }

    private static String externaliseFilter(String internalFilter, DatabaseDescriptor desc) {
        String retval;
        if (internalFilter != null) {
            internalFilter = internalFilter.trim();
        }
        if (ModelUtil.hasLength((String)internalFilter) && !DBObjectCriteria.LIKE_WILDCARD.equals(internalFilter)) {
            int casePolicy;
            boolean quote;
            String SINGLE_QUOTE = "'";
            String QUOTED_SINGLE_QUOTE = "''";
            String filter = internalFilter;
            if (filter.startsWith("'") && filter.endsWith("'") && !filter.startsWith("''") && !filter.endsWith("''")) {
                filter = filter.substring(1, filter.length() - 1);
            }
            if (!(filter = filter.replace("'", "''")).contains(DBObjectCriteria.LIKE_WILDCARD)) {
                filter = filter + DBObjectCriteria.LIKE_WILDCARD;
            }
            if (quote = (casePolicy = desc.getCasePolicy()) == 2 ? ModelUtil.areDifferent((Object)filter, (Object)filter.toUpperCase()) : (casePolicy == 1 ? ModelUtil.areDifferent((Object)filter, (Object)filter.toLowerCase()) : false)) {
                String quoteString = desc.getIdentifierQuoteString();
                retval = quoteString + filter + quoteString;
            } else {
                retval = filter;
            }
        } else {
            retval = DBObjectCriteria.LIKE_WILDCARD;
        }
        return retval;
    }

    private static boolean isQuoted(String text, DatabaseDescriptor desc) {
        String quoteString = desc.getIdentifierQuoteString();
        return text.startsWith(quoteString) && text.endsWith(quoteString);
    }

    public static String createFilterTitle(String thing) {
        return UIBundle.format("PICKER_FILTER_TITLE", thing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String showFilterDialog(Component parent, String title, DatabaseDescriptor desc, String initialFilter) {
        DBUIResourceHelper reshelp = new DBUIResourceHelper("DBNameFilter");
        JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)title, (int)7);
        dialog.setName(reshelp.getPanelName());
        dialog.setMinimumSize(400, 10);
        NameFilterField filterField = new NameFilterField();
        filterField.setDescriptor(desc);
        JLabel filterLabel = new JLabel();
        reshelp.resLabel(filterLabel, filterField, UIBundle.get("PICKER_FILTER"), "Name");
        JPanel panel = new JPanel();
        DBUILayoutHelper layout = new DBUILayoutHelper(panel);
        layout.add(filterLabel);
        layout.add(filterField);
        layout.pushUp();
        layout.layout();
        dialog.setContent((Component)panel);
        HelpUtils.setHelpID((JComponent)panel, (String)"f1_db_filter_name_html");
        try {
            filterField.setFilter(initialFilter);
            String retval = dialog.runDialog() ? filterField.getFilter() : initialFilter;
            String string = retval;
            return string;
        }
        finally {
            dialog.dispose();
        }
    }
}

