/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.dialogs.AbstractDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.editors.DBObjectOverviewEditor;
import oracle.ideimpl.db.ora.OracleDBEditorFactory;
import oracle.ideimpl.db.panels.TraversableProxy;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.ideimpl.db.validate.ModalValidationManager;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.Metadata;

public class BaseDBEditorFactory
extends AbstractDBEditorFactory {
    private static final String CREATE_CONTEXT_PROP = "BaseDBEditorFactory.CREATE_CONTEXT";
    private final Map<String, PanelLibrary> m_libraries = new HashMap<String, PanelLibrary>();
    private final Map<String, Class<? extends PanelLibrary>> m_libraryClasses = new HashMap<String, Class<? extends PanelLibrary>>();

    protected BaseDBEditorFactory() {
    }

    @Deprecated
    public PanelLibrary getPanelLibrary(String dbObjectType) {
        return this.getPanelLibrary(null, dbObjectType);
    }

    @Override
    public PanelLibrary getPanelLibrary(DBObjectProvider pro, String dbObjectType) {
        PanelLibrary retval = this.m_libraries.get(dbObjectType);
        if (retval == null && (retval = this.createLibrary(dbObjectType)) != null) {
            this.initializeLibrary(retval);
            this.m_libraries.put(dbObjectType, retval);
        }
        return retval;
    }

    protected PanelLibrary createLibrary(String dbObjectType) {
        PanelLibrary retval = null;
        Class<? extends PanelLibrary> clz = this.m_libraryClasses.get(dbObjectType);
        if (clz != null) {
            try {
                retval = clz.newInstance();
            }
            catch (Exception e) {
                DBLog.logStackTrace((String)"Could not init library", (Throwable)e);
            }
        }
        return retval;
    }

    protected void initializeLibrary(PanelLibrary lib) {
    }

    protected void registerLibrary(String dbObjectType, Class<? extends PanelLibrary> libClass) {
        this.m_libraryClasses.put(dbObjectType, libClass);
    }

    protected boolean registerOtherLibrary(String dbObjectType, DatabaseDescriptor otherDesc) {
        Class<? extends PanelLibrary> libClass;
        boolean retval = false;
        DBEditorFactory otherFac = DBEditorFactoryRegistry.findDatabaseFactory(otherDesc);
        if (otherFac instanceof BaseDBEditorFactory && (libClass = ((BaseDBEditorFactory)otherFac).m_libraryClasses.get(dbObjectType)) != null) {
            this.registerLibrary(dbObjectType, libClass);
            retval = true;
        }
        return retval;
    }

    protected void unregisterLibrary(String dbObjectType, Class<? extends PanelLibrary> libClass) {
        Class<? extends PanelLibrary> clz = this.m_libraryClasses.get(dbObjectType);
        if (clz != null) {
            if (clz.equals(libClass)) {
                this.m_libraryClasses.remove(dbObjectType);
                this.m_libraries.remove(dbObjectType);
            } else {
                DBLog.getLogger((Object)this).warning("Cannot remove library for " + dbObjectType + " as libClass doesn't match.");
            }
        }
    }

    @Override
    @Deprecated
    public String[] listSupportedTypes() {
        Collection<String> types = this.listSupportedTypesImpl();
        return types.toArray(new String[types.size()]);
    }

    @Deprecated
    protected Collection<String> listSupportedTypesImpl() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(this.m_libraryClasses.keySet());
        return retval;
    }

    @Override
    @Deprecated
    public boolean isCreateSupported(String dbObjectType) {
        return this.listSupportedTypesImpl().contains(dbObjectType);
    }

    @Override
    public boolean canCreateDBObject(Schema schema, DBObjectProvider pro, String dbObjectType) {
        boolean retval;
        boolean bl = retval = this.getPanelLibrary(pro, dbObjectType) != null;
        if (retval && Metadata.getInstance().isTypeOf(SystemObject.class, dbObjectType)) {
            retval = this.supportsObjectType(dbObjectType, pro);
        }
        return retval;
    }

    protected boolean supportsObjectType(String dbObjectType, DBObjectProvider pro) {
        return pro.supportsObjectType(dbObjectType);
    }

    private void throwConfigException(DBEditorConfig config, String missing) {
        throw new IllegalArgumentException("DBEditorConfig is missing: " + missing);
    }

    private String getUnsupportedErrorMessage(String type, String name) {
        return UIBundle.format("DBOBJECT_EDIT_OBJ_UNSUPPORTED", DBTypeDisplayRegistry.getSingularDisplayName(type), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void launchDialog(final DBEditorConfig config) {
        String type = config.getObjectType();
        DBObjectProvider pro = config.getProvider();
        if (pro == null) {
            this.throwConfigException(config, "DBObjectProvider");
        }
        String timestampKey = BaseDBEditorFactory.getTimestampKey(type) + System.nanoTime();
        DBUtil.suspendTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
        try {
            final PanelLibrary lib = this.getPanelLibrary(pro, type);
            if (lib == null) {
                config.setResult(DBEditorConfig.Result.ERROR);
                DBObjectNode node = config.getOriginalObjectNode();
                if (node != null) {
                    throw new DBException(null, this.getUnsupportedErrorMessage(type, node.getObjectName()));
                }
            } else {
                Runnable run;
                if (lib.prepareEditorInBackground(config)) {
                    DBUIProgressBar pbar = new DBUIProgressBar(ProviderOperator.getTitle(config));
                    run = pbar.execute(new DBUIProgressBar.ProgressCallable<Runnable, DBException>(){

                        @Override
                        public Runnable call() throws DBException {
                            return BaseDBEditorFactory.this.prepareEditorImpl(config, lib);
                        }
                    }, UIBundle.format("DBOBJECT_PREPARE_EDITOR", config.getOriginalObjectName()), null);
                    if (pbar.hasUserCancelled()) {
                        throw new CancelledException();
                    }
                } else {
                    run = this.prepareEditorImpl(config, lib);
                }
                run.run();
                this.checkCommit(config, lib);
            }
        }
        catch (CancelledException ce) {
            DBLog.getLogger((Object)this).fine(ce.getMessage());
            config.setResult(DBEditorConfig.Result.CANCELLED);
            config.setException((DBException)((Object)ce));
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), DBTypeDisplayRegistry.getDialogTitle(type, config.isEdit(), true), dbe);
            config.setResult(DBEditorConfig.Result.ERROR);
            config.setException(dbe);
        }
        finally {
            DBUtil.resumeTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
        }
    }

    private Runnable prepareEditorImpl(DBEditorConfig config, PanelLibrary lib) throws DBException {
        Runnable retval;
        DBObjectProvider pro = config.getProvider();
        String type = config.getObjectType();
        try {
            DBObjectID id;
            boolean edit;
            Schema schema = config.getSchema();
            SystemObject originalObject = config.getOriginalObject();
            boolean bl = edit = originalObject != null;
            if (edit) {
                if (lib.canReplaceByDefault()) {
                    config.setReplaceAlwaysAllowed(true);
                }
                if (lib.shouldResetObjectBeforeEdit(config)) {
                    DBUtil.forceObjectReset((SystemObject)originalObject, (DBObjectProvider)pro);
                }
            }
            SystemObject newObject = config.getUpdatedObject();
            if (edit && (!((id = newObject.getID()) instanceof TemporaryObjectID) || ((TemporaryObjectID)id).getOriginalObject() != originalObject)) {
                throw new IllegalStateException("newObject must be a temp copy of oldObject.");
            }
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (edit && !clz.isAssignableFrom(originalObject.getClass())) {
                Object child = config.getChildObject();
                if (child == null) {
                    child = lib.getObjectForCreate(schema, pro, (DBObject)newObject);
                    edit = false;
                } else if (TemporaryObjectID.findOriginalObject((DBObject)child) == null) {
                    edit = false;
                }
                config.setChildObject((DBObject)child);
            } else if (newObject == null) {
                SchemaObject contextObject = config.getContextObject();
                newObject = (SystemObject)lib.getObjectForCreate(schema, pro, (DBObject)contextObject);
                config.setUpdatedObject(newObject);
            }
            if (newObject.getName() == null) {
                lib.makeNameUnique((DBObject)newObject, schema, pro, null);
            }
            CancelledException.checkInterrupt();
            if (!lib.checkPrivilege(newObject, pro, edit)) {
                throw new DBException((DBObject)newObject, UIBundle.get("DBOBJECT_INSUFFICIENT_PRIVS"));
            }
            retval = this.prepareEditor(config, lib, edit);
        }
        catch (RuntimeException e) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to launch editor", e);
            config.setResult(DBEditorConfig.Result.ERROR);
            retval = null;
        }
        return retval;
    }

    protected Runnable prepareEditor(DBEditorConfig config, PanelLibrary lib, boolean edit) throws DBException {
        Runnable retval;
        config.setException(null);
        config.setResult(DBEditorConfig.Result.IN_PROGRESS);
        DBObjectProvider pro = config.getProvider();
        DBEditorFactory.EditorType editorType = this.determineEditorType(config);
        config.setEditorType(editorType);
        List<Navigable> navs = lib.getNavigables(config);
        if (navs == null) {
            Object objForNavs = config.isChildEditOnly() ? config.getChildObject() : config.getUpdatedObject();
            config.setResult(DBEditorConfig.Result.ERROR);
            if (!edit && TemplateExpander.isPendingObject((DBObject)objForNavs)) {
                String[] names = TemplateExpander.getTemplateObjectName((DBObject)objForNavs).split("\\.");
                throw new DBException(objForNavs, UIBundle.format("DBOBJECT_CREATE_INVALID_TEMPLATE", DBTypeDisplayRegistry.getSingularDisplayName(objForNavs.getType()), names[names.length - 1]));
            }
            throw new DBException(objForNavs, this.getUnsupportedErrorMessage(objForNavs.getType(), objForNavs.getName()));
        }
        Traversable mainPanel = lib.getMainDialogPanel(config, navs.toArray(new Navigable[navs.size()]));
        if (mainPanel == null) {
            retval = () -> lib.commitToProvider(config);
        } else {
            Namespace ns = this.createNamespace(config);
            ns.put(PanelLibrary.class.getName(), (Object)lib);
            String dialogName = (edit ? "edit" : "create") + config.getObjectType();
            String dialogTitle = edit ? lib.getEditTitle() : lib.getCreateTitle();
            Dimension libSize = lib.getSize(edit);
            Dimension size = libSize == null && navs.size() == 0 ? OracleDBEditorFactory.NO_PANELS_DIALOG_SIZE : libSize;
            lib.prepareObjectForEditor(config, navs);
            retval = () -> this.launchDialog(ns, dialogTitle, edit, mainPanel, lib, size, dialogName);
        }
        CancelledException.checkInterrupt();
        return retval;
    }

    private void checkCommit(DBEditorConfig config, PanelLibrary lib) {
        if (config.getResult() == DBEditorConfig.Result.SUCCESS) {
            this.commitPerformed(config, lib);
        }
    }

    protected DBEditorFactory.EditorType determineEditorType(DBEditorConfig config) {
        return config.isEdit() ? DBEditorFactory.EditorType.EDIT_MODAL : DBEditorFactory.EditorType.CREATE_MODAL;
    }

    public void commitPerformed(DBEditorConfig config, PanelLibrary lib) {
        if (lib.showEditorAfterCommit()) {
            BaseDBEditorFactory.showEditor(config);
        }
    }

    @Override
    public boolean canEditDBObject(DBObject obj, DBObjectProvider pro) {
        String dbObjectType;
        PanelLibrary lib;
        boolean retval = false;
        if (obj != null && (lib = this.getPanelLibrary(pro, dbObjectType = obj.getType())) != null && lib.canEditObject(obj, pro)) {
            retval = true;
        }
        return retval;
    }

    @Override
    public String getCreateLabel(String dbObjectType) {
        PanelLibrary lib = this.getPanelLibrary(null, dbObjectType);
        if (lib != null) {
            return lib.getCreateText();
        }
        return DBTypeDisplayRegistry.getNewMenuItemText(dbObjectType);
    }

    public Namespace createNamespace(DBEditorConfig config) {
        Namespace data = new Namespace();
        data.put(DBEditorConfig.class.getName(), (Object)config);
        DBObjectProvider provider = config.getProvider();
        data.put("oracle.javatools.db.DBObjectProvider", (Object)provider);
        SystemObject originalObject = config.getOriginalObject();
        boolean isEdit = originalObject != null;
        SystemObject newObject = config.getUpdatedObject();
        if (newObject != null) {
            data.put("OriginalObject", (Object)originalObject);
            data.put("NewObject", (Object)newObject);
            if (config.isChildEditOnly()) {
                data.put("NewChildObject", (Object)config.getChildObject());
            }
            boolean editable = !isEdit || !config.isCommitToProvider() || this.canUpdateObject((DBObject)newObject, provider);
            config.setEditable(editable);
            Schema schema = DBUtil.getSchema((DBObject)newObject);
            data.put("oracle.javatools.db.Schema", (Object)schema);
        }
        return data;
    }

    protected boolean canUpdateObject(DBObject obj, DBObjectProvider pro) {
        return true;
    }

    private void launchDialog(Namespace data, String title, boolean edit, Traversable panel, PanelLibrary lib, Dimension size, String dialogName) {
        Component parent = DBMessageDialog.getDialogParent();
        TraversableProxy proxyPanel = new TraversableProxy(panel);
        TDialogLauncher launcher = new TDialogLauncher(parent, title, (Traversable)proxyPanel, data);
        if (size != null) {
            launcher.setInitialSize(size);
        }
        JEWTDialog dialog = launcher.initDialog();
        dialog.setName(dialogName);
        data.put(JEWTDialog.class.getName(), (Object)dialog);
        if (Boolean.getBoolean("ide.db.liveValidate") && data.get(DBValidationManager.class) == null) {
            data.put(DBValidationManager.class.getName(), (Object)new ModalValidationManager(dialog));
        }
        DBEditorConfig config = (DBEditorConfig)data.find(DBEditorConfig.class);
        dialog.setOKButtonEnabled(config.isEditable());
        Component header = this.getDialogHeader(config);
        if (header != null) {
            dialog.setDialogHeader(header);
        }
        proxyPanel.enable();
        Component initialFocus = lib.getInitialFocus(panel);
        if (initialFocus != null) {
            dialog.setInitialFocus(initialFocus);
        }
        if (!launcher.showDialog() && config.getResult() == DBEditorConfig.Result.IN_PROGRESS) {
            config.setResult(DBEditorConfig.Result.CANCELLED);
        }
    }

    protected Component getDialogHeader(DBEditorConfig config) {
        return null;
    }

    public static String getTimestampKey(String type) {
        return type + "EditDialog";
    }

    public static boolean isCreateContext(Context ideContext) {
        return Boolean.TRUE.equals(ideContext.getProperty(CREATE_CONTEXT_PROP));
    }

    public static void setEditorType(DBEditorConfig config, DBEditorFactory.EditorType editorType) {
        if (config != null) {
            config.setEditorType(editorType);
        }
    }

    public static void showEditor(final DBEditorConfig config) {
        final DBObjectProvider pro = config.getProvider();
        final SystemObject newObject = config.getUpdatedObject();
        URL url = DBURLFactory.getURL(pro, newObject);
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (Exception e) {
            DBLog.getLogger(BaseDBEditorFactory.class).log(DBLog.getExceptionLogLevel(), "Error finding object node.", e);
        }
        if (node != null) {
            Context context;
            final EditorManager editorManager = EditorManager.getEditorManager();
            List eds = editorManager.findEditors(context = Context.newIdeContext((Node)node));
            if (eds != null) {
                for (Editor ed : eds) {
                    if (!(ed instanceof DBObjectOverviewEditor)) continue;
                    ((DBObjectOverviewEditor)ed).changeEditorConfig(config);
                    break;
                }
            }
            if (config.getOriginalObject() == null) {
                context.setProperty(CREATE_CONTEXT_PROP, (Object)Boolean.TRUE);
            } else {
                DBEditorConfig.setConfig(context, config);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    block9: {
                        if (newObject instanceof SourceObject) {
                            int offset = 0;
                            if (newObject instanceof PlSqlSourceObject) {
                                DBUIProgressBar pb = new DBUIProgressBar(UIBundle.get("PLSQL_FINDING_OFFSET"));
                                DBUIProgressBar.ProgressCallable<Integer, CancelledException> pc = new DBUIProgressBar.ProgressCallable<Integer, CancelledException>(){

                                    @Override
                                    public Integer call() throws CancelledException {
                                        Integer retval = null;
                                        PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)((PlSqlSourceObject)newObject), (DBObjectProvider)pro);
                                        if (parser != null) {
                                            Object[] parseNodes;
                                            DBObjectPlSqlFragment frag = (DBObjectPlSqlFragment)newObject;
                                            DBObject child = config.getChildObject();
                                            if (child instanceof DBObjectPlSqlFragment) {
                                                frag = (DBObjectPlSqlFragment)child;
                                                retval = frag.getStartOffset();
                                            } else {
                                                retval = parser.getStartOffsetOfObject();
                                            }
                                            String property = config.getProperty();
                                            if (property != null && (parseNodes = parser.getPropertyNodes(frag, property)).length > 0) {
                                                retval = parser.getStartOffset(parseNodes[0]);
                                            }
                                        }
                                        return retval;
                                    }
                                };
                                try {
                                    Integer betterOffset = pb.execute(pc);
                                    if (betterOffset != null) {
                                        offset = betterOffset;
                                    }
                                }
                                catch (CancelledException cancelledException) {
                                    // empty catch block
                                }
                            }
                            try {
                                NavigationManager mgr = NavigationManager.getNavigationManager();
                                OffsetNavigationPoint point = new OffsetNavigationPoint(context, offset, 0);
                                point.setPreferredEditorType(null);
                                if (mgr != null) {
                                    mgr.navigateTo((NavigationPoint)point);
                                    break block9;
                                }
                                point.navigate();
                            }
                            catch (Exception e) {
                                DBLog.getLogger((Object)this).log(DBLog.getExceptionLogLevel(), "Error opening editor.", e);
                            }
                        } else {
                            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                            openEditorOptions.setEditorClass(DBObjectOverviewEditor.class);
                            editorManager.openEditor(openEditorOptions);
                        }
                    }
                }
            });
        }
    }
}

