/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.event;

import javax.swing.SwingUtilities;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;

public abstract class SwingDBObjectListener
extends DBObjectListener {
    public final void objectUpdated(final DBObjectChange change) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateUI(change);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        SwingDBObjectListener.this.updateUI(change);
                    }
                    catch (Exception e) {
                        DBLog.getLogger((Object)((Object)SwingDBObjectListener.this)).log(DBLog.getExceptionLogLevel(), "Listener threw unhandled exception", e);
                    }
                }
            });
        }
    }

    protected abstract void updateUI(DBObjectChange var1);
}

