/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.execute;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.internal.DBCore;
import org.openide.util.RequestProcessor;

public class DBRequestProcessorFactory {
    private final ReentrantLock m_scheduleLock = new ReentrantLock();
    private Timer m_timer;
    private ExecutorService m_dbExecutor;
    private final Map<String, DBRequestProcessor> m_nodeExecutors = new HashMap<String, DBRequestProcessor>();
    private final NodeListener m_listener = new NodeListener(){

        public void nodeWillClose(NodeEvent e) {
            Node node = e.getNode();
            if (node instanceof DBObjectNode) {
                DBRequestProcessorFactory.this.m_scheduleLock.lock();
                try {
                    DBRequestProcessorFactory.this.shutdown((DBObjectNode)node, null);
                }
                finally {
                    DBRequestProcessorFactory.this.m_scheduleLock.unlock();
                }
            }
        }
    };

    Timer getTimer() {
        assert (this.m_scheduleLock.isHeldByCurrentThread());
        if (this.m_timer == null) {
            this.m_timer = new Timer(this.getClass().getSimpleName() + "_Timer", true);
        }
        return this.m_timer;
    }

    private ExecutorService getDatabaseExecutor() {
        assert (this.m_scheduleLock.isHeldByCurrentThread());
        if (this.m_dbExecutor == null) {
            this.m_dbExecutor = DatabaseUIExtensionHook.getHook().getDBExecutor();
            if (this.m_dbExecutor == null) {
                this.m_dbExecutor = new RequestProcessor("DBRequestProcessor_DatabaseProcessor", 1, true);
            }
        }
        return this.m_dbExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBRequestProcessor getNodeProcessor(DBObjectNode node) {
        this.m_scheduleLock.lock();
        try {
            String key = this.getKey(node);
            DBRequestProcessor retval = this.m_nodeExecutors.get(key);
            if (retval == null) {
                String proType = node.getProviderType();
                ExecutorService executor = "db".equals(proType) ? this.getDatabaseExecutor() : null;
                retval = new DBRequestProcessor(executor, node, this.m_scheduleLock);
                this.m_nodeExecutors.put(key, retval);
                if (node instanceof Node) {
                    ((Node)node).addNodeListener(this.m_listener);
                }
            }
            DBRequestProcessor dBRequestProcessor = retval;
            return dBRequestProcessor;
        }
        finally {
            this.m_scheduleLock.unlock();
        }
    }

    private void shutdown(DBObjectNode node, DBRequestProcessor proc) {
        assert (this.m_scheduleLock.isHeldByCurrentThread());
        if (node instanceof Node) {
            ((Node)node).removeNodeListener(this.m_listener);
        }
        String key = this.getKey(node);
        if (proc == null) {
            proc = this.m_nodeExecutors.remove(key);
        } else {
            DBRequestProcessor cached = this.m_nodeExecutors.get(key);
            if (cached == proc) {
                this.m_nodeExecutors.remove(key);
            }
        }
        if (proc != null) {
            proc.shutdown();
        }
        if (this.m_nodeExecutors.isEmpty() && this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
    }

    private String getKey(DBObjectNode node) {
        return node.getURL().toString();
    }

    void notifyProcessorEmpty(DBObjectNode node, DBRequestProcessor proc) {
        if (!(node instanceof Node) || !((Node)node).isOpen()) {
            this.shutdown(node, proc);
        }
    }

    static synchronized DBRequestProcessorFactory getInstance() {
        DBCore core = DBCore.getInstance();
        DBRequestProcessorFactory retval = (DBRequestProcessorFactory)core.get(DBRequestProcessorFactory.class);
        if (retval == null) {
            retval = new DBRequestProcessorFactory();
            core.put((Object)retval);
        }
        return retval;
    }

    public static DBRequestProcessor getProcessor(DBObjectNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        return DBRequestProcessorFactory.getInstance().getNodeProcessor(node);
    }
}

