/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.ide.db.insight.model.DBInsightProvider;
import oracle.ide.db.insight.model.ParentLocator;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.token.Token;

class SQLParentLocator
extends ParentLocator {
    SQLParentLocator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected DBObject getParent(List<String> names) throws CancelledException {
        PlSqlToken tkEnd;
        PlSqlToken tkStart;
        DBObject context;
        DBObjectProvider pro;
        ArrayList<String> namesCopy;
        block24: {
            block23: {
                PlSqlStatement.Type type;
                block26: {
                    PlSqlToken tk;
                    block25: {
                        PlSqlParser parser;
                        DBObjectPlSqlFragment frag;
                        namesCopy = new ArrayList<String>();
                        namesCopy.addAll(names);
                        pro = this.getProvider();
                        context = this.getContextObjectAtOffset();
                        tkStart = null;
                        tkEnd = null;
                        if (!(context instanceof DBObjectPlSqlFragment)) break block23;
                        PlSqlSourceObject so = (PlSqlSourceObject)DBUtil.getUppermostParent((DBObject)context);
                        for (frag = (DBObjectPlSqlFragment)context; frag != null && !(frag instanceof PlSqlStatement); frag = (DBObjectPlSqlFragment)frag.getParent()) {
                        }
                        if (!(frag instanceof PlSqlStatement) || (parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)so, (DBObjectProvider)pro)) == null) break block24;
                        type = ((PlSqlStatement)frag).getStatementType();
                        tk = parser.getTokenAtOffset(frag.getStartOffset().intValue());
                        if (type != PlSqlStatement.Type.STATEMENT) break block25;
                        if (this.isSQL(tk)) {
                            tkStart = tk;
                            tkEnd = parser.getTokenAtOffset(frag.getEndOffset().intValue());
                        }
                        break block24;
                    }
                    if (type != PlSqlStatement.Type.FOR_LOOP) break block26;
                    PlSqlSearch search = new PlSqlSearch("for ? in <sel (...)> loop");
                    if (search.matches(tk)) {
                        tkStart = (PlSqlToken)search.getNamedMatchStartToken("sel").getNextCodeToken();
                        tkEnd = (PlSqlToken)search.getNamedMatchEndToken("sel").getPrevCodeToken();
                    }
                    break block24;
                }
                if (type == PlSqlStatement.Type.CURSOR) break block24;
                break block24;
            }
            PlSqlToken tk = PlSqlTokenizer.tokenize((String)this.getText(), (String[])new String[0]);
            if (!tk.isCode()) {
                tk = (PlSqlToken)tk.getNextCodeToken();
            }
            if (this.isSQL(tk)) {
                tkStart = tk;
                tkEnd = tk;
                while (!((PlSqlToken)tkEnd.getNextToken()).isEndMarker()) {
                    tkEnd = (PlSqlToken)tkEnd.getNextToken();
                }
            }
        }
        if (tkStart != null) {
            SqlAliasExpander ex = pro.getDescriptor().getSqlAliasExpander(pro, this.getSchema());
            boolean done = false;
            try {
                Collection usages = ex.getUsages(tkStart, tkEnd);
                done = this.updateParents(namesCopy, usages, this.getOffset() - 1, this.getSearchString());
            }
            catch (IllegalArgumentException iae) {
                done = true;
            }
            if (!done) {
                int insertPos = this.getOffset() - tkStart.getStart();
                String dummyCol = "X";
                if (this.getSearchString().length() == 0 && insertPos != 0) {
                    StringBuilder sb = new StringBuilder(tkStart.getSource(false, (Token)tkEnd));
                    if (insertPos < sb.length()) {
                        sb.insert(insertPos, "X");
                    } else {
                        sb.append("X");
                    }
                    try {
                        Collection usages2 = ex.getUsages(sb.toString());
                        this.updateParents(namesCopy, usages2, insertPos, "X");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        if (namesCopy.size() > 0) {
            List<DBObjectID> refs;
            try {
                refs = PlSqlUtil.findReferences(namesCopy, (DBObjectProvider)this.getProvider(), (DBObject)context);
            }
            catch (CancelledException ce) {
                throw ce;
            }
            catch (DBException dbe) {
                this.getLogger().warning(dbe.getMessage());
                refs = Collections.emptyList();
            }
            DBObject bestObj = null;
            for (DBObjectID refId : refs) {
                CancelledException.checkInterrupt();
                DBObject obj = DBInsightProvider.resolveIDForInsight(refId);
                if (obj == null) continue;
                if (bestObj == null) {
                    bestObj = obj;
                    continue;
                }
                if (bestObj instanceof PlSqlDatum && !(obj instanceof PlSqlDatum)) {
                    bestObj = obj;
                    continue;
                }
                if (!(bestObj instanceof PlSqlDatum) || bestObj instanceof PlSqlAttribute || !(obj instanceof PlSqlAttribute)) continue;
                bestObj = obj;
            }
            if (bestObj != null) {
                return bestObj;
            }
        }
        return super.getParent(names);
    }

    private boolean isSQL(PlSqlToken token) {
        return token.matches("select") || token.matches("with") || token.matches("insert") || token.matches("update") || token.matches("delete");
    }

    private boolean updateParents(List<String> names, Collection<SqlAliasExpander.Usage> usages, int pos, String match) {
        for (SqlAliasExpander.Usage usage : usages) {
            if (usage.getStartOffset() > pos || usage.getEndOffset() < pos || !((String)usage.getTokens().get(usage.getTokens().size() - 1)).startsWith(match)) continue;
            names.clear();
            for (int i = 0; i < usage.getTokens().size() - 1; ++i) {
                names.add(this.getProvider().getInternalName((String)usage.getTokens().get(i)));
            }
            return true;
        }
        return false;
    }
}

