/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import oracle.ide.db.insight.model.InsightDataProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;

public class SchemaProvider
extends InsightDataProvider {
    @Override
    public void addItems(DBObject parent) throws CancelledException {
        if (parent == null) {
            boolean showAll = !this.m_DBInsightProvider.isUserOnly();
            try {
                DatabaseDescriptor desc = this.getProvider().getDescriptor();
                String pub = desc.getPublicSchemaName();
                for (Schema schema : this.getProvider().listSchemas(showAll)) {
                    CancelledException.checkInterrupt();
                    if (desc.areNamesEqual(schema.getName(), pub, "SCHEMA", false)) continue;
                    this.addDBObject((DBObject)schema);
                }
            }
            catch (CancelledException ce) {
                throw ce;
            }
            catch (DBException e) {
                this.getLogger().warning(e.getMessage());
            }
        }
    }
}

