/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;

public class MDDEditorPanel
extends TabbedEditorPanel {
    private int m_simpleAdvancedPanelThreshold = 2;
    private MDDPanel m_mddPanel;

    public MDDEditorPanel(Traversable top, Navigable[] navs, String startPage, int panelThreshold) {
        this(top, navs, startPage);
        this.m_simpleAdvancedPanelThreshold = panelThreshold;
    }

    public MDDEditorPanel(Traversable top, Navigable[] navs, String startPage) {
        super(top, navs, startPage);
    }

    @Override
    protected Traversable createPanel(Navigable[] navs) {
        MDDPanel retval = null;
        if (navs != null) {
            boolean childrenExist = false;
            for (int i = 0; i < navs.length; ++i) {
                Navigable[] children = navs[i].getChildren();
                if (children == null || children.length <= 0) continue;
                childrenExist = true;
                break;
            }
            if (!childrenExist && navs.length <= this.m_simpleAdvancedPanelThreshold) {
                return super.createPanel(navs);
            }
            if (this.m_mddPanel == null) {
                this.m_mddPanel = new MDDP(navs);
                this.m_mddPanel.setChildComparator(null);
                this.m_mddPanel.setDefaultChildComparator(Navigable.NAVIGABLE_COMPARATOR);
                this.m_mddPanel.setTitleDepth(0);
            } else {
                this.m_mddPanel.setRootNavigables(navs);
            }
            retval = this.m_mddPanel;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void enterMiddlePanel(Traversable middle, String startPage, boolean firstEntry) {
        if (middle instanceof MDDPanel) {
            MDDPanel mdd = (MDDPanel)middle;
            boolean selectionDelay = mdd.enableSelectionDelay(false);
            try {
                super.enterMiddlePanel(middle, startPage, firstEntry);
                mdd.expandTree1ToDepth(2);
                if (!firstEntry || startPage == null) return;
                String[] selectionPath = startPage.split("/");
                mdd.setTree1SelectionPath(selectionPath);
                return;
            }
            finally {
                mdd.enableSelectionDelay(selectionDelay);
            }
        } else {
            super.enterMiddlePanel(middle, startPage, firstEntry);
        }
    }

    @Override
    public Navigable getCurrentNavigable() {
        Navigable retval = this.m_mddPanel instanceof MDDP ? ((MDDP)this.m_mddPanel).getCurrentNavigable() : super.getCurrentNavigable();
        return retval;
    }

    private static class MDDP
    extends MDDPanel {
        public MDDP(Navigable[] navs) {
            super(navs);
        }

        public Navigable getCurrentNavigable() {
            return super.getCurrentNavigable();
        }
    }
}

