/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.TabbedPaneUI;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TabbedPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.DBTabbedPanel;
import oracle.javatools.db.DBLog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.FlatTabbedPaneUI;
import oracle.javatools.util.ModelUtil;

public class TabbedEditorPanel
extends DefaultTraversablePanel
implements DBTraversable {
    private final Traversable m_top;
    private Navigable[] m_navs;
    private String m_startPage;
    private final Map<String, Navigable> m_allNavs = new HashMap<String, Navigable>();
    private final PanelLibrary.PanelSetChanger m_changer = (navs, validator) -> this.changeNavigables(navs, validator);
    private Traversable m_middle;
    private TraversableContext m_data;
    private boolean m_firstEntry = true;
    private boolean m_entered;

    public TabbedEditorPanel(Traversable top, Navigable[] navs2, String startPage) {
        this.m_top = top;
        this.m_navs = navs2;
        this.setStartPage(startPage);
        this.setLayout(new BorderLayout(0, 10));
    }

    private boolean areDifferent(Navigable[] navs1, Navigable[] navs2) {
        boolean retval = true;
        if (navs1.length == navs2.length) {
            retval = false;
            for (int i = 0; i < navs1.length; ++i) {
                if (!ModelUtil.areDifferent((Object)navs1[i].getShortLabel(), (Object)navs2[i].getShortLabel())) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    @Override
    public Component getDefaultFocusComponent() {
        Component c;
        if (this.m_top instanceof DBTraversable && (c = ((DBTraversable)this.m_top).getDefaultFocusComponent()) != null && c.isEnabled()) {
            return c;
        }
        if (this.m_middle instanceof DBTraversable && (c = ((DBTraversable)this.m_middle).getDefaultFocusComponent()) != null && c.isEnabled()) {
            return c;
        }
        return null;
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        boolean retval = false;
        if (this.m_top instanceof DBTraversable) {
            retval = ((DBTraversable)this.m_top).requestFocusForEditorConfig();
        }
        if (!retval && this.m_middle instanceof DBTraversable) {
            retval = ((DBTraversable)this.m_middle).requestFocusForEditorConfig();
        }
        return retval;
    }

    protected Traversable createPanel(Navigable[] navs) {
        Traversable retval = null;
        if (navs != null) {
            if (navs.length == 1) {
                retval = navs[0].newTraversable(null);
                if (retval instanceof DefaultTraversablePanel) {
                    ((DefaultTraversablePanel)retval).setHelpID(MetaTraversable.findHelpID((MetaTraversable)navs[0], (Traversable)retval));
                }
            } else if (navs.length > 0) {
                retval = this.isInFlatEditor() ? new DBTabbedPanel(navs, (TabbedPaneUI)new FlatTabbedPaneUI()) : new DBTabbedPanel(navs);
            }
        }
        return retval;
    }

    private boolean isInModalDialog() {
        boolean retval = false;
        DBEditorConfig config = (DBEditorConfig)this.m_data.find(DBEditorConfig.class);
        if (config != null) {
            DBEditorFactory.EditorType editorType = config.getEditorType();
            retval = editorType == DBEditorFactory.EditorType.EDIT_MODAL || editorType == DBEditorFactory.EditorType.CREATE_MODAL;
        }
        return retval;
    }

    private boolean isInFlatEditor() {
        DBEditorConfig config;
        boolean retval = false;
        if (this.m_data != null && (config = (DBEditorConfig)this.m_data.find(DBEditorConfig.class)) != null) {
            retval = config.isInFlatEditor();
        }
        return retval;
    }

    public String getHelpID() {
        if (this.m_middle != null) {
            return this.m_middle.getHelpID();
        }
        return super.getHelpID();
    }

    private void layoutComponents() {
        DBEditorConfig config = (DBEditorConfig)this.m_data.find(DBEditorConfig.class);
        String baseName = (config.isEdit() ? "edit" : "create") + config.getObjectType();
        this.setName(baseName);
        if (this.m_navs != null) {
            this.layoutMiddle(this.m_navs);
        }
        if (this.m_top != null) {
            JPanel header = new JPanel(new GridBagLayout());
            header.setName(baseName + ".header");
            header.add(this.m_top.getComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
            if (this.isInModalDialog()) {
                JLabel iconLabel = new JLabel();
                iconLabel.setIcon(OracleIcons.getIcon((String)"header/database.png"));
                header.add((Component)iconLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            if (this.m_middle == null) {
                this.add(header, "Center");
            } else {
                this.add(header, "North");
            }
        }
    }

    private void changeNavigables(Navigable[] navs, PanelLibrary.PanelSetChangeValidator validator) throws TraversalException {
        boolean changed;
        Navigable current = this.getCurrentNavigable();
        boolean bl = changed = navs != null && (this.m_navs == null || this.areDifferent(navs, this.m_navs));
        if (changed && this.m_middle != null && this.m_entered) {
            try {
                this.m_middle.onExit(this.m_data);
            }
            catch (TraversalException te) {
                this.m_middle.onEntry(this.m_data);
                throw te;
            }
        }
        if (validator != null) {
            validator.validatePanelChange(this.m_data);
        }
        if (changed) {
            this.m_navs = navs;
            if (current != null) {
                this.setStartPage(current.getShortLabel());
            }
            this.layoutMiddle(navs);
            if (this.m_entered) {
                this.enterPanel(this.m_middle);
                this.revalidate();
            }
        }
    }

    private void layoutMiddle(Navigable[] navs) {
        for (int i = 0; i < navs.length; ++i) {
            Navigable nav = navs[i];
            String title = nav.getShortLabel();
            Navigable cached = this.m_allNavs.get(title);
            if (cached == null) {
                this.m_allNavs.put(title, nav);
                continue;
            }
            navs[i] = cached;
        }
        if (this.m_middle != null) {
            this.remove(this.m_middle.getComponent());
        }
        this.m_middle = this.createPanel(navs);
        if (this.m_middle != null) {
            Component comp = this.m_middle.getComponent();
            comp.setName("DEFAULT_PANEL");
            this.add(comp, "Center");
        }
    }

    protected void enterPanel(Traversable panel) {
        if (panel != null) {
            if (panel == this.m_middle) {
                this.enterMiddlePanel(this.m_middle, this.m_startPage, this.m_firstEntry);
                this.m_firstEntry = false;
            } else {
                panel.onEntry(this.m_data);
            }
        }
    }

    public void onEntry(TraversableContext data) {
        this.m_data = data;
        this.m_data.put(PanelLibrary.PanelSetChanger.class.getName(), (Object)this.m_changer);
        if (this.m_firstEntry) {
            this.layoutComponents();
        }
        this.enterPanel(this.m_top);
        this.enterPanel(this.m_middle);
        this.m_firstEntry = false;
        this.m_entered = true;
    }

    public void setStartPage(String startPage) {
        this.m_startPage = startPage;
        this.m_firstEntry = true;
    }

    protected void enterMiddlePanel(Traversable middle, String startPage, boolean firstEntry) {
        if (firstEntry && startPage != null && middle instanceof TabbedPanel) {
            Integer idx = null;
            for (int i = 0; i < this.m_navs.length; ++i) {
                if (!ModelUtil.areEqual((Object)startPage, (Object)this.m_navs[i].getShortLabel())) continue;
                idx = i;
                break;
            }
            if (idx != null) {
                this.m_data.putDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX", idx);
            }
            middle.onEntry(this.m_data);
            this.m_data.putDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX", null);
        } else {
            middle.onEntry(this.m_data);
        }
    }

    public void onExit(TraversableContext data) throws TraversalException {
        try {
            if (this.m_middle != null) {
                this.m_middle.onExit(data);
            }
            if (this.m_top != null) {
                this.m_top.onExit(data);
            }
            if (!this.isInFlatEditor()) {
                this.commitToProvider(data);
            }
            this.m_entered = false;
        }
        catch (TraversalException te) {
            this.enterPanel(this.m_top);
            this.enterPanel(this.m_middle);
            throw te;
        }
    }

    protected final void commitToProvider(TraversableContext data) throws TraversalException {
        DBEditorConfig config = (DBEditorConfig)data.find(DBEditorConfig.class);
        if (!config.isUseBackgroundTask()) {
            PanelLibrary pl = (PanelLibrary)data.find(PanelLibrary.class);
            if (pl == null) {
                DBLog.getLogger((Object)this).severe("No PanelLibrary in context, cannot commit");
            } else {
                try {
                    pl.commitToProvider(config);
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)pl).log(Level.SEVERE, "Unexpected error commiting to provider: " + e.getMessage(), e);
                }
            }
            if (config.getResult() != DBEditorConfig.Result.SUCCESS) {
                throw new TraversalException(null);
            }
        }
    }

    public final Traversable getTop() {
        return this.m_top;
    }

    protected final Traversable getMiddle() {
        return this.m_middle;
    }

    public Navigable getCurrentNavigable() {
        Navigable retval = null;
        if (this.m_middle instanceof DBTabbedPanel) {
            retval = ((DBTabbedPanel)this.m_middle).getCurrentNavigable();
        }
        return retval;
    }
}

