/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ide.db.panels.sql.tester.TesterPanel;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Database;

abstract class MessageTesterComponent
extends TesterComponent {
    private final JPanel m_panel = new JPanel();
    private final JTextArea m_txtMsg = new JTextArea();

    public MessageTesterComponent(String panelName, String labelText) {
        DBUIResourceHelper reshelp = new DBUIResourceHelper(panelName);
        this.m_panel.setLayout(new BorderLayout());
        this.m_panel.add((Component)TesterPanel.newChildPanel(this.m_txtMsg, labelText, "Result", reshelp, this.m_panel), "Center");
        this.m_txtMsg.setLineWrap(true);
        this.m_txtMsg.setWrapStyleWord(true);
    }

    protected void setMessageText(final String msg) {
        if (SwingUtilities.isEventDispatchThread()) {
            MessageTesterComponent.setText(this.m_txtMsg, msg);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageTesterComponent.setText(MessageTesterComponent.this.m_txtMsg, msg);
                }
            });
        }
    }

    protected void runTest(final Database db, final String sqlQuery) {
        this.setMessageText(UIBundle.get("TESTSQL_RUNNING"));
        final ProgressBar pbar = new ProgressBar((Component)this.m_panel, this.getName(), null, true);
        pbar.setRunnable(new Runnable(){

            @Override
            public void run() {
                MessageTesterComponent.this.doTestSQL(db, sqlQuery);
                pbar.setDoneStatus();
            }
        });
        pbar.start(null, null, 1500);
    }

    protected abstract void doTestSQL(Database var1, String var2);

    @Override
    public Component getComponent() {
        return this.m_panel;
    }

    static void setText(JTextArea area, String txt) {
        area.setText(txt);
        area.setCaretPosition(0);
    }
}

