/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.db.panels.sql.tester.DCNTesterComponent;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ide.db.panels.sql.tester.TesterPanel;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideri.util.Product;
import oracle.javatools.db.Database;

public class SQLQueryTester {
    private static final String QUERY_RESULTS_ID = "queryResults";
    private static final String EXPLAIN_PLAN_ID = "explainPlan";
    private final Database m_db;
    private final Map<String, Object> m_bindVariables = new TreeMap<String, Object>();
    private final boolean m_dbOnly;
    private Context m_ideContext;
    private boolean m_showPicker = true;
    private String m_storeName;
    private Result m_result;

    public SQLQueryTester(Database db) {
        this(db, false);
    }

    public SQLQueryTester(Database db, boolean dbOnly) {
        this.m_db = db;
        if (db != null) {
            this.setDefaultConnectionStore(db.getConnectionStore());
        }
        this.m_dbOnly = Product.isRaptor() || dbOnly;
    }

    private String getTitle() {
        return UIBundle.get("TESTSQL_TITLE");
    }

    public void setBindVariables(Map<String, ?> bindVariables) {
        this.m_bindVariables.clear();
        if (bindVariables != null) {
            this.m_bindVariables.putAll(bindVariables);
        }
    }

    public Map<String, Object> getBindVariables() {
        return this.m_bindVariables;
    }

    public Context getContext() {
        return this.m_ideContext == null ? Context.newIdeContext() : this.m_ideContext;
    }

    public void setContext(Context ideContext) {
        this.m_ideContext = ideContext;
    }

    public void setShowConnectionPicker(boolean showPicker) {
        this.m_showPicker = showPicker;
    }

    public String getDefaultConnectionStore() {
        return this.m_storeName;
    }

    public void setDefaultConnectionStore(String storeName) {
        this.m_storeName = storeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result showDialog(Component owner, final String sqlText) {
        final TesterPanel panel = new TesterPanel(this);
        panel.setBindVariables(this.m_bindVariables);
        panel.setShowConnectionPicker(this.m_showPicker);
        DatabaseUIExtensionHook hook = DatabaseUIExtensionHook.getHook();
        if (hook != null) {
            ArrayList<String> panelIDs = new ArrayList<String>();
            panelIDs.add(QUERY_RESULTS_ID);
            panelIDs.add(EXPLAIN_PLAN_ID);
            if (!this.m_dbOnly) {
                for (String id : hook.getSQLTesterComponentIDs()) {
                    if (panelIDs.contains(id)) continue;
                    panelIDs.add(id);
                }
            }
            for (String id : panelIDs) {
                TesterComponent tc = hook.getSQLTesterComponent(id);
                if (tc == null) continue;
                tc.setTester(this);
                panel.addPanel(tc);
            }
        }
        if (!this.m_dbOnly) {
            panel.addPanel(new DCNTesterComponent());
        }
        int buttonMask = 20;
        final JEWTDialog dialog = JEWTDialog.createDialog((Component)owner, (String)this.getTitle(), (int)20);
        dialog.setName("LiveSQLTestDialog");
        dialog.setMinimumSize(new Dimension(500, 400));
        dialog.setPreferredSize(new Dimension(500, 600));
        dialog.setResizable(true);
        dialog.setContent((Component)panel);
        dialog.setButtonMask(20);
        dialog.setDefaultButton(16);
        dialog.setInitialFocus(panel.getDefaultFocusComponent());
        dialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent we) {
                panel.testSQL(SQLQueryTester.this.m_db, sqlText);
                dialog.removeWindowListener((WindowListener)this);
            }
        });
        try {
            dialog.runDialog();
        }
        finally {
            panel.close();
            dialog.dispose();
        }
        return panel.getResult();
    }

    @Deprecated
    public void setSQLText(String txt) {
    }

    @Deprecated
    public static void registerComponent(Class<? extends TesterComponent> clz) {
    }

    public static class Result {
        private String m_query;
        private boolean m_result;
        private String m_msg;
        private Integer m_offset;

        Result(String query, boolean result, String msg, Integer offset) {
            this.m_query = query;
            this.m_result = result;
            this.m_msg = msg;
            this.m_offset = offset;
        }

        public String getQuery() {
            return this.m_query;
        }

        public boolean getResult() {
            return this.m_result;
        }

        public String getMessage() {
            return this.m_msg;
        }

        public Integer getOffset() {
            return this.m_offset;
        }
    }
}

