/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.db.DBObjectActions;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.ideimpl.db.ceditor.PlSqlQueryTester;
import oracle.ideimpl.db.ceditor.PlSqlSpecAndBodySynchronizer;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;

class DBObjectActionsController
implements Controller {
    DBObjectActionsController() {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        DBObjectProvider pro;
        Node node;
        boolean retval = false;
        int cmdID = action.getCommandId();
        if (cmdID == DBObjectActions.getDuplicateAction().getCommandId()) {
            retval = true;
            DBObjectNode node2 = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
            if (node2 != null) {
                DBObject template = node2.getDBObject();
                DBObjectProvider pro2 = node2.getProvider();
                SystemObject sysObj = DBUtil.getSystemObject((DBObject)template);
                if (sysObj != null) {
                    try {
                        template = DBUtil.getProviderDefinition((DBObject)template, (DBObjectProvider)pro2);
                    }
                    catch (DBException e) {
                        DBLog.getLogger((Object)this).log(Level.WARNING, "Error checking object is latest version: " + e.getMessage());
                    }
                    DBObject newObj = pro2.getObjectFactory().newObject(template);
                    DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory(newObj, pro2);
                    if (fac != null) {
                        DBEditorConfig config;
                        if (!(newObj instanceof SystemObject) && newObj instanceof ChildDBObject) {
                            SystemObject original = sysObj;
                            config = DBEditorConfig.newEditConfig(pro2, (DBObject)original);
                            SystemObject newSysObject = config.getUpdatedObject();
                            ((ChildDBObject)newObj).setParent((DBObject)newSysObject);
                            config.setObjectType(newObj.getType());
                            config.setChildEditOnly(true);
                            config.setChildObject(newObj);
                        } else {
                            config = DBEditorConfig.newCreateConfig(pro2, newObj);
                        }
                        fac.launchDialog(config);
                    }
                }
            }
        } else if (cmdID == DBObjectActions.getNewObjectAction().getCommandId()) {
            DBEditorFactory fac;
            retval = true;
            DBObjectTypeNode node3 = DBObjectNodeUtil.getSelectedElement(context, DBObjectTypeNode.class);
            if (node3 != null && (fac = DBEditorFactoryRegistry.getCreateFactory(node3)) != null) {
                fac.launchDialog(DBEditorConfig.newCreateConfig(node3));
            }
        } else if (cmdID == DBObjectActions.getPropertiesAction().getCommandId()) {
            DBObjectNode node4 = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
            if (node4 != null && DBObjectNodeUtil.isOnlineNode(node4)) {
                retval = true;
                DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory(node4);
                if (fac != null) {
                    fac.editDBObject(node4);
                }
            }
        } else if (cmdID == DBObjectActions.getSynchronizeSpecAndBody().getCommandId()) {
            retval = true;
            Node node5 = context.getNode();
            if (node5 instanceof BaseDBObjectTextNode) {
                View view = context.getView();
                Integer offset = view instanceof CodeEditor ? Integer.valueOf(((CodeEditor)view).getSelectionStart()) : null;
                PlSqlSpecAndBodySynchronizer.launch((BaseDBObjectTextNode)node5, offset);
            }
        } else if (cmdID == DBObjectActions.getTestQueryAction().getCommandId()) {
            retval = true;
            PlSqlQueryTester.invokeTestQuery(context);
        } else if (cmdID == IdeActions.getViewRefreshAction().getCommandId() && DBObjectNodeUtil.isOnlineNode(node = context.getNode()) && node instanceof DBObjectNode && (pro = DBObjectNodeUtil.findProvider(node)) != null) {
            DBUtil.forceObjectReset((String)((DBObjectNode)node).getObjectType(), (String)((DBObjectNode)node).getSchemaName(), (String)((DBObjectNode)node).getObjectName(), (DBObjectProvider)pro);
        }
        return retval;
    }

    public boolean update(IdeAction action, Context context) {
        boolean retval = false;
        boolean enabled = false;
        int cmdID = action.getCommandId();
        DBObjectNode node = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
        if (cmdID == DBObjectActions.getDuplicateAction().getCommandId()) {
            retval = true;
            if (node != null) {
                enabled = DBEditorFactoryRegistry.getCreateFactory(node) != null;
            }
        } else if (cmdID == DBObjectActions.getPropertiesAction().getCommandId()) {
            if (node != null) {
                retval = true;
                enabled = DBObjectNodeUtil.isOnlineNode(node) && DBEditorFactoryRegistry.getEditFactory(node) != null;
            }
        } else if (cmdID == DBObjectActions.getSynchronizeSpecAndBody().getCommandId()) {
            retval = true;
            if (node != null) {
                enabled = true;
            }
        } else if (cmdID == DBObjectActions.getTestQueryAction().getCommandId()) {
            retval = true;
            enabled = PlSqlQueryTester.enableTestQuery(context);
        }
        if (retval) {
            action.setEnabled(enabled);
        }
        return retval;
    }
}

