/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.UIManager;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;
import oracle.javatools.ui.simplestyle.StyledTextModel;

final class PlSqlBreadcrumb
implements Breadcrumb<Integer> {
    private static final StyledTextAttribute NORMAL_ATTR;
    private static final StyledTextAttribute BOLD_ATTR;
    private StyledTextModel m_shortName;
    private StyledTextModel m_longName;
    private int m_startOffset;
    private PlSqlCodeFragment m_source;
    private String m_peekText;

    PlSqlBreadcrumb(String boldPart, String normalPart, int startOffset, PlSqlCodeFragment source, String peekText) {
        this.m_shortName = new StyledTextModel(boldPart, BOLD_ATTR);
        this.m_longName = new StyledTextModel();
        this.m_longName.addText(boldPart, BOLD_ATTR);
        if (normalPart != null) {
            this.m_longName.addText(normalPart, NORMAL_ATTR);
        }
        this.m_startOffset = startOffset;
        this.m_source = source;
        this.m_peekText = peekText;
    }

    public StyledTextModel getShortName() {
        return this.m_shortName;
    }

    public StyledTextModel getLongName() {
        return this.m_longName;
    }

    public Integer getUserObject() {
        return this.m_startOffset;
    }

    public boolean canHavePopupItems() {
        return this.m_source instanceof PlSqlSchemaObjectSpec || this.m_source instanceof PlSqlSchemaObjectBody;
    }

    public List<PopupItem> getPopupItems() {
        if (this.canHavePopupItems()) {
            DBUIProgressBar pbar = new DBUIProgressBar(UIBundle.format("PLSQL_BREADCRUMBS_TASK", this.m_source.getName()));
            List<PopupItem> items = pbar.execute(new DBUIProgressBar.ProgressCallable<List<PopupItem>, RuntimeException>(){

                @Override
                public List<PopupItem> call() {
                    ArrayList<PopupItem> items = new ArrayList<PopupItem>();
                    for (PlSqlSubProgram child : ((PlSqlSchemaObject)PlSqlBreadcrumb.this.m_source).getSubPrograms()) {
                        PopupItem item = new PopupItem();
                        String sig = child.getSignature();
                        if (sig.length() > 100) {
                            sig = sig.substring(0, 100) + "...";
                        }
                        item.setName(sig);
                        item.setUserObject((Object)child.getStartOffset());
                        items.add(item);
                    }
                    Collections.sort(items);
                    return items;
                }
            });
            if (!pbar.hasUserCancelled()) {
                return items;
            }
        }
        return Collections.emptyList();
    }

    public String getPeekText() {
        return this.m_peekText;
    }

    static {
        Font font = UIManager.getFont("Label.font");
        NORMAL_ATTR = new StyledTextAttribute(font, null);
        BOLD_ATTR = new StyledTextAttribute(font.deriveFont(1), null);
    }
}

