/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.ide.db.components.ComponentWrapper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;

public class DatatypeReferenceWrapper
extends ComponentWrapper<JComboBox> {
    public DatatypeReferenceWrapper() {
        super(new JComboBox());
        ((JComboBox)this.getActiveComponent()).setEditable(true);
    }

    @Override
    public Object getPropertyValue() {
        String datatype = (String)((JComboBox)this.getActiveComponent()).getEditor().getItem();
        PlSqlReference retval = null;
        DBObject obj = this.getComponentContext().getUpdatedObject();
        Schema defaultSchema = DBUtil.getSchema((DBObject)obj);
        DBObjectProvider pro = this.getProvider();
        if (obj instanceof PlSqlParameter) {
            PlSqlParameter param = (PlSqlParameter)obj;
            PlSqlReference ref = param.getDataTypeReference();
            String str = DataTypeHelper.getTypeStringFromRef((PlSqlReference)ref, (Schema)defaultSchema, (DBObjectProvider)pro);
            retval = str.equals(datatype) ? ref : DataTypeHelper.getDataTypeRefForString((DBObjectProvider)pro, (Schema)defaultSchema, (String)datatype);
        } else if (datatype != null && datatype.trim().length() > 0) {
            retval = DataTypeHelper.getDataTypeRefForString((DBObjectProvider)pro, (Schema)defaultSchema, (String)datatype);
        }
        return retval;
    }

    @Override
    public void setPropertyValue(Object val) {
        if (val instanceof PlSqlReference) {
            PlSqlReference ref = (PlSqlReference)val;
            DBObjectProvider pro = this.getProvider();
            Schema schema = null;
            try {
                schema = pro.getDefaultSchema();
            }
            catch (DBException e) {
                this.getLogger().warning(e.getMessage());
            }
            String fromRef = DataTypeHelper.getTypeStringFromRef((PlSqlReference)ref, (Schema)schema, (DBObjectProvider)pro);
            ((JComboBox)this.getActiveComponent()).setSelectedItem(fromRef);
        } else {
            ((JComboBox)this.getActiveComponent()).setSelectedIndex(-1);
        }
    }

    @Override
    protected void initialiseComponentListener() {
        ((JComboBox)this.getActiveComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatatypeReferenceWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        ArrayList dataTypeNames = new ArrayList();
        dataTypeNames.addAll(this.getProvider().getDescriptor().listPreferredDataTypeNames());
        for (String dt : dataTypeNames) {
            model.addElement(dt);
        }
        ((JComboBox)this.getActiveComponent()).setModel(model);
    }
}

