/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.controls.ExtendedTable;

public abstract class ExtendedTableComponentWrapper<T extends ExtendedTable>
extends AsynchronousComponentWrapper<JComponent> {
    private T m_extendedTable;

    public ExtendedTableComponentWrapper(T table) {
        this(table, true);
    }

    public ExtendedTableComponentWrapper(T table, boolean tableContainerIsActiveComponent) {
        super(tableContainerIsActiveComponent ? ((ExtendedTable)table).getComponent() : ((ExtendedTable)table).getComponent().getTableContainer());
        this.m_extendedTable = table;
    }

    public final T getExtendedTable() {
        return this.m_extendedTable;
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        if (this.getComponentContext().isInFlatEditor()) {
            this.getComponent().setPreferredSize(new Dimension(200, 100));
        }
    }

    @Override
    protected void initialiseComponentListener() {
        ((ExtendedTable)this.m_extendedTable).addTableModelListener(new ExtendedTable.ExtendedTableModelListener(){

            @Override
            public void cellValueEdited(TableModelEvent e) {
                if (ExtendedTableComponentWrapper.this.isActive()) {
                    ExtendedTableComponentWrapper.this.markDirty();
                }
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                if (ExtendedTableComponentWrapper.this.isActive()) {
                    ExtendedTableComponentWrapper.this.markDirty();
                }
            }
        });
    }

    @Override
    protected Component createComponentForLayout() {
        return ((ExtendedTable)this.m_extendedTable).getComponent();
    }

    @Override
    protected void prepareForWrite() {
        ((ExtendedTable)this.m_extendedTable).stopCellEditing();
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getActiveComponent();
    }

    @Override
    public Component[] getFocusComponents() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ((ExtendedTable)this.m_extendedTable).setEnabled(enabled);
    }
}

