/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.ui.PopupButton;
import oracle.javatools.ui.plaf.IconicButtonUI;

public abstract class TableCellEditorWithPopup
extends AbstractCellEditor
implements TableCellEditor {
    private final DBUIResourceHelper m_helper;
    private final ExtendedTextField m_editor;
    private final EditButton m_button;
    private boolean m_popupShowing;

    public TableCellEditorWithPopup(String baseName) {
        this(baseName, false, true, null);
    }

    public TableCellEditorWithPopup(String baseName, boolean multiLine, boolean editable, Icon icon) {
        this.m_helper = new DBUIResourceHelper(baseName);
        this.m_editor = new ExtendedTextField();
        this.m_editor.setAllowBreaks(multiLine);
        this.m_helper.setName((Component)this.m_editor, "Editor");
        this.m_button = new EditButton();
        this.m_button.setPopupLocation(PopupButton.PopupLocation.BOTTOM_LEFT);
        if (icon != null) {
            this.m_button.setIcon(icon);
        }
        IconicButtonUI.install((AbstractButton)((Object)this.m_button));
        this.m_helper.setName((Component)((Object)this.m_button), "PopupButton");
    }

    protected final ExtendedTextField getEditor() {
        return this.m_editor;
    }

    protected final DBUIResourceHelper getResourceHelper() {
        return this.m_helper;
    }

    protected final JPanel getPopupPanel() {
        return this.m_button.m_panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_editor.getText();
    }

    protected boolean supportsPopup(JTable table, Object value, int row, int column) {
        return true;
    }

    protected String getEditorText(JTable table, Object value, int row, int column) {
        String retval = value instanceof String ? (String)value : null;
        return retval;
    }

    @Override
    public boolean stopCellEditing() {
        this.hidePopup();
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String text = this.getEditorText(table, value, row, column);
        this.m_editor.setText(text);
        if (this.supportsPopup(table, value, row, column)) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.m_editor, "Center");
            panel.add((Component)((Object)this.m_button), "East");
            String popup = "popup";
            InputMap im = panel.getInputMap(1);
            im.put(KeyStroke.getKeyStroke(40, 0), "popup");
            panel.getActionMap().put("popup", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableCellEditorWithPopup.this.showPopup();
                }
            });
            return panel;
        }
        return this.m_editor;
    }

    protected Integer getPreferredPopupHeight() {
        return 200;
    }

    protected final void hidePopup() {
        this.m_button.hidePopup();
    }

    protected final void showPopup() {
        this.m_button.showPopup();
    }

    protected abstract void initPopup(JPanel var1);

    protected abstract void commitPopup();

    protected final boolean isPopupShowing() {
        return this.m_popupShowing;
    }

    private class EditButton
    extends PopupButton {
        private final JPanel m_panel;

        EditButton() {
            this.m_panel = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    Integer prefHeight = TableCellEditorWithPopup.this.getPreferredPopupHeight();
                    int height = prefHeight == null ? super.getPreferredSize().height : prefHeight;
                    int width = TableCellEditorWithPopup.this.m_editor.getWidth() + EditButton.this.getWidth();
                    return new Dimension(width, height);
                }
            };
            this.setPopupContent(this.m_panel);
        }

        protected void hidePopup() {
            super.hidePopup();
            TableCellEditorWithPopup.this.m_popupShowing = false;
            TableCellEditorWithPopup.this.commitPopup();
        }

        protected void showPopup() {
            TableCellEditorWithPopup.this.initPopup(this.m_panel);
            super.showPopup();
            TableCellEditorWithPopup.this.m_popupShowing = true;
        }
    }
}

