/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.javatools.util.ModelUtil;

public class TextFieldWithCheckBoxPanel
extends JPanel {
    private final JTextField m_text = new JTextField();
    private final JCheckBox m_chk = new JCheckBox();
    private boolean m_presetState;
    private String m_presetValue;

    public TextFieldWithCheckBoxPanel() {
        DBUILayoutHelper helper = new DBUILayoutHelper(this);
        helper.setMargins(0);
        helper.add(this.m_chk);
        helper.add(this.m_text);
        GridBagConstraints gbc = helper.getConstraints(this.m_text);
        gbc.insets.left = 8;
        helper.layout();
        this.m_chk.addActionListener(new ActionListener(){
            String m_lastValue = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (((JCheckBox)src).isSelected() == TextFieldWithCheckBoxPanel.this.m_presetState) {
                    TextFieldWithCheckBoxPanel.this.m_text.setEnabled(false);
                    this.m_lastValue = TextFieldWithCheckBoxPanel.this.m_text.getText();
                    TextFieldWithCheckBoxPanel.this.m_text.setText(TextFieldWithCheckBoxPanel.this.m_presetValue);
                } else {
                    TextFieldWithCheckBoxPanel.this.m_text.setEnabled(true);
                    TextFieldWithCheckBoxPanel.this.m_text.setText(this.m_lastValue);
                }
            }
        });
    }

    public void setCheckLabel(String label) {
        this.m_chk.setText(label);
    }

    public void setCheckStateForPreset(boolean state) {
        this.m_presetState = state;
    }

    public void setPresetValue(String value) {
        this.m_presetValue = value;
    }

    public void setValue(String value) {
        this.m_text.setText(value);
        if (ModelUtil.areEqual((Object)value, (Object)this.m_presetValue)) {
            this.m_text.setEnabled(false);
            this.m_chk.setSelected(this.m_presetState);
        }
    }

    public String getValue() {
        if (ModelUtil.areEqual((Object)this.m_chk.isSelected(), (Object)this.m_presetState)) {
            return this.m_presetValue;
        }
        return this.m_text.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_chk.setEnabled(enabled);
        this.m_text.setEnabled(enabled && this.m_chk.isSelected() != this.m_presetState);
    }

    @Override
    public boolean isEnabled() {
        return this.m_chk.isEnabled();
    }

    @Override
    public final void setName(String name) {
        this.m_text.setName(name);
        this.m_chk.setName(name + "_check");
    }

    public final void addItemListener(ItemListener l) {
        this.m_chk.addItemListener(l);
    }

    public final Document getDocument() {
        return this.m_text.getDocument();
    }

    public final JCheckBox getCheckBox() {
        return this.m_chk;
    }
}

