/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.panels.partition.ExtendedPartitionType;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.ModelUtil;

public class ValuesPropertyPanel
extends JPanel {
    private final JLabel m_label = new JLabel();
    private final JTextField m_text = new JTextField();
    private final JCheckBox m_check = new JCheckBox();
    private ExtendedPartitionType m_type = ExtendedPartitionType.UNDEFINED;
    private DBObject m_partition;
    private final Collection<ChangeListener> m_listeners = new ArrayList<ChangeListener>();
    private static final String DEFAULT = "DEFAULT";
    private static final String MAXVALUE = "MAXVALUE";
    private static final String RANGE_OPTION = "RANGE_OPTION";
    private static final String LIST_OPTION = "LIST_OPTION";
    public static final String TEXTBOX_NAME = "PartitionVaues";
    public static final String CHECKBOX_NAME = "ValuesPropertyPanel.defaultCheckbox";

    public ValuesPropertyPanel() {
        this.setName("ValuesPropertyPanel");
        this.m_text.setName(TEXTBOX_NAME);
        this.m_check.setName(CHECKBOX_NAME);
        this.m_label.setLabelFor(this.m_text);
        DBUIMnemonicBuilder.addLabelOption(this.m_label, RANGE_OPTION, UIBundle.get("PARTITIONS_RANGE_VALUE_LABEL"));
        DBUIMnemonicBuilder.addLabelOption(this.m_check, RANGE_OPTION, UIBundle.get("PARTITIONS_RANGE_CHECKBOX"));
        DBUIMnemonicBuilder.addLabelOption(this.m_label, LIST_OPTION, UIBundle.get("PARTITIONS_LIST_VALUE_LABEL"));
        DBUIMnemonicBuilder.addLabelOption(this.m_check, LIST_OPTION, UIBundle.get("PARTITIONS_LIST_CHECKBOX"));
        DBUILayoutHelper layout = new DBUILayoutHelper(this);
        layout.add(this.m_label, 1, 1, false, false);
        layout.add(this.m_text, 1, 1, true, false);
        layout.add(this.m_check, 1, 1, false, false);
        layout.layout();
        ActionListener checkboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValuesPropertyPanel.this.enableTextControl();
                JCheckBox check = (JCheckBox)e.getSource();
                if (check.isSelected()) {
                    if (ValuesPropertyPanel.this.m_type.isList()) {
                        ValuesPropertyPanel.this.m_text.setText(ValuesPropertyPanel.DEFAULT);
                    } else if (ValuesPropertyPanel.this.m_type.isRange()) {
                        ValuesPropertyPanel.this.m_text.setText(ValuesPropertyPanel.this.getValuesAsString(ValuesPropertyPanel.this.getMaxValuesAsArray()));
                    }
                } else {
                    ValuesPropertyPanel.this.m_text.setText(null);
                }
                ValuesPropertyPanel.this.notifyListeners();
            }
        };
        this.m_check.addActionListener(checkboxListener);
    }

    public void initialisePanel(DBObject partition) {
        this.m_partition = partition;
        this.m_type = ExtendedPartitionType.getType(partition);
        this.setLabelText(this.m_type);
    }

    public Document getDocument() {
        return this.m_text.getDocument();
    }

    public Object getValues() {
        if (this.m_type.isList() && this.m_check.isSelected()) {
            return new Object[]{DEFAULT};
        }
        if (this.m_type.isRange() && this.m_check.isSelected()) {
            return this.getMaxValuesAsArray();
        }
        String text = this.m_text.getText();
        List bits = TablePartition.splitValues((String)text);
        Object[] ret = new Object[bits.size()];
        int index = 0;
        for (String bit : bits) {
            ret[index++] = bit.trim();
        }
        return ret;
    }

    public void setValues(Object values) {
        if (values instanceof Object[]) {
            String stringValue = this.getValuesAsString((Object[])values);
            if (this.m_type.isList()) {
                this.m_check.setSelected(DEFAULT.equalsIgnoreCase(stringValue));
            } else if (this.m_type.isRange()) {
                this.m_check.setSelected(ModelUtil.hasLength((String)stringValue) && this.getValuesAsString(this.getMaxValuesAsArray()).equalsIgnoreCase(stringValue));
            }
            this.enableTextControl();
            this.m_text.setText(stringValue);
        } else {
            this.m_text.setText(null);
        }
    }

    public void setLabelText(ExtendedPartitionType type) {
        if (type.isList()) {
            DBUIMnemonicBuilder.setLabelOption(this.m_label, LIST_OPTION);
            DBUIMnemonicBuilder.setLabelOption(this.m_check, LIST_OPTION);
        } else {
            DBUIMnemonicBuilder.setLabelOption(this.m_label, RANGE_OPTION);
            DBUIMnemonicBuilder.setLabelOption(this.m_check, RANGE_OPTION);
        }
    }

    private void enableTextControl() {
        this.m_text.setEnabled(this.isEnabled() && !this.m_check.isSelected());
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.m_label.setVisible(visible);
        this.m_text.setVisible(visible);
        this.m_check.setVisible(visible);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_label.setEnabled(enabled);
        this.m_text.setEnabled(enabled);
        this.m_check.setEnabled(enabled);
    }

    public Component[] getFocusComponents() {
        return new Component[]{this.m_text, this.m_check};
    }

    public final void addChangeListener(ChangeListener l) {
        this.removeChangeListener(l);
        this.m_listeners.add(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.m_listeners.remove(l);
    }

    protected void notifyListeners() {
        for (ChangeListener cl : this.m_listeners) {
            cl.valuesChanged();
        }
    }

    private Object[] getMaxValuesAsArray() {
        int numMaxVals = 0;
        if (this.m_partition instanceof TablePartition) {
            TablePartition tp = (TablePartition)this.m_partition;
            Table parentTable = (Table)DBUtil.findParentOfType((DBObject)tp, Table.class);
            OracleTablePartitions otp = (OracleTablePartitions)parentTable.getProperty("OracleTablePartitions");
            if (tp.getObjectType() != OracleTablePartitions.ObjectType.PARTITION) {
                otp = otp.getSubpartitionModel();
            }
            numMaxVals = otp != null ? otp.getPartitionColumns().length : 0;
        } else if (this.m_type == ExtendedPartitionType.INDEX_GLOBAL_RANGE) {
            OracleIndexPartitions oip = (OracleIndexPartitions)this.m_partition.getParent();
            numMaxVals = oip != null ? oip.getGlobalPartitionColumns().length : 0;
        }
        Object[] values = new Object[numMaxVals];
        for (int i = 0; i < numMaxVals; ++i) {
            values[i] = MAXVALUE;
        }
        return values;
    }

    private String getValuesAsString(Object[] values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(values[i]);
        }
        return sb.toString();
    }

    public static void updateIndexPartitionMaxValues(int numMaxVals, Index index) {
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (oip != null && oip.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            for (IndexPartition ip : oip.getPartitions()) {
                if (!ValuesPropertyPanel.areMaxValues(ip.getValuesLessThan())) continue;
                ValuesPropertyPanel.applyNewMaxValues(numMaxVals, (DBObject)ip);
            }
        }
    }

    public static void updateTablePartitionMaxValues(int numMaxVals, Table table, boolean applyToSubs) {
        OracleTablePartitions otp = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        if (otp != null) {
            ValuesPropertyPanel.processMaxValsForTablePartitions(numMaxVals, otp.getPartitions(), applyToSubs);
        }
    }

    private static void applyNewMaxValues(int numMaxVals, DBObject partition) {
        Object[] values = new Object[numMaxVals];
        for (int i = 0; i < numMaxVals; ++i) {
            values[i] = MAXVALUE;
        }
        if (partition instanceof TablePartition) {
            ((TablePartition)partition).setValues(values);
        } else if (partition instanceof IndexPartition) {
            ((IndexPartition)partition).setValuesLessThan(values);
        }
    }

    private static void processMaxValsForTablePartitions(int numMaxVals, TablePartition[] partitions, boolean processSubs) {
        for (TablePartition tp : partitions) {
            if (processSubs) {
                OracleTablePartitions subParts = tp.getPartitionLevelSubpartitions();
                if (subParts == null || subParts.getPartitionType() != OracleTablePartitions.PartitionType.RANGE) continue;
                TablePartition[] subs = subParts.getPartitions();
                ValuesPropertyPanel.processMaxValsForTablePartitions(numMaxVals, subs, false);
                continue;
            }
            if (tp.getPartitionType() != OracleTablePartitions.PartitionType.RANGE || !ValuesPropertyPanel.areMaxValues(tp.getValues())) continue;
            ValuesPropertyPanel.applyNewMaxValues(numMaxVals, (DBObject)tp);
        }
    }

    private static boolean areMaxValues(Object[] values) {
        boolean isMax = values.length > 0;
        for (Object value : values) {
            if (value instanceof String) {
                if (!MAXVALUE.equals(value)) {
                    isMax = false;
                }
            } else if (value != TablePartition.RangeValue.MAXVALUE) {
                isMax = false;
            }
            if (!isMax) break;
        }
        return isMax;
    }

    public static interface ChangeListener {
        public void valuesChanged();
    }
}

