/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.db.dialogs.BaseDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;

public class DBObjectOverviewEditorPanel<T extends DBObject>
implements DBTraversable {
    private final JPanel m_panel = new JPanel();
    private final PanelLibrary<T> m_panelLib;
    private final Namespace m_namespace;
    private final TabbedEditorPanel m_tabbedPane;

    public DBObjectOverviewEditorPanel(PanelLibrary<T> lib, Namespace ns) {
        this.m_panelLib = lib;
        this.m_namespace = ns;
        DBEditorConfig editorConfig = (DBEditorConfig)this.m_namespace.find(DBEditorConfig.class);
        if (editorConfig == null) {
            throw new IllegalStateException("DBEditorConfig cannot be null");
        }
        List<Navigable> navList = this.m_panelLib.getNavigables(editorConfig);
        Navigable[] navs = navList.toArray(new Navigable[navList.size()]);
        String startingPage = this.getStartPage(editorConfig);
        if (startingPage == null && this.newlyCreated() && navs.length > 1 && this.m_panelLib.getSkipGeneralForNewObject()) {
            startingPage = navs[1].getShortLabel();
        }
        this.m_tabbedPane = new TabbedEditorPanel(null, navs, startingPage);
        this.m_tabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        this.m_panel.removeAll();
        this.m_panel.setLayout(new BorderLayout());
        this.m_panel.add(this.m_tabbedPane.getComponent(), "Center");
    }

    void resetCurrentPage() {
        DBEditorConfig editorConfig;
        String startPage;
        if (this.m_tabbedPane != null && (startPage = this.getStartPage(editorConfig = (DBEditorConfig)this.m_namespace.find(DBEditorConfig.class))) != null) {
            this.m_tabbedPane.setStartPage(startPage);
        }
    }

    private String getStartPage(DBEditorConfig editorConfig) {
        return this.m_panelLib.getStartPage(editorConfig);
    }

    Navigable getCurrentNavigable() {
        return this.m_tabbedPane.getCurrentNavigable();
    }

    public void onEntry(TraversableContext dataContext) {
        PanelLibrary.PanelSetChanger changer = (PanelLibrary.PanelSetChanger)dataContext.find(PanelLibrary.PanelSetChanger.class);
        if (changer != null) {
            List<Navigable> navList = this.m_panelLib.getNavigables((DBEditorConfig)this.m_namespace.find(DBEditorConfig.class));
            Navigable[] navs = navList.toArray(new Navigable[navList.size()]);
            try {
                changer.panelSetChange(navs, null);
            }
            catch (TraversalException te) {
                DBLog.getLogger((Object)this).warning(te.getMessage());
            }
        }
        this.m_tabbedPane.onEntry(dataContext);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.m_tabbedPane.onExit(dataContext);
    }

    public Component getComponent() {
        return this.m_panel;
    }

    @Override
    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return this.m_tabbedPane.getHelpID();
    }

    private boolean newlyCreated() {
        Context context = (Context)this.m_namespace.find(Context.class);
        return context != null && BaseDBEditorFactory.isCreateContext(context);
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.m_tabbedPane.getDefaultFocusComponent();
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        return this.m_tabbedPane.requestFocusForEditorConfig();
    }
}

