/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.extension;

import java.awt.HeadlessException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.wizard.Step;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ImageIconCache;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.deferred.Thunk;

public abstract class AbstractExtensionHook {
    protected static final String TEXT_KEY = "#text";
    protected static final String NAMESPACE = "http://xmlns.oracle.com/ide/extension/db";
    private static Map<String, AbstractExtensionHook> s_hooks = new TreeMap<String, AbstractExtensionHook>();
    private HashStructureHookListener m_listener;
    private HashStructure m_currentHash;
    private HashStructureHook m_hook;
    private ElementName m_elementName;
    private final Map<String, HashProcessor> m_processors = new HashMap<String, HashProcessor>();

    private synchronized HashStructureHook getHook() {
        if (this.m_hook == null) {
            this.m_hook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(this.m_elementName);
            if (this.m_hook == null) {
                throw new IllegalArgumentException("Cannot find hook " + this.m_elementName.getLocalName());
            }
            this.initialize();
        }
        return this.m_hook;
    }

    final void setElementName(ElementName name) {
        this.m_elementName = name;
    }

    private void cacheProcessor(Class clz, HashProcessor p) {
        this.m_processors.put(clz.getName(), p);
    }

    private List<HashThunk> getProcessedList(Class clz) {
        HashProcessorList retval = null;
        HashProcessor hp = this.m_processors.get(clz.getName());
        if (hp instanceof HashProcessorList) {
            retval = (HashProcessorList)hp;
        }
        return retval;
    }

    protected final <T> List<T> getList(Class<T> clz) {
        ArrayList<Object> retval = new ArrayList<Object>();
        List<HashThunk> thunks = this.getProcessedList(clz);
        if (thunks != null) {
            for (HashThunk t : thunks) {
                try {
                    Object whatsit = t.get();
                    if (whatsit == null) continue;
                    retval.add(whatsit);
                }
                catch (ClassCastException e) {
                    this.logClassCastError(t.m_hash, t.m_clzName, clz.getName());
                }
            }
        }
        return retval;
    }

    protected final synchronized void checkListenerInit() {
        if (this.m_listener == null) {
            this.m_listener = new HashStructureHookListener(){

                public void listenerAttached(HashStructureHookEvent e) {
                    AbstractExtensionHook.this.incomingHashStructure(e.getCombinedHashStructure());
                }

                public void elementVisited(HashStructureHookEvent e) {
                    AbstractExtensionHook.this.incomingHashStructure(e.getNewElementHashStructure());
                }
            };
            this.getHook().addHashStructureHookListener(this.m_listener);
        }
    }

    protected void initialize() {
    }

    private synchronized void incomingHashStructure(HashStructure hash) {
        this.processHashStructure(hash);
        for (HashProcessor dp : this.m_processors.values()) {
            dp.process(hash);
        }
    }

    protected void processHashStructure(HashStructure hash) {
    }

    private final HashStructure getSingleChild(HashStructure hash, String name) {
        HashStructure retval = null;
        List kids = hash.getAsList(name);
        if (kids != null && kids.size() > 0) {
            retval = (HashStructure)kids.get(0);
        }
        return retval;
    }

    protected final void fullyLoadExtension(HashStructure hash, String reason) {
        ExtensionRegistry reg;
        Extension extension;
        String extensionID = HashStructureHook.getExtensionId((HashStructure)hash);
        if (extensionID != null && (extension = (reg = ExtensionRegistry.getExtensionRegistry()).findExtension(extensionID)) != null) {
            reg.fullyLoadExtension(extension, reason);
        }
    }

    protected final <T> MetaClass<T> getSingleChildMeta(HashStructure hash, String name, Class<T> clz) {
        MetaClass retval = null;
        HashStructure childHash = this.getSingleChild(hash, name);
        if (childHash != null) {
            retval = this.getMetaClass(childHash);
        }
        return retval;
    }

    protected final MetaClass getMetaClass(HashStructure hash) {
        LazyClassAdapter adapter = LazyClassAdapter.getInstance((HashStructure)hash);
        return adapter.getMetaClass(TEXT_KEY);
    }

    protected final Step loadStep(HashStructure stepHash) {
        Step step = null;
        String title = this.getText(stepHash, "title");
        Class<Traversable> clz = this.loadClass(stepHash, "panel-class", Traversable.class);
        if (clz != null) {
            String helpID = this.getText(stepHash, "help-id", false);
            String stepLabel = this.getText(stepHash, "step-label", false);
            step = new Step(title, clz, helpID);
            if (ModelUtil.hasLength((String)stepLabel)) {
                step.setStepLabel(stepLabel);
            }
        }
        return step;
    }

    protected final Navigable loadNavigable(HashStructure navHash) {
        DBNavigable nav = null;
        String title = this.getText(navHash, "title");
        Class<Traversable> clz = this.loadClass(navHash, "panel-class", Traversable.class);
        if (clz != null) {
            List<String> props = this.getChildTextList(navHash, "panel-properties", "property");
            if (props.size() > 0) {
                nav = new DBNavigable(title, clz);
                nav.setProperties(props);
            } else {
                nav = new Navigable(title, clz);
            }
            String helpID = this.getText(navHash, "help-id", false);
            if (ModelUtil.hasLength((String)helpID)) {
                nav.setHelpID(helpID);
            }
        }
        return nav;
    }

    protected final List<Navigable> loadNavigables(List<HashStructure> navHashes) {
        ArrayList<Navigable> retval = new ArrayList<Navigable>();
        for (HashStructure edHash : navHashes) {
            Navigable nav = this.loadNavigable(edHash);
            if (nav == null) continue;
            retval.add(nav);
        }
        return retval;
    }

    protected boolean isAssignableFrom(String clzName, Class clz) {
        boolean retval = false;
        if (ModelUtil.hasLength((String)clzName)) {
            block0: for (Class toTest = clz; toTest != null && !retval; toTest = toTest.getSuperclass()) {
                if (clzName.equals(toTest.getName())) {
                    retval = true;
                    break;
                }
                for (Class<?> iFace : toTest.getInterfaces()) {
                    if (!clzName.equals(iFace.getName())) continue;
                    retval = true;
                    continue block0;
                }
            }
        }
        return retval;
    }

    protected <T> Class<? extends T> loadAPIClass(HashStructure hash, Class<T> clz) {
        Class<Object> retval = null;
        String clzName = HashStructureHook.getText((HashStructure)hash);
        try {
            retval = Class.forName(clzName);
        }
        catch (ClassNotFoundException cnfe) {
            retval = this.loadClass(hash, clz);
        }
        return retval;
    }

    public final <T> Class<? extends T> loadAPIClass(HashStructure hash, String childName, Class<T> clz) {
        Class<T> retval = null;
        HashStructure childHash = hash.getHashStructure(childName);
        if (childHash != null) {
            retval = this.loadAPIClass(childHash, clz);
        }
        return retval;
    }

    public final <T> Class<? extends T> loadClass(HashStructure hash, Class<T> clz) {
        Class retval = null;
        String elemName = hash.getStructName();
        MetaClass mc = this.getMetaClass(hash);
        if (mc != null) {
            try {
                retval = mc.toClass();
            }
            catch (ClassNotFoundException cne) {
                this.logClassCastError(hash, HashStructureHook.getText((HashStructure)hash), clz.getName());
            }
            catch (Throwable t) {
                this.logError(hash, UIBundle.format("EXTENSION_CLASS_ERR", HashStructureHook.getText((HashStructure)hash), t.getMessage()));
            }
        }
        return retval;
    }

    public final <T> Class<? extends T> loadClass(HashStructure hash, String childName, Class<T> clz) {
        Class<T> retval = null;
        HashStructure childHash = hash.getHashStructure(childName);
        if (childHash != null) {
            retval = this.loadClass(childHash, clz);
        }
        return retval;
    }

    public final <T> Thunk<T> createInstanceThunk(HashStructure hash, Class<T> clz) {
        return new HashThunk<T>(hash, clz);
    }

    public final <T> Thunk<Class<? extends T>> createClassThunk(HashStructure hash, Class<T> clz) {
        return new HashClassThunk<T>(hash, clz);
    }

    public final <T> Thunk<Class<? extends T>> createClassThunk(HashStructure hash, String elemName, Class<T> clz) {
        Thunk<Class<T>> retval = null;
        HashStructure clzHash = hash.getHashStructure(elemName);
        if (clzHash == null) {
            this.logMissingElemError(hash, elemName);
        } else {
            retval = this.createClassThunk(clzHash, clz);
        }
        return retval;
    }

    public final <T> T instantiateClass(HashStructure hash, Class<T> clz) {
        return this.instantiateClass(null, hash, clz, null, null);
    }

    public final <T> T instantiateClass(HashStructure hash, Class<T> clz, Class<?>[] constrParamTypes, Object[] constrParams) {
        return this.instantiateClass(null, hash, clz, constrParamTypes, constrParams);
    }

    private final <T> T instantiateClass(List<Thunk> existing, HashStructure hash, Class<T> clz, Class<?>[] constrParamTypes, Object[] constrParams) {
        T retval = null;
        Class<T> clzFromHash = this.loadClass(hash, clz);
        if (clzFromHash != null && !this.contains(existing, clzFromHash)) {
            String elemName = hash.getStructName();
            try {
                if (constrParams == null || constrParams.length == 0) {
                    retval = clzFromHash.newInstance();
                } else {
                    Constructor<T> c = clzFromHash.getConstructor(constrParamTypes);
                    if (c == null) {
                        this.logError(hash, UIBundle.format("EXTENSION_CONSTR_SIG", clzFromHash.getName(), constrParamTypes));
                    } else {
                        retval = c.newInstance(constrParams);
                    }
                }
            }
            catch (ClassCastException cce) {
                this.logClassCastError(hash, clzFromHash.getName(), clz.getName());
            }
            catch (HeadlessException he) {
                throw he;
            }
            catch (Throwable t) {
                String msg = UIBundle.format("EXTENSION_CLASS_ERR", clzFromHash.getName(), t.getMessage());
                DBLog.logStackTrace((String)msg, (Throwable)t);
                this.logError(hash, msg);
            }
        }
        return retval;
    }

    private boolean contains(List<Thunk> existing, Class clzFromHash) {
        boolean retval = false;
        if (existing != null) {
            for (Thunk o : existing) {
                if (!o.getClass().equals(clzFromHash)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    protected final void logError(HashStructure hash, String errorMessage) {
        this.logMessage(hash, Level.SEVERE, errorMessage);
    }

    protected final void logWarning(HashStructure hash, String message) {
        this.logMessage(hash, Level.WARNING, message);
    }

    protected final void logMessage(HashStructure hash, Level level, String message) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        er.getManifestLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, this.m_elementName.getLocalName() + ": " + message, er.findExtension(HashStructureHook.getExtensionId((HashStructure)hash)), 0));
    }

    protected final void logClassCastError(HashStructure hash, String extClass, String expClass) {
        this.logError(hash, UIBundle.format("EXTENSION_CLASS_CAST", extClass, expClass));
    }

    protected final void logMissingElemError(HashStructure hash, String missingElemName) {
        this.logMissingElemError(hash, null, missingElemName);
    }

    protected final void logMissingElemError(HashStructure hash, String parentElemName, String missingElemName) {
        this.logMissingElemsError(hash, parentElemName, missingElemName);
    }

    protected final void logMissingElemsError(HashStructure hash, String parentElemName, String ... missingElemNames) {
        if (parentElemName == null) {
            String name = hash.getStructName();
            try {
                String[] bits;
                if (Integer.valueOf(name) != null && (bits = (name = hash.getFullName()).split("/")).length > 1) {
                    name = bits[bits.length - 2];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            parentElemName = name;
        }
        this.logError(hash, UIBundle.format("EXTENSION_ELEM_MISSING", missingElemNames, parentElemName));
    }

    protected final List<String> getChildTextList(HashStructure hash, String listName, String listElemName) {
        ArrayList<String> retval = new ArrayList<String>();
        for (HashStructure childHash : this.getChildList(hash, listName, listElemName)) {
            retval.add(HashStructureHook.getText((HashStructure)childHash));
        }
        return retval;
    }

    protected final List<HashStructure> getChildList(HashStructure hash, String listName, String listElemName) {
        ArrayList<HashStructure> retval = new ArrayList<HashStructure>();
        List list = hash.getAsList(listName);
        if (list != null) {
            for (HashStructure entry : list) {
                List kids = entry.getAsList(listElemName);
                if (kids == null) continue;
                retval.addAll(kids);
            }
        }
        return retval;
    }

    protected final List<? extends Thunk> createChildList(String listName, String listElemName, Class clz) {
        HashProcessorList retval = new HashProcessorList(listName, listElemName, clz);
        this.cacheProcessor(clz, retval);
        return retval;
    }

    protected final Map<String, Thunk> createChildMap(String listName, String listElemName, String idElemName, String clzElemName, Class clz) {
        HashProcessorMap retval = new HashProcessorMap(listName, listElemName, idElemName, clzElemName, clz);
        this.cacheProcessor(clz, retval);
        return retval;
    }

    private final void populateObjectMap(Map<String, Thunk> map, HashStructure hash, String listName, String listElemName, String idElemName, String clzElemName, Class clz) {
        for (HashStructure childListHash : this.getChildList(hash, listName, listElemName)) {
            String id = childListHash.getString(idElemName + "/" + TEXT_KEY);
            if (ModelUtil.hasLength((String)id)) {
                if (map.containsKey(id)) {
                    this.logError(childListHash, UIBundle.format("EXTENSION_DUP_KEY", listElemName, idElemName, id));
                    continue;
                }
                HashStructure clzHash = childListHash.getHashStructure(clzElemName);
                if (clzHash == null) {
                    this.logError(childListHash, UIBundle.format("EXTENSION_ELEM_MISSING", listElemName, clzElemName));
                    continue;
                }
                HashThunk t = new HashThunk(clzHash, clz);
                map.put(id, t);
                continue;
            }
            this.logError(childListHash, UIBundle.format("EXTENSION_ELEM_MISSING", listElemName, idElemName));
        }
    }

    private final void populateObjectList(List<HashThunk> list, HashStructure hash, String listName, String name, Class clz) {
        for (HashStructure childListHash : this.getChildList(hash, listName, name)) {
            String clzFromHash = HashStructureHook.getText((HashStructure)childListHash);
            if (!ModelUtil.hasLength((String)clzFromHash)) continue;
            boolean found = false;
            for (HashThunk exists : list) {
                if (!clzFromHash.equals(exists.m_clzName)) continue;
                found = true;
            }
            if (found) continue;
            list.add(0, new HashThunk(childListHash, clz));
        }
    }

    protected final String getText(HashStructure hash, String elemName) {
        return this.getText(hash, elemName, true);
    }

    protected final String getText(HashStructure hash, String elemName, boolean logErrorIfMissing) {
        HashStructure hs = hash.getHashStructure(elemName);
        String retval = null;
        if (hs != null) {
            retval = HashStructureHook.getText((HashStructure)hs);
        } else if (logErrorIfMissing) {
            this.logMissingElemError(hash, elemName);
        }
        return retval;
    }

    protected final Icon getIcon(HashStructure hash) {
        return this.getIcon(hash, "icon", true);
    }

    protected final Icon getIcon(HashStructure hash, String elemName, boolean logErrorIfMissing) {
        ImageIcon retval = null;
        String iconString = this.getText(hash, elemName, logErrorIfMissing);
        if (ModelUtil.hasLength((String)iconString)) {
            try {
                URL iconURL = URLFactory.newURL((String)iconString);
                retval = ImageIconCache.get((URL)iconURL);
            }
            catch (Exception e) {
                this.logError(hash, UIBundle.format("EXTENSION_ICON_LOADING_ERROR", e.getMessage()));
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AbstractExtensionHook> T findHook(ElementName name, Class<T> clz) {
        if (ModelUtil.areDifferent((Object)NAMESPACE, (Object)name.getNamespaceURI())) {
            throw new IllegalArgumentException("Can only be used for database hooks.");
        }
        AbstractExtensionHook retval = null;
        Map<String, AbstractExtensionHook> map = s_hooks;
        synchronized (map) {
            String localName = name.getLocalName();
            retval = s_hooks.get(localName);
            if (retval == null && Ide.isRunning()) {
                try {
                    retval = (AbstractExtensionHook)clz.newInstance();
                    retval.setElementName(name);
                    s_hooks.put(localName, retval);
                }
                catch (Throwable e) {
                    DBLog.getLogger(clz).log(Level.SEVERE, "Couldn't get hook " + localName + " from the extension registry.", e);
                }
            }
        }
        return (T)retval;
    }

    private class HashProcessorList
    extends AbstractList<HashThunk>
    implements HashProcessor {
        private final List<HashThunk> m_list = new ArrayList<HashThunk>();
        private final String m_listName;
        private final String m_name;
        private final Class m_clz;

        HashProcessorList(String listName, String name, Class clz) {
            this.m_listName = listName;
            this.m_name = name;
            this.m_clz = clz;
        }

        @Override
        public void process(HashStructure hash) {
            AbstractExtensionHook.this.populateObjectList(this.m_list, hash, this.m_listName, this.m_name, this.m_clz);
        }

        @Override
        public HashThunk get(int index) {
            AbstractExtensionHook.this.checkListenerInit();
            return this.m_list.get(index);
        }

        @Override
        public int size() {
            AbstractExtensionHook.this.checkListenerInit();
            return this.m_list.size();
        }
    }

    private class HashProcessorMap
    extends AbstractMap<String, Thunk>
    implements HashProcessor {
        private final Map<String, Thunk> m_map = new HashMap<String, Thunk>();
        private final String m_listName;
        private final String m_listElemName;
        private final String m_idElemName;
        private final String m_clzElemName;
        private final Class m_clz;

        HashProcessorMap(String listName, String listElemName, String idElemName, String clzElemName, Class clz) {
            this.m_listName = listName;
            this.m_listElemName = listElemName;
            this.m_idElemName = idElemName;
            this.m_clzElemName = clzElemName;
            this.m_clz = clz;
        }

        @Override
        public Set<Map.Entry<String, Thunk>> entrySet() {
            AbstractExtensionHook.this.checkListenerInit();
            return this.m_map.entrySet();
        }

        @Override
        public void process(HashStructure hash) {
            AbstractExtensionHook.this.populateObjectMap(this.m_map, hash, this.m_listName, this.m_listElemName, this.m_idElemName, this.m_clzElemName, this.m_clz);
        }
    }

    private static interface HashProcessor {
        public void process(HashStructure var1);
    }

    private class HashThunk<T>
    extends Thunk<T> {
        private HashStructure m_hash;
        private String m_clzName;
        private Class<T> m_clz;

        HashThunk(HashStructure hash, Class<T> clz) {
            this.m_hash = hash;
            this.m_clzName = HashStructureHook.getText((HashStructure)hash);
            this.m_clz = clz;
        }

        protected T compute() {
            return AbstractExtensionHook.this.instantiateClass(this.m_hash, this.m_clz);
        }
    }

    private class HashClassThunk<T>
    extends Thunk<Class<? extends T>> {
        private HashStructure m_hash;
        private Class<T> m_clz;

        HashClassThunk(HashStructure hash, Class<T> clz) {
            this.m_hash = hash;
            this.m_clz = clz;
        }

        protected Class<? extends T> compute() {
            return AbstractExtensionHook.this.loadClass(this.m_hash, this.m_clz);
        }
    }
}

